/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.dsl.gridLayout.impl;

import com.intellij.ui.dsl.gridLayout.Constraints;
import java.awt.Dimension;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ui/dsl/gridLayout/impl/PreCalculationData;", "", "minimumSize", "Ljava/awt/Dimension;", "preferredSize", "constraints", "Lcom/intellij/ui/dsl/gridLayout/Constraints;", "<init>", "(Ljava/awt/Dimension;Ljava/awt/Dimension;Lcom/intellij/ui/dsl/gridLayout/Constraints;)V", "getMinimumSize", "()Ljava/awt/Dimension;", "getPreferredSize", "getConstraints", "()Lcom/intellij/ui/dsl/gridLayout/Constraints;", "calculatedMinimumSize", "getCalculatedMinimumSize", "setCalculatedMinimumSize", "(Ljava/awt/Dimension;)V", "calculatedPreferredSize", "getCalculatedPreferredSize", "setCalculatedPreferredSize", "intellij.platform.ide"})
@ApiStatus.Internal
public final class PreCalculationData {
    @NotNull
    private final Dimension minimumSize;
    @NotNull
    private final Dimension preferredSize;
    @NotNull
    private final Constraints constraints;
    @NotNull
    private Dimension calculatedMinimumSize;
    @NotNull
    private Dimension calculatedPreferredSize;

    public PreCalculationData(@NotNull Dimension minimumSize, @NotNull Dimension preferredSize, @NotNull Constraints constraints) {
        Intrinsics.checkNotNullParameter((Object)minimumSize, (String)"minimumSize");
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        this.minimumSize = minimumSize;
        this.preferredSize = preferredSize;
        this.constraints = constraints;
        this.calculatedMinimumSize = new Dimension(this.minimumSize.width, this.minimumSize.height);
        this.calculatedPreferredSize = new Dimension(Math.max(this.minimumSize.width, this.preferredSize.width), Math.max(this.minimumSize.height, this.preferredSize.height));
    }

    @NotNull
    public final Dimension getMinimumSize() {
        return this.minimumSize;
    }

    @NotNull
    public final Dimension getPreferredSize() {
        return this.preferredSize;
    }

    @NotNull
    public final Constraints getConstraints() {
        return this.constraints;
    }

    @NotNull
    public final Dimension getCalculatedMinimumSize() {
        return this.calculatedMinimumSize;
    }

    public final void setCalculatedMinimumSize(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"<set-?>");
        this.calculatedMinimumSize = dimension;
    }

    @NotNull
    public final Dimension getCalculatedPreferredSize() {
        return this.calculatedPreferredSize;
    }

    public final void setCalculatedPreferredSize(@NotNull Dimension dimension) {
        Intrinsics.checkNotNullParameter((Object)dimension, (String)"<set-?>");
        this.calculatedPreferredSize = dimension;
    }
}

