/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.Condition;
import com.intellij.ui.ListUtil;
import com.intellij.util.diff.Diff;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class FilteringListModel<T>
extends AbstractListModel<T> {
    private final ListModel<T> myOriginalModel;
    private final List<T> myData = new ArrayList<T>();
    private Condition<? super T> myCondition = null;
    private boolean myUpdating = false;
    private final ListDataListener myListDataListener = new ListDataListener(){

        @Override
        public void contentsChanged(ListDataEvent e) {
            FilteringListModel.this.refilter();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            FilteringListModel.this.refilter();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            FilteringListModel.this.refilter();
        }
    };

    public FilteringListModel(ListModel<T> originalModel) {
        this.myOriginalModel = originalModel;
        this.myOriginalModel.addListDataListener(this.myListDataListener);
    }

    public void dispose() {
        this.myOriginalModel.removeListDataListener(this.myListDataListener);
    }

    public void setFilter(Condition<? super T> condition) {
        this.myCondition = condition;
        this.refilter();
    }

    public void refilter() {
        if (this.myUpdating) {
            return;
        }
        ArrayList<T> newData = new ArrayList<T>();
        Collection<T> elements = this.getElementsToFilter();
        for (T elt : elements) {
            if (!this.passElement(elt)) continue;
            newData.add(elt);
        }
        this.commit(newData);
    }

    private void commit(List<T> newData) {
        Diff.Change change;
        try {
            change = Diff.buildChanges((Object[])this.myData.stream().map(e -> new IdentityWrapper(this, e)).toArray(), (Object[])newData.stream().map(e -> new IdentityWrapper(this, e)).toArray());
        }
        catch (FilesTooBigForDiffException e2) {
            this.replace(0, this.myData.size(), newData);
            return;
        }
        if (change != null) {
            ArrayList list = change.toList();
            Collections.reverse(list);
            for (Diff.Change ch : list) {
                this.replace(ch.line0, ch.line0 + ch.deleted, newData.subList(ch.line1, ch.line1 + ch.inserted));
            }
            assert (this.myData.equals(newData));
        }
    }

    protected void replace(int from, int to, List<T> newData) {
        if (to > from) {
            this.myData.subList(from, to).clear();
            this.fireIntervalRemoved(this, from, to - 1);
        }
        if (!newData.isEmpty()) {
            this.myData.addAll(from, newData);
            this.fireIntervalAdded(this, from, from + newData.size() - 1);
        }
    }

    @NotNull
    protected @Unmodifiable Collection<T> getElementsToFilter() {
        ArrayList<T> result2 = new ArrayList<T>(this.myOriginalModel.getSize());
        for (int i = 0; i < this.myOriginalModel.getSize(); ++i) {
            result2.add(this.myOriginalModel.getElementAt(i));
        }
        ArrayList<T> arrayList = result2;
        if (arrayList == null) {
            FilteringListModel.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @Override
    public int getSize() {
        return this.myData.size();
    }

    @Override
    public T getElementAt(int index) {
        return this.myData.get(index);
    }

    public int getElementIndex(T element) {
        return this.myData.indexOf(element);
    }

    private boolean passElement(T element) {
        return this.myCondition == null || this.myCondition.value(element);
    }

    public boolean contains(T value2) {
        return this.myData.contains(value2);
    }

    @NotNull
    public ListModel<T> getOriginalModel() {
        ListModel<T> listModel = this.myOriginalModel;
        if (listModel == null) {
            FilteringListModel.$$$reportNull$$$0(1);
        }
        return listModel;
    }

    public void addAll(List<? extends T> elements) {
        ListUtil.addAllItems(this.myOriginalModel, elements);
    }

    public void replaceAll(List<? extends T> elements) {
        try {
            this.myUpdating = true;
            ListUtil.removeAllItems(this.myOriginalModel);
            ListUtil.addAllItems(this.myOriginalModel, elements);
        }
        finally {
            this.myUpdating = false;
            this.refilter();
        }
    }

    public void remove(int index) {
        ListUtil.removeItem(this.myOriginalModel, index);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/ui/speedSearch/FilteringListModel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToFilter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalModel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class IdentityWrapper {
        private final Object myElement;

        IdentityWrapper(FilteringListModel filteringListModel, T element) {
            this.myElement = element;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj instanceof IdentityWrapper) {
                IdentityWrapper wrapper = (IdentityWrapper)obj;
                return this.myElement == wrapper.myElement;
            }
            return false;
        }

        public int hashCode() {
            return System.identityHashCode(this.myElement);
        }
    }
}

