/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.speedSearch;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.speedSearch.FilteringListModel;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.Function;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListModel;

public class NameFilteringListModel<T>
extends FilteringListModel<T> {
    private final Function<? super T, String> myNamer;
    private int myFullMatchIndex = -1;
    private int myStartsWithIndex = -1;
    private final Computable<String> myPattern;

    @Deprecated(forRemoval=true)
    public NameFilteringListModel(JList<T> list, Function<? super T, String> namer, Condition<? super String> filter, SpeedSearchSupply speedSearch) {
        this(list.getModel(), namer, filter, (Computable<String>)((Computable)() -> StringUtil.notNullize((String)speedSearch.getEnteredPrefix())));
        list.setModel(this);
    }

    public NameFilteringListModel(ListModel<T> model, Function<? super T, String> namer, Condition<? super String> filter, Computable<String> pattern) {
        super(model);
        this.myPattern = pattern;
        this.myNamer = namer;
        this.setFilter(namer != null ? t -> filter.value(namer.fun(t)) : null);
    }

    @Override
    protected void replace(int from, int to, List<T> newData) {
        super.replace(from, to, newData);
        if (this.myNamer != null) {
            boolean updatePrefix;
            boolean updateFull = this.myFullMatchIndex == -1 || this.myFullMatchIndex >= from;
            boolean bl = updatePrefix = this.myStartsWithIndex == -1 || this.myStartsWithIndex >= from;
            if (!updateFull && !updatePrefix) {
                return;
            }
            for (int i = 0; i < newData.size(); ++i) {
                T elt = newData.get(i);
                String name = (String)this.myNamer.fun(elt);
                if (name == null) continue;
                String filterString = StringUtil.toUpperCase((String)((String)this.myPattern.compute()));
                String candidateString = StringUtil.toUpperCase((String)name);
                int index = i + from;
                if (updateFull && filterString.equals(candidateString)) {
                    this.myFullMatchIndex = index;
                    updateFull = false;
                }
                if (updatePrefix && candidateString.startsWith(filterString)) {
                    this.myStartsWithIndex = index;
                    updatePrefix = false;
                }
                if (!updateFull && !updatePrefix) break;
            }
            if (updateFull) {
                this.myFullMatchIndex = this.myFullMatchIndex >= to ? this.myFullMatchIndex - to + newData.size() : -1;
            }
            if (updatePrefix) {
                this.myStartsWithIndex = this.myStartsWithIndex >= to ? this.myStartsWithIndex - to + newData.size() : -1;
            }
        }
    }

    public int getClosestMatchIndex() {
        return this.myFullMatchIndex != -1 ? this.myFullMatchIndex : this.myStartsWithIndex;
    }
}

