/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.TimedDeadzone;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

class ActionButton
implements ActionListener {
    private static final Logger LOG = Logger.getInstance(ActionButton.class);
    private final IconButton myIconButton;
    private final InplaceButton myInplaceButton;
    private Presentation myPrevPresentation;
    private final AnAction myAction;
    private final String myPlace;
    private final TabInfo myTabInfo;
    private boolean myAutoHide;
    private boolean myToShow;

    ActionButton(@NotNull TabInfo tabInfo, @NotNull AnAction action, String place, Consumer<? super MouseEvent> pass, final Consumer<? super Boolean> hover, TimedDeadzone.Length deadzone) {
        if (tabInfo == null) {
            ActionButton.$$$reportNull$$$0(0);
        }
        if (action == null) {
            ActionButton.$$$reportNull$$$0(1);
        }
        if (action.getActionUpdateThread() == ActionUpdateThread.BGT) {
            String name = action.getClass().getName();
            LOG.error((Throwable)PluginException.createByClass((String)(String.valueOf(action.getActionUpdateThread()) + " action " + StringUtil.getShortName((String)name) + " (" + name + ") is not allowed. Only EDT actions are allowed."), null, action.getClass()));
        }
        this.myIconButton = new IconButton(null, action.getTemplatePresentation().getIcon());
        this.myTabInfo = tabInfo;
        this.myAction = action;
        this.myPlace = place;
        final MouseAdapter myListener = new MouseAdapter(this){

            @Override
            public void mouseEntered(MouseEvent e) {
                hover.accept(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                hover.accept(false);
            }
        };
        this.myInplaceButton = new InplaceButton(this.myIconButton, this, pass, deadzone){

            @Override
            protected void doRepaintComponent(Component c) {
                ActionButton.this.repaintComponent(c);
            }

            @Override
            public void addNotify() {
                super.addNotify();
                ActionButton.this.myInplaceButton.addMouseListener(myListener);
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                ActionButton.this.myInplaceButton.removeMouseListener(myListener);
            }
        };
        this.myInplaceButton.setVisible(false);
        this.myInplaceButton.setFillBg(false);
    }

    public InplaceButton getComponent() {
        return this.myInplaceButton;
    }

    public Presentation getPrevPresentation() {
        return this.myPrevPresentation;
    }

    protected void repaintComponent(Component c) {
        c.repaint();
    }

    public void setMouseDeadZone(TimedDeadzone.Length deadZone) {
        this.myInplaceButton.setMouseDeadzone(deadZone);
    }

    public boolean update() {
        AnActionEvent event = this.createAnEvent(null, 0);
        this.myAction.update(event);
        Presentation p = event.getPresentation();
        boolean changed = !ActionButton.areEqual(p, this.myPrevPresentation);
        this.myIconButton.setIcons(p.getIcon(), p.getDisabledIcon(), p.getHoveredIcon());
        if (changed) {
            this.myInplaceButton.setIcons(this.myIconButton);
            String tooltipText = KeymapUtil.createTooltipText(p.getText(), this.myAction);
            this.myInplaceButton.setToolTipText(!tooltipText.isEmpty() ? tooltipText : null);
            this.myInplaceButton.setVisible(p.isEnabled() && p.isVisible());
        }
        this.myPrevPresentation = p;
        return changed;
    }

    private static boolean areEqual(Presentation p1, Presentation p2) {
        if (p1 == null || p2 == null) {
            return false;
        }
        return Objects.equals(p1.getText(), p2.getText()) && Comparing.equal((Object)p1.getIcon(), (Object)p2.getIcon()) && Comparing.equal((Object)p1.getHoveredIcon(), (Object)p2.getHoveredIcon()) && p1.isEnabled() == p2.isEnabled() && p1.isVisible() == p2.isVisible();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AnActionEvent event = this.createAnEvent(e);
        ActionUtil.performAction(this.myAction, event);
    }

    @NotNull
    private AnActionEvent createAnEvent(@NotNull ActionEvent e) {
        if (e == null) {
            ActionButton.$$$reportNull$$$0(2);
        }
        Object source = e.getSource();
        InputEvent inputEvent = null;
        if (source instanceof InputEvent) {
            inputEvent = (InputEvent)source;
        }
        return this.createAnEvent(inputEvent, e.getModifiers());
    }

    @NotNull
    private AnActionEvent createAnEvent(InputEvent inputEvent, int modifiers) {
        Presentation presentation = this.myAction.getTemplatePresentation().clone();
        DataContext parent = DataManager.getInstance().getDataContext((Component)this.myInplaceButton);
        DataContext dataContext = CustomizedDataContext.withSnapshot((DataContext)parent, sink -> sink.set(CommonDataKeys.VIRTUAL_FILE, (Object)((VirtualFile)ObjectUtils.tryCast((Object)this.myTabInfo.getObject(), VirtualFile.class))));
        return new AnActionEvent(dataContext, presentation, this.myPlace != null ? this.myPlace : "unknown", (ActionUiKind)ActionUiKind.TOOLBAR, inputEvent, modifiers, ActionManager.getInstance());
    }

    public void setAutoHide(boolean autoHide) {
        this.myAutoHide = autoHide;
        if (!this.myToShow) {
            this.toggleShowActions(false);
        }
    }

    public void toggleShowActions(boolean show) {
        if (this.myAutoHide) {
            this.myInplaceButton.setPainting(show);
        } else {
            this.myInplaceButton.setPainting(true);
        }
        this.myToShow = show;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tabInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/tabs/impl/ActionButton";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createAnEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

