/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.animation;

import com.intellij.ui.ColorUtil;
import com.intellij.util.animation.Animation;
import com.intellij.util.animation.AnimationContext;
import com.intellij.util.animation.DoubleArrayFunction;
import com.intellij.util.animation.DoubleColorFunction;
import com.intellij.util.animation.DoubleDimensionFunction;
import com.intellij.util.animation.DoubleIntFunction;
import com.intellij.util.animation.DoublePointFunction;
import com.intellij.util.animation.DoubleRectangleFunction;
import com.intellij.util.animation.FloatConsumer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a%\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0004\"\u00020\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u0006\u0010\u0006\u001a\u00020\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\f\u001a(\u0010\u0006\u001a\u00020\u0002\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u0011\u001a\u001e\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\u0013\u001a\u001e\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u0015\u001a\u001e\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\u00172\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00170\u0018\u001a$\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\u00192\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u001a-\u0010\u0006\u001a\u00020\u0002\"\u0004\b\u0000\u0010\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\r0\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\r0\u0018\u00a2\u0006\u0002\u0010\u001b\u001a$\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u001c2\u0006\u0010\u000b\u001a\u00020\u001c2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0018\u001a$\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\u001d2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018\u001a\u001c\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u001d2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0018\u001a(\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\r0\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\r0\u0018\u001a\u001e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u00112\u0006\u0010\t\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020!H\u0002\u001a$\u0010\u0006\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020!2\u0006\u0010\u000b\u001a\u00020!2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020!0\u0018\u001a\u0018\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a8\u0006$"}, d2={"makeSequent", "", "Lcom/intellij/util/animation/Animation;", "animations", "", "([Lcom/intellij/util/animation/Animation;)Ljava/util/Collection;", "animation", "consumer", "Ljava/util/function/DoubleConsumer;", "from", "", "to", "Ljava/util/function/IntConsumer;", "T", "context", "Lcom/intellij/util/animation/AnimationContext;", "function", "Ljava/util/function/DoubleFunction;", "", "Ljava/util/function/LongConsumer;", "", "Lcom/intellij/util/animation/FloatConsumer;", "", "Ljava/awt/Point;", "Ljava/util/function/Consumer;", "Ljava/awt/Rectangle;", "values", "([Ljava/lang/Object;Ljava/util/function/Consumer;)Lcom/intellij/util/animation/Animation;", "Ljava/awt/Dimension;", "Ljava/awt/Color;", "transparent", "color", "text", "", "range", "Lcom/intellij/util/animation/DoubleIntFunction;", "intellij.platform.ide"})
@JvmName(name="Animations")
public final class Animations {
    @NotNull
    public static final Collection<Animation> makeSequent(Animation ... animations) {
        Intrinsics.checkNotNullParameter((Object)animations, (String)"animations");
        int n = animations.length;
        for (int i = 1; i < n; ++i) {
            Animation prev = animations[i - 1];
            Animation curr = animations[i];
            curr.setDelay(curr.getDelay() + (prev.getDelay() + prev.getDuration()));
        }
        return ArraysKt.toList((Object[])animations);
    }

    @NotNull
    public static final Animation animation() {
        return new Animation(Animations::animation$lambda$0);
    }

    @NotNull
    public static final Animation animation(@NotNull DoubleConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        return new Animation(consumer);
    }

    @NotNull
    public static final Animation animation(int from, int to, @NotNull IntConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        return new Animation(arg_0 -> Animations.animation$lambda$1(consumer, from, to, arg_0));
    }

    @NotNull
    public static final <T> Animation animation(@NotNull AnimationContext<T> context, @NotNull DoubleFunction<T> function) {
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Animation animation = Animation.withContext(context, function);
        Intrinsics.checkNotNullExpressionValue((Object)animation, (String)"withContext(...)");
        return animation;
    }

    @NotNull
    public static final Animation animation(long from, long to, @NotNull LongConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        return new Animation(arg_0 -> Animations.animation$lambda$2(consumer, from, to, arg_0));
    }

    @NotNull
    public static final Animation animation(float from, float to, @NotNull FloatConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        return Animations.animation((double)from, (double)to, arg_0 -> Animations.animation$lambda$3(consumer, arg_0));
    }

    @NotNull
    public static final Animation animation(double from, double to, @NotNull DoubleConsumer consumer) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        return new Animation(arg_0 -> Animations.animation$lambda$4(consumer, from, to, arg_0));
    }

    @NotNull
    public static final Animation animation(@NotNull Point from, @NotNull Point to, @NotNull Consumer<Point> consumer) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return new Animation(new DoublePointFunction(from, to), consumer);
    }

    @NotNull
    public static final Animation animation(@NotNull Rectangle from, @NotNull Rectangle to, @NotNull Consumer<Rectangle> consumer) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return new Animation(new DoubleRectangleFunction(from, to), consumer);
    }

    @NotNull
    public static final <T> Animation animation(@NotNull T[] values, @NotNull Consumer<T> consumer) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return new Animation((DoubleFunction)new DoubleArrayFunction<T>(values), consumer);
    }

    @NotNull
    public static final Animation animation(@NotNull Dimension from, @NotNull Dimension to, @NotNull Consumer<Dimension> consumer) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return new Animation(new DoubleDimensionFunction(from, to), consumer);
    }

    @NotNull
    public static final Animation animation(@NotNull Color from, @NotNull Color to, @NotNull Consumer<Color> consumer) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return new Animation(new DoubleColorFunction(from, to), consumer);
    }

    @NotNull
    public static final Animation transparent(@NotNull Color color, @NotNull Consumer<Color> consumer) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Color color2 = ColorUtil.withAlpha((Color)color, (double)0.0);
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"withAlpha(...)");
        return Animations.animation(color, color2, consumer);
    }

    @NotNull
    public static final <T> DoubleConsumer consumer(@NotNull DoubleFunction<T> function, @NotNull Consumer<T> consumer) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return arg_0 -> Animations.consumer$lambda$0(consumer, function, arg_0);
    }

    private static final DoubleFunction<String> text(String from, String to) {
        String longer;
        String shorter = from.length() < to.length() ? from : to;
        String string = longer = from == shorter ? to : from;
        if (shorter.length() == longer.length() || !StringsKt.startsWith$default((String)longer, (String)shorter, (boolean)false, (int)2, null)) {
            double fraction = (double)from.length() / (double)(from.length() + to.length());
            return arg_0 -> Animations.text$lambda$0(fraction, from, to, arg_0);
        }
        return from == shorter ? arg_0 -> Animations.text$lambda$1(longer, shorter, arg_0) : arg_0 -> Animations.text$lambda$2(longer, shorter, arg_0);
    }

    @NotNull
    public static final Animation animation(@NotNull String from, @NotNull String to, @NotNull Consumer<String> consumer) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        return new Animation(Animations.text(from, to), consumer);
    }

    private static final DoubleIntFunction range(int from, int to) {
        return arg_0 -> Animations.range$lambda$0(from, to, arg_0);
    }

    private static final void animation$lambda$0(double it) {
    }

    private static final void animation$lambda$1(IntConsumer $consumer, int $from, int $to, double value2) {
        $consumer.accept(MathKt.roundToInt((double)((double)$from + value2 * (double)($to - $from))));
    }

    private static final void animation$lambda$2(LongConsumer $consumer, long $from, long $to, double value2) {
        $consumer.accept(MathKt.roundToLong((double)((double)$from + value2 * (double)($to - $from))));
    }

    private static final void animation$lambda$3(FloatConsumer $consumer, double it) {
        $consumer.accept((float)it);
    }

    private static final void animation$lambda$4(DoubleConsumer $consumer, double $from, double $to, double value2) {
        $consumer.accept($from + value2 * ($to - $from));
    }

    private static final void consumer$lambda$0(Consumer $consumer, DoubleFunction $function, double it) {
        $consumer.accept($function.apply(it));
    }

    private static final String text$lambda$0(double $fraction, String $from, String $to, double timeline) {
        String string;
        if (timeline < $fraction) {
            String string2 = $from.substring(0, MathKt.roundToInt((double)((double)$from.length() * (($fraction - timeline) / $fraction))));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            String string3 = $to.substring(0, MathKt.roundToInt((double)((double)$to.length() * (timeline - $fraction) / (1.0 - $fraction))));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        }
        return string;
    }

    private static final String text$lambda$1(String $longer, String $shorter, double timeline) {
        String string = $longer.substring(0, MathKt.roundToInt((double)((double)$shorter.length() + (double)($longer.length() - $shorter.length()) * timeline)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private static final String text$lambda$2(String $longer, String $shorter, double timeline) {
        String string = $longer.substring(0, MathKt.roundToInt((double)((double)$longer.length() - (double)($longer.length() - $shorter.length()) * timeline)));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    private static final int range$lambda$0(int $from, int $to, double value2) {
        return (int)((double)$from + value2 * (double)($to - $from));
    }

    public static final /* synthetic */ DoubleIntFunction access$range(int from, int to) {
        return Animations.range(from, to);
    }
}

