/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.SystemProperties;
import com.intellij.util.net.DirectSelector;
import com.intellij.util.net.NetUtils;
import com.intellij.util.net.ProxyConfiguration;
import com.intellij.util.net.ProxyConfigurationProvider;
import com.intellij.util.net.ProxyUtils;
import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0017\u001a\u00020\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002J&\u0010\u0018\u001a\u00020\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/util/net/IdeProxySelector;", "Ljava/net/ProxySelector;", "configurationProvider", "Lcom/intellij/util/net/ProxyConfigurationProvider;", "<init>", "(Lcom/intellij/util/net/ProxyConfigurationProvider;)V", "autoProxyResult", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/util/net/IdeProxySelector$Companion$AutoProxyHolder;", "exceptionsMatcher", "Lcom/intellij/util/net/IdeProxySelector$Companion$ExceptionsMatcherHolder;", "select", "", "Ljava/net/Proxy;", "uri", "Ljava/net/URI;", "getExceptionsMatcher", "Ljava/util/function/Predicate;", "", "exceptions", "selectUsingPac", "pacUrl", "Ljava/net/URL;", "getAutoProxySelector", "connectFailed", "", "sa", "Ljava/net/SocketAddress;", "ioe", "Ljava/io/IOException;", "Companion", "intellij.platform.ide"})
@SourceDebugExtension(value={"SMAP\nIdeProxySelector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdeProxySelector.kt\ncom/intellij/util/net/IdeProxySelector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n60#2,5:167\n60#2,5:172\n60#2,5:177\n60#2,5:182\n60#2,5:187\n60#2,5:192\n60#2,5:197\n60#2,5:202\n60#2,5:207\n13#2:213\n1#3:212\n*S KotlinDebug\n*F\n+ 1 IdeProxySelector.kt\ncom/intellij/util/net/IdeProxySelector\n*L\n23#1:167,5\n25#1:172,5\n30#1:177,5\n35#1:182,5\n43#1:187,5\n53#1:192,5\n61#1:197,5\n65#1:202,5\n88#1:207,5\n143#1:213\n*E\n"})
public final class IdeProxySelector
extends ProxySelector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProxyConfigurationProvider configurationProvider;
    @NotNull
    private final AtomicReference<Companion.AutoProxyHolder> autoProxyResult;
    @NotNull
    private final AtomicReference<Companion.ExceptionsMatcherHolder> exceptionsMatcher;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String DOCUMENT_BUILDER_FACTORY_KEY = "javax.xml.parsers.DocumentBuilderFactory";
    private static volatile long proxyAutodetectDurationMs;

    public IdeProxySelector(@NotNull ProxyConfigurationProvider configurationProvider) {
        Intrinsics.checkNotNullParameter((Object)configurationProvider, (String)"configurationProvider");
        this.configurationProvider = configurationProvider;
        this.autoProxyResult = new AtomicReference();
        this.exceptionsMatcher = new AtomicReference();
    }

    @Override
    @NotNull
    public List<Proxy> select(@Nullable URI uri) {
        ProxyConfiguration conf;
        ProxyConfiguration proxyConfiguration;
        Logger logger;
        Logger $this$debug_u24default$iv = LOG;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(uri + ": select", t$iv);
        }
        if (uri == null) {
            $this$debug_u24default$iv = LOG;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug(uri + ": no proxy, uri is null", t$iv);
            }
            return ProxyUtils.NO_PROXY_LIST;
        }
        if (!Intrinsics.areEqual((Object)"http", (Object)uri.getScheme()) && !Intrinsics.areEqual((Object)"https", (Object)uri.getScheme())) {
            $this$debug_u24default$iv = LOG;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug(uri + ": no proxy, not http/https scheme: " + uri.getScheme(), t$iv);
            }
            return ProxyUtils.NO_PROXY_LIST;
        }
        String string = uri.getHost();
        if (string == null) {
            string = "";
        }
        if (NetUtils.isLocalhost((String)string)) {
            $this$debug_u24default$iv = LOG;
            t$iv = null;
            $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug(uri + ": no proxy, localhost", t$iv);
            }
            return ProxyUtils.NO_PROXY_LIST;
        }
        try {
            proxyConfiguration = this.configurationProvider.getProxyConfiguration();
        }
        catch (CancellationException cancellationException) {
            Logger $this$debug_u24default$iv2 = LOG;
            Throwable t$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug(uri + ": no proxy, cancelled", t$iv2);
            }
            return ProxyUtils.NO_PROXY_LIST;
        }
        catch (Exception e) {
            LOG.error(uri + ": no proxy, failed to get proxy configuration", (Throwable)e);
            return ProxyUtils.NO_PROXY_LIST;
        }
        proxyConfiguration = conf = proxyConfiguration;
        if (proxyConfiguration instanceof ProxyConfiguration.DirectProxy) {
            Logger $this$debug_u24default$iv3 = LOG;
            Throwable t$iv3 = null;
            boolean $i$f$debug3 = false;
            if ($this$debug_u24default$iv3.isDebugEnabled()) {
                logger = $this$debug_u24default$iv3;
                boolean bl = false;
                logger.debug(uri + ": no proxy, DIRECT configuration", t$iv3);
            }
            return ProxyUtils.NO_PROXY_LIST;
        }
        if (proxyConfiguration instanceof ProxyConfiguration.AutoDetectProxy || proxyConfiguration instanceof ProxyConfiguration.ProxyAutoConfiguration) {
            ProxyConfiguration.ProxyAutoConfiguration proxyAutoConfiguration = conf instanceof ProxyConfiguration.ProxyAutoConfiguration ? (ProxyConfiguration.ProxyAutoConfiguration)conf : null;
            return this.selectUsingPac(proxyAutoConfiguration != null ? proxyAutoConfiguration.getPacUrl() : null, uri);
        }
        if (proxyConfiguration instanceof ProxyConfiguration.StaticProxyConfiguration) {
            Predicate<String> predicate2 = this.getExceptionsMatcher(((ProxyConfiguration.StaticProxyConfiguration)conf).getExceptions());
            String string2 = uri.getHost();
            if (string2 == null) {
                string2 = "";
            }
            if (predicate2.test(string2)) {
                Logger $this$debug_u24default$iv4 = LOG;
                Throwable t$iv4 = null;
                boolean $i$f$debug4 = false;
                if ($this$debug_u24default$iv4.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv4;
                    boolean bl = false;
                    logger.debug(uri + ": no proxy, uri is in exception list", t$iv4);
                }
                return ProxyUtils.NO_PROXY_LIST;
            }
            Proxy proxy = ProxyUtils.asJavaProxy((ProxyConfiguration.StaticProxyConfiguration)conf);
            Logger $this$debug_u24default$iv5 = LOG;
            Throwable t$iv5 = null;
            boolean $i$f$debug5 = false;
            if ($this$debug_u24default$iv5.isDebugEnabled()) {
                logger = $this$debug_u24default$iv5;
                boolean bl = false;
                logger.debug(uri + ": proxy " + proxy, t$iv5);
            }
            List<Proxy> list = Collections.singletonList(proxy);
            Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
            return list;
        }
        throw new NoWhenBranchMatchedException();
    }

    private final Predicate<String> getExceptionsMatcher(String exceptions) {
        Companion.ExceptionsMatcherHolder cached;
        Companion.ExceptionsMatcherHolder exceptionsMatcherHolder = cached = this.exceptionsMatcher.get();
        if (Intrinsics.areEqual((Object)(exceptionsMatcherHolder != null ? exceptionsMatcherHolder.getExceptions() : null), (Object)exceptions)) {
            return cached.getMatcher();
        }
        Predicate<String> matcher = ProxyConfiguration.Companion.buildProxyExceptionsMatcher(exceptions);
        this.exceptionsMatcher.set(new Companion.ExceptionsMatcherHolder(exceptions, matcher));
        return matcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Proxy> selectUsingPac(URL pacUrl, URI uri) {
        String oldDocumentBuilderFactory = System.setProperty(DOCUMENT_BUILDER_FACTORY_KEY, "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
        try {
            ProxySelector selector = this.getAutoProxySelector(pacUrl);
            try {
                List<Proxy> result2 = selector.select(uri);
                Object $this$debug_u24default$iv = LOG;
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug(uri + ": pac/autodetect proxy select result: " + result2, t$iv);
                }
                Intrinsics.checkNotNull(result2);
                $this$debug_u24default$iv = result2;
                return $this$debug_u24default$iv;
            }
            catch (StackOverflowError stackOverflowError) {
                List<Proxy> list;
                try {
                    LOG.warn(uri + ": no proxy, too large PAC script (JRE-247)");
                    list = ProxyUtils.NO_PROXY_LIST;
                }
                catch (CancellationException e) {
                    throw e;
                }
                catch (Exception e) {
                    LOG.error(uri + ": no proxy, failed to select using PAC/autodetect", (Throwable)e);
                    List<Proxy> list2 = ProxyUtils.NO_PROXY_LIST;
                    return list2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                SystemProperties.setProperty((String)DOCUMENT_BUILDER_FACTORY_KEY, (String)oldDocumentBuilderFactory);
                return list;
            }
        }
        finally {
            SystemProperties.setProperty((String)DOCUMENT_BUILDER_FACTORY_KEY, (String)oldDocumentBuilderFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final ProxySelector getAutoProxySelector(URL pacUrl) {
        Companion.AutoProxyHolder autoProxy = this.autoProxyResult.get();
        if (autoProxy != null) {
            URL uRL = autoProxy.getPacUrl();
            URL uRL2 = pacUrl;
            if (Intrinsics.areEqual((Object)(uRL != null ? uRL.toString() : null), (Object)(uRL2 != null ? uRL2.toString() : null))) {
                return autoProxy.getSelector();
            }
        }
        IdeProxySelector ideProxySelector = this;
        synchronized (ideProxySelector) {
            ProxySelector resultSelector;
            ProxySelector detectedSelector;
            ProxySelector proxySelector;
            ProxySelector proxySelector2;
            block14: {
                boolean bl = false;
                Companion.AutoProxyHolder autoProxy2 = this.autoProxyResult.get();
                if (autoProxy2 == null) break block14;
                URL uRL = autoProxy2.getPacUrl();
                URL uRL3 = pacUrl;
                if (!Intrinsics.areEqual((Object)(uRL != null ? uRL.toString() : null), (Object)(uRL3 != null ? uRL3.toString() : null))) break block14;
                ProxySelector proxySelector3 = autoProxy2.getSelector();
                return proxySelector3;
            }
            long searchStartMs = System.currentTimeMillis();
            try {
                URL uRL = pacUrl;
                proxySelector2 = NetUtils.getProxySelector((String)(uRL != null ? uRL.toString() : null));
            }
            catch (Exception e) {
                String string;
                Logger logger = LOG;
                URL uRL = pacUrl;
                if (uRL != null) {
                    void it;
                    URL uRL4 = uRL;
                    Logger logger2 = logger;
                    boolean bl = false;
                    string = "(url=" + (URL)it + ")";
                    logger = logger2;
                } else {
                    string = null;
                }
                logger.warn("proxy auto-configuration has failed " + string, (Throwable)e);
                proxySelector2 = null;
            }
            if ((proxySelector = (detectedSelector = proxySelector2)) == null) {
                DirectSelector directSelector;
                DirectSelector it = directSelector = DirectSelector.INSTANCE;
                boolean bl = false;
                if (pacUrl != null) {
                    LOG.warn("failed to configure proxy by pacUrl=" + pacUrl + ", using NO_PROXY");
                } else {
                    LOG.info("unable to autodetect proxy settings, using NO_PROXY");
                }
                proxySelector = resultSelector = (ProxySelector)directSelector;
            }
            if (pacUrl == null) {
                proxyAutodetectDurationMs = System.currentTimeMillis() - searchStartMs;
            }
            this.autoProxyResult.set(new Companion.AutoProxyHolder(pacUrl, resultSelector));
            ProxySelector proxySelector4 = resultSelector;
            return proxySelector4;
        }
    }

    @Override
    public void connectFailed(@Nullable URI uri, @Nullable SocketAddress sa, @Nullable IOException ioe) {
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IdeProxySelector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        proxyAutodetectDurationMs = -1L;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u000b\fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/util/net/IdeProxySelector$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "DOCUMENT_BUILDER_FACTORY_KEY", "", "proxyAutodetectDurationMs", "", "getProxyAutoDetectDurationMs", "AutoProxyHolder", "ExceptionsMatcherHolder", "intellij.platform.ide"})
    public static final class Companion {
        private Companion() {
        }

        @ApiStatus.Internal
        public final long getProxyAutoDetectDurationMs() {
            return proxyAutodetectDurationMs;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/util/net/IdeProxySelector$Companion$AutoProxyHolder;", "", "pacUrl", "Ljava/net/URL;", "selector", "Ljava/net/ProxySelector;", "<init>", "(Ljava/net/URL;Ljava/net/ProxySelector;)V", "getPacUrl", "()Ljava/net/URL;", "getSelector", "()Ljava/net/ProxySelector;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.ide"})
        private static final class AutoProxyHolder {
            @Nullable
            private final URL pacUrl;
            @NotNull
            private final ProxySelector selector;

            public AutoProxyHolder(@Nullable URL pacUrl, @NotNull ProxySelector selector) {
                Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
                this.pacUrl = pacUrl;
                this.selector = selector;
            }

            @Nullable
            public final URL getPacUrl() {
                return this.pacUrl;
            }

            @NotNull
            public final ProxySelector getSelector() {
                return this.selector;
            }

            @Nullable
            public final URL component1() {
                return this.pacUrl;
            }

            @NotNull
            public final ProxySelector component2() {
                return this.selector;
            }

            @NotNull
            public final AutoProxyHolder copy(@Nullable URL pacUrl, @NotNull ProxySelector selector) {
                Intrinsics.checkNotNullParameter((Object)selector, (String)"selector");
                return new AutoProxyHolder(pacUrl, selector);
            }

            public static /* synthetic */ AutoProxyHolder copy$default(AutoProxyHolder autoProxyHolder, URL uRL, ProxySelector proxySelector, int n, Object object) {
                if ((n & 1) != 0) {
                    uRL = autoProxyHolder.pacUrl;
                }
                if ((n & 2) != 0) {
                    proxySelector = autoProxyHolder.selector;
                }
                return autoProxyHolder.copy(uRL, proxySelector);
            }

            @NotNull
            public String toString() {
                return "AutoProxyHolder(pacUrl=" + this.pacUrl + ", selector=" + this.selector + ")";
            }

            public int hashCode() {
                int result2 = this.pacUrl == null ? 0 : this.pacUrl.hashCode();
                result2 = result2 * 31 + this.selector.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof AutoProxyHolder)) {
                    return false;
                }
                AutoProxyHolder autoProxyHolder = (AutoProxyHolder)other;
                if (!Intrinsics.areEqual((Object)this.pacUrl, (Object)autoProxyHolder.pacUrl)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.selector, (Object)autoProxyHolder.selector);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/util/net/IdeProxySelector$Companion$ExceptionsMatcherHolder;", "", "exceptions", "", "matcher", "Ljava/util/function/Predicate;", "<init>", "(Ljava/lang/String;Ljava/util/function/Predicate;)V", "getExceptions", "()Ljava/lang/String;", "getMatcher", "()Ljava/util/function/Predicate;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.ide"})
        private static final class ExceptionsMatcherHolder {
            @NotNull
            private final String exceptions;
            @NotNull
            private final Predicate<String> matcher;

            public ExceptionsMatcherHolder(@NotNull String exceptions, @NotNull Predicate<String> matcher) {
                Intrinsics.checkNotNullParameter((Object)exceptions, (String)"exceptions");
                Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
                this.exceptions = exceptions;
                this.matcher = matcher;
            }

            @NotNull
            public final String getExceptions() {
                return this.exceptions;
            }

            @NotNull
            public final Predicate<String> getMatcher() {
                return this.matcher;
            }

            @NotNull
            public final String component1() {
                return this.exceptions;
            }

            @NotNull
            public final Predicate<String> component2() {
                return this.matcher;
            }

            @NotNull
            public final ExceptionsMatcherHolder copy(@NotNull String exceptions, @NotNull Predicate<String> matcher) {
                Intrinsics.checkNotNullParameter((Object)exceptions, (String)"exceptions");
                Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
                return new ExceptionsMatcherHolder(exceptions, matcher);
            }

            public static /* synthetic */ ExceptionsMatcherHolder copy$default(ExceptionsMatcherHolder exceptionsMatcherHolder, String string, Predicate predicate2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = exceptionsMatcherHolder.exceptions;
                }
                if ((n & 2) != 0) {
                    predicate2 = exceptionsMatcherHolder.matcher;
                }
                return exceptionsMatcherHolder.copy(string, predicate2);
            }

            @NotNull
            public String toString() {
                return "ExceptionsMatcherHolder(exceptions=" + this.exceptions + ", matcher=" + this.matcher + ")";
            }

            public int hashCode() {
                int result2 = this.exceptions.hashCode();
                result2 = result2 * 31 + this.matcher.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ExceptionsMatcherHolder)) {
                    return false;
                }
                ExceptionsMatcherHolder exceptionsMatcherHolder = (ExceptionsMatcherHolder)other;
                if (!Intrinsics.areEqual((Object)this.exceptions, (Object)exceptionsMatcherHolder.exceptions)) {
                    return false;
                }
                return Intrinsics.areEqual(this.matcher, exceptionsMatcherHolder.matcher);
            }
        }
    }
}

