/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.SizedIcon;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.ColorIcon;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.LafIconLookup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/ui/CheckboxIcon;", "", "<init>", "()V", "create", "Lcom/intellij/util/ui/ColorIcon;", "color", "Ljava/awt/Color;", "createAndScale", "createAndScaleCheckbox", "Lcom/intellij/util/ui/JBScalableIcon;", "isSelected", "", "iconSize", "", "checkMarkSize", "arcSize", "getArcSize", "()I", "WithColor", "intellij.platform.ide"})
@ApiStatus.Internal
public final class CheckboxIcon {
    @NotNull
    public static final CheckboxIcon INSTANCE = new CheckboxIcon();
    private static final int iconSize = 14;
    private static final int checkMarkSize = 12;

    private CheckboxIcon() {
    }

    @JvmStatic
    @NotNull
    public static final ColorIcon create(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        int size = 14;
        return new ColorIcon(size, size, size, size, color, false, INSTANCE.getArcSize());
    }

    @JvmStatic
    @NotNull
    public static final ColorIcon createAndScale(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return (ColorIcon)JBUIScale.scaleIcon((JBScalableIcon)((JBScalableIcon)CheckboxIcon.create(color)));
    }

    @JvmStatic
    @NotNull
    public static final JBScalableIcon createAndScaleCheckbox(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        return CheckboxIcon.createAndScaleCheckbox(color, true);
    }

    @JvmStatic
    @NotNull
    public static final JBScalableIcon createAndScaleCheckbox(@NotNull Color color, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        if (isSelected) {
            return JBUIScale.scaleIcon((JBScalableIcon)((JBScalableIcon)new WithColor(14, color, INSTANCE.getArcSize())));
        }
        return JBUIScale.scaleIcon((JBScalableIcon)((JBScalableIcon)new ColorIcon(14, 14, 14, 14, color, false, INSTANCE.getArcSize())));
    }

    private final int getArcSize() {
        return ExperimentalUI.Companion.isNewUI() ? 4 : 0;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0001H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/util/ui/CheckboxIcon$WithColor;", "Lcom/intellij/util/ui/ColorIcon;", "size", "", "color", "Ljava/awt/Color;", "arc", "<init>", "(ILjava/awt/Color;I)V", "mySizedIcon", "Lcom/intellij/ui/SizedIcon;", "withIconPreScaled", "preScaled", "", "paintIcon", "", "component", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "i", "j", "copy", "intellij.platform.ide"})
    public static final class WithColor
    extends ColorIcon {
        private final int size;
        @NotNull
        private SizedIcon mySizedIcon;

        public WithColor(int size, @NotNull Color color, int arc) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            super(size, size, size, size, color, false, arc);
            this.size = size;
            Icon icon = ExperimentalUI.Companion.isNewUI() ? IconUtil.resizeSquared((Icon)LafIconLookup.getIcon$default("checkmark", true, false, false, false, false, 60, null), (int)12) : PlatformIcons.CHECK_ICON_SMALL;
            this.mySizedIcon = new SizedIcon(icon, 12, 12);
        }

        @NotNull
        public WithColor withIconPreScaled(boolean preScaled) {
            JBScalableIcon jBScalableIcon = this.mySizedIcon.withIconPreScaled(preScaled);
            Intrinsics.checkNotNull((Object)jBScalableIcon, (String)"null cannot be cast to non-null type com.intellij.ui.SizedIcon");
            this.mySizedIcon = (SizedIcon)jBScalableIcon;
            EmptyIcon emptyIcon = super.withIconPreScaled(preScaled);
            Intrinsics.checkNotNull((Object)emptyIcon, (String)"null cannot be cast to non-null type com.intellij.util.ui.CheckboxIcon.WithColor");
            return (WithColor)emptyIcon;
        }

        public void paintIcon(@NotNull Component component, @NotNull Graphics g, int i, int j) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paintIcon(component, g, i, j);
            int offset = (this.getIconWidth() - this.mySizedIcon.getIconWidth()) / 2;
            this.mySizedIcon.paintIcon(component, g, i + offset, j + offset);
        }

        @NotNull
        public ColorIcon copy() {
            Color color = this.getIconColor();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getIconColor(...)");
            return new WithColor(this.size, color, INSTANCE.getArcSize());
        }
    }
}

