/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.IconLoaderKt;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.DirProvider;
import com.intellij.util.ui.LafIconLookupKt;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\tH\u0007JL\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\t2\b\b\u0002\u0010\f\u001a\u00020\t2\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\u0014"}, d2={"Lcom/intellij/util/ui/LafIconLookup;", "", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "name", "", "selected", "", "focused", "enabled", "editable", "pressed", "findIcon", "dirProvider", "Lcom/intellij/util/ui/DirProvider;", "isUseRegularIconOnSelection", "getDisabledIcon", "getSelectedIcon", "intellij.platform.ide"})
public final class LafIconLookup {
    @NotNull
    public static final LafIconLookup INSTANCE = new LafIconLookup();

    private LafIconLookup() {
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Icon getIcon(@NotNull String name, boolean selected2, boolean focused, boolean enabled, boolean editable, boolean pressed) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Icon icon = INSTANCE.findIcon(name, selected2, focused, enabled, editable, pressed, new DirProvider());
        if (icon == null) {
            Icon icon2 = AllIcons.Actions.Stub;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Stub");
        }
        return icon;
    }

    public static /* synthetic */ Icon getIcon$default(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        if ((n & 0x20) != 0) {
            bl5 = false;
        }
        return LafIconLookup.getIcon(string, bl, bl2, bl3, bl4, bl5);
    }

    @Nullable
    public final Icon findIcon(@NotNull String name, boolean selected2, boolean focused, boolean enabled, boolean editable, boolean pressed, @NotNull DirProvider dirProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dirProvider, (String)"dirProvider");
        Object key = name;
        if (editable) {
            key = (String)key + "Editable";
        }
        if (selected2 && !this.isUseRegularIconOnSelection(name)) {
            key = (String)key + "Selected";
        }
        if (pressed) {
            key = (String)key + "Pressed";
        } else if (focused) {
            key = (String)key + "Focused";
        } else if (!enabled) {
            key = (String)key + "Disabled";
        }
        Class<?> providerClass = dirProvider.getClass();
        ClassLoader classLoader = providerClass.getClassLoader();
        String dir = dirProvider.dir();
        String path = StringsKt.startsWith$default((String)dir, (String)"com/intellij/ide/ui/laf/icons/", (boolean)false, (int)2, null) ? dir + (String)key + ".svg" : dir + (String)key + "." + dirProvider.getDefaultExtension();
        Intrinsics.checkNotNull((Object)classLoader);
        return IconLoaderKt.findIconUsingNewImplementation$default((String)path, (ClassLoader)classLoader, null, (int)4, null);
    }

    public static /* synthetic */ Icon findIcon$default(LafIconLookup lafIconLookup, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, DirProvider dirProvider, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = true;
        }
        if ((n & 0x10) != 0) {
            bl4 = false;
        }
        if ((n & 0x20) != 0) {
            bl5 = false;
        }
        if ((n & 0x40) != 0) {
            dirProvider = LafIconLookupKt.access$getDefaultDirProver$p();
        }
        return lafIconLookup.findIcon(string, bl, bl2, bl3, bl4, bl5, dirProvider);
    }

    private final boolean isUseRegularIconOnSelection(String name) {
        if (Intrinsics.areEqual((Object)name, (Object)"checkmark")) {
            Color selectionBg;
            Color color = UIManager.getColor("PopupMenu.selectionBackground");
            if (color == null) {
                color = UIManager.getColor("List.selectionBackground");
            }
            return (selectionBg = color) != null && JBColor.isBright() && !ColorUtil.isDark((Color)selectionBg);
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final Icon getDisabledIcon(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return LafIconLookup.getIcon$default(name, false, false, false, false, false, 54, null);
    }

    @JvmStatic
    @NotNull
    public static final Icon getSelectedIcon(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Icon icon = LafIconLookup.findIcon$default(INSTANCE, name, true, false, false, false, false, null, 124, null);
        if (icon == null) {
            icon = LafIconLookup.getIcon$default(name, false, false, false, false, false, 62, null);
        }
        return icon;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Icon getIcon(@NotNull String name, boolean selected2, boolean focused, boolean enabled, boolean editable) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return LafIconLookup.getIcon$default(name, selected2, focused, enabled, editable, false, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Icon getIcon(@NotNull String name, boolean selected2, boolean focused, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return LafIconLookup.getIcon$default(name, selected2, focused, enabled, false, false, 48, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Icon getIcon(@NotNull String name, boolean selected2, boolean focused) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return LafIconLookup.getIcon$default(name, selected2, focused, false, false, false, 56, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Icon getIcon(@NotNull String name, boolean selected2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return LafIconLookup.getIcon$default(name, selected2, false, false, false, false, 60, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Icon getIcon(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return LafIconLookup.getIcon$default(name, false, false, false, false, false, 62, null);
    }
}

