/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.vcs;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0007J\u0015\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u0010H\u0007J\u001d\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/platform/vcs/VcsUtil;", "", "<init>", "()V", "SHORT_HASH_LENGTH", "", "getFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getIcon", "Ljavax/swing/Icon;", "project", "Lcom/intellij/openapi/project/Project;", "filePath", "getShortHash", "", "Lcom/intellij/openapi/util/NlsSafe;", "hashString", "shortHashLength", "intellij.platform.vcs.shared"})
@ApiStatus.Internal
public final class VcsUtil {
    @NotNull
    public static final VcsUtil INSTANCE = new VcsUtil();
    public static final int SHORT_HASH_LENGTH = 8;

    private VcsUtil() {
    }

    @JvmStatic
    @ApiStatus.Obsolete
    @NotNull
    public static final FilePath getFilePath(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FilePath filePath = VcsContextFactory.getInstance().createFilePathOn(file);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"createFilePathOn(...)");
        return filePath;
    }

    @JvmStatic
    @Nullable
    public static final Icon getIcon(@Nullable Project project, @NotNull FilePath filePath) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        if (project == null || project.isDisposed()) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile = filePath.getVirtualFile();
        return virtualFile2 != null ? IconUtil.getIcon((VirtualFile)virtualFile2, (int)0, (Project)project) : FileTypeManager.getInstance().getFileTypeByFileName(filePath.getName()).getIcon();
    }

    @JvmStatic
    @NotNull
    public static final String getShortHash(@NotNull String hashString) {
        Intrinsics.checkNotNullParameter((Object)hashString, (String)"hashString");
        return StringsKt.take((String)hashString, (int)8);
    }

    @JvmStatic
    @NotNull
    public static final String getShortHash(@NotNull String hashString, int shortHashLength) {
        Intrinsics.checkNotNullParameter((Object)hashString, (String)"hashString");
        return StringsKt.take((String)hashString, (int)shortHashLength);
    }
}

