/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeConversionDescriptor
extends TypeConversionDescriptorBase {
    @NonNls
    private String myStringToReplace = null;
    @NonNls
    private String myReplaceByString = "$";
    private PsiExpression myExpression;
    private PsiType myConversionType;

    public TypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString) {
        this(stringToReplace, replaceByString, (PsiExpression)null);
    }

    public TypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString, PsiExpression expression) {
        this.myStringToReplace = stringToReplace;
        this.myReplaceByString = replaceByString;
        this.myExpression = expression;
    }

    public TypeConversionDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString, PsiType conversionType) {
        this(stringToReplace, replaceByString);
        this.myConversionType = conversionType;
    }

    public TypeConversionDescriptor withConversionType(PsiType conversionType) {
        this.myConversionType = conversionType;
        return this;
    }

    public void setStringToReplace(@NonNls String stringToReplace) {
        this.myStringToReplace = stringToReplace;
    }

    public void setReplaceByString(@NonNls String replaceByString) {
        this.myReplaceByString = replaceByString;
    }

    @NonNls
    public String getStringToReplace() {
        return this.myStringToReplace;
    }

    @NonNls
    public String getReplaceByString() {
        return this.myReplaceByString;
    }

    public PsiExpression getExpression() {
        return this.myExpression;
    }

    public void setExpression(PsiExpression expression) {
        this.myExpression = expression;
    }

    @Nullable
    public PsiType conversionType() {
        return this.myConversionType;
    }

    public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
        if (evaluator == null) {
            TypeConversionDescriptor.$$$reportNull$$$0(0);
        }
        if (this.getExpression() != null) {
            expression = this.getExpression();
        }
        expression = this.adjustExpressionBeforeReplacement(expression);
        return TypeConversionDescriptor.replaceExpression(expression, this.getStringToReplace(), this.getReplaceByString());
    }

    @NotNull
    protected PsiExpression adjustExpressionBeforeReplacement(@NotNull PsiExpression expression) {
        if (expression == null) {
            TypeConversionDescriptor.$$$reportNull$$$0(1);
        }
        PsiExpression psiExpression = expression;
        if (psiExpression == null) {
            TypeConversionDescriptor.$$$reportNull$$$0(2);
        }
        return psiExpression;
    }

    @NotNull
    public static PsiExpression replaceExpression(@NotNull PsiExpression expression, String stringToReplace, String replaceByString) {
        if (expression == null) {
            TypeConversionDescriptor.$$$reportNull$$$0(3);
        }
        Project project = expression.getProject();
        ReplaceOptions options = new ReplaceOptions();
        MatchOptions matchOptions = options.getMatchOptions();
        matchOptions.setFileType((LanguageFileType)JavaFileType.INSTANCE);
        String replacement = Replacer.testReplace((String)expression.getText(), (String)stringToReplace, (String)replaceByString, (ReplaceOptions)options, (Project)project);
        PsiExpression psiExpression = (PsiExpression)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(expression.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(replacement, (PsiElement)expression)));
        if (psiExpression == null) {
            TypeConversionDescriptor.$$$reportNull$$$0(4);
        }
        return psiExpression;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.myReplaceByString != null) {
            buf.append(this.myReplaceByString);
        }
        if (this.myStringToReplace != null) {
            if (!buf.isEmpty()) {
                buf.append(" ");
            }
            buf.append(this.myStringToReplace);
        }
        if (this.myExpression != null) {
            if (!buf.isEmpty()) {
                buf.append(" ");
            }
            buf.append(this.myExpression.getText());
        }
        return buf.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/TypeConversionDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/TypeConversionDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustExpressionBeforeReplacement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adjustExpressionBeforeReplacement";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

