/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableTypeFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.quickfix.ChangeVariableTypeQuickFixProvider;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationBundle;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeMigrationVariableTypeFixProvider
implements ChangeVariableTypeQuickFixProvider {
    private static final Logger LOG = Logger.getInstance(TypeMigrationVariableTypeFixProvider.class);

    public IntentionAction @NotNull [] getFixes(@NotNull PsiVariable variable, @NotNull PsiType toReturn) {
        if (variable == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(0);
        }
        if (toReturn == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(1);
        }
        if (!TypeMigrationVariableTypeFixProvider.typeMigrationMightBeUseful(variable, toReturn)) {
            if (IntentionAction.EMPTY_ARRAY == null) {
                TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(2);
            }
            return IntentionAction.EMPTY_ARRAY;
        }
        IntentionAction[] intentionActionArray = new IntentionAction[]{TypeMigrationVariableTypeFixProvider.createTypeMigrationFix(variable, toReturn)};
        if (intentionActionArray == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(3);
        }
        return intentionActionArray;
    }

    @NotNull
    private static VariableTypeFix createTypeMigrationFix(@NotNull PsiVariable variable, @NotNull PsiType toReturn) {
        if (variable == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(4);
        }
        if (toReturn == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(5);
        }
        return new VariableTypeFix(variable, toReturn){

            @NotNull
            public String getText() {
                String string = TypeMigrationBundle.message("migrate.fix.text", this.myName, StringUtil.escapeXmlEntities((String)this.getReturnType().getPresentableText()));
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @NotNull
            public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (editor == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (psiFile == null) {
                    1.$$$reportNull$$$0(3);
                }
                IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
                if (intentionPreviewInfo == null) {
                    1.$$$reportNull$$$0(4);
                }
                return intentionPreviewInfo;
            }

            public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
                if (project == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (psiFile == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (startElement == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (endElement == null) {
                    1.$$$reportNull$$$0(8);
                }
                TypeMigrationVariableTypeFixProvider.runTypeMigrationOnVariable((PsiVariable)startElement, this.getReturnType(), editor, false, true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 3, 5, 6, 7, 8 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "editor";
                        break;
                    }
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "startElement";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "endElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider$1";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "generatePreview";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "generatePreview";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 3, 5, 6, 7, 8 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private static boolean typeMigrationMightBeUseful(@NotNull PsiVariable variable, @NotNull PsiType targetType) {
        if (variable == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(6);
        }
        if (targetType == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(7);
        }
        if (!PsiUtil.isJvmLocalVariable((PsiElement)variable)) {
            return true;
        }
        List refs = VariableAccessUtils.getVariableReferences((PsiVariable)variable);
        if (refs.isEmpty()) {
            return false;
        }
        Project project = variable.getProject();
        TypeMigrationRules rules = new TypeMigrationRules(project);
        rules.setBoundScope(variable.getUseScope());
        TypeMigrationLabeler labeler = new TypeMigrationLabeler(rules, targetType, project);
        for (PsiReferenceExpression ref : refs) {
            labeler.getTypeEvaluator().setType(new TypeMigrationUsageInfo((PsiElement)ref), targetType);
            if (rules.findConversion(variable.getType(), targetType, null, (PsiExpression)ref, labeler) == null) continue;
            return true;
        }
        return false;
    }

    public static void runTypeMigrationOnVariable(@NotNull PsiVariable variable, @NotNull PsiType targetType, @Nullable Editor editor, boolean optimizeImports, boolean allowDependentRoots) {
        if (variable == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(8);
        }
        if (targetType == null) {
            TypeMigrationVariableTypeFixProvider.$$$reportNull$$$0(9);
        }
        Project project = variable.getProject();
        if (!FileModificationService.getInstance().prepareFileForWrite(variable.getContainingFile())) {
            return;
        }
        try {
            WriteAction.run(() -> variable.normalizeDeclaration());
            TypeMigrationRules rules = new TypeMigrationRules(project);
            rules.setBoundScope(variable.getUseScope());
            TypeMigrationProcessor.runHighlightingTypeMigration((Project)project, (Editor)editor, (TypeMigrationRules)rules, (PsiElement)variable, (PsiType)targetType, (boolean)optimizeImports, (boolean)allowDependentRoots);
            WriteAction.run(() -> JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)variable));
            UndoUtil.markPsiFileForUndo((PsiFile)variable.getContainingFile());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toReturn";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/TypeMigrationVariableTypeFixProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFixes";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTypeMigrationFix";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "typeMigrationMightBeUseful";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runTypeMigrationOnVariable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

