/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.java.codeserver.highlighting.JavaCompilationErrorBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.JavaBaseRefactoringSupportProvider;
import com.intellij.refactoring.typeMigration.ChangeTypeSignatureHandlerBase;
import com.intellij.refactoring.typeMigration.TypeMigrationBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ChangeClassParametersIntention
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(ChangeClassParametersIntention.class);

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ChangeClassParametersIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = TypeMigrationBundle.message("change.class.type.parameter.family.name", new Object[0]);
        if (string == null) {
            ChangeClassParametersIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiMember member;
        PsiReferenceParameterList parameterList;
        PsiTypeElement typeElement;
        if (project == null) {
            ChangeClassParametersIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ChangeClassParametersIntention.$$$reportNull$$$0(3);
        }
        PsiElement parent = (typeElement = (PsiTypeElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, PsiTypeElement.class)) != null ? typeElement.getParent() : null;
        PsiReferenceParameterList psiReferenceParameterList = parameterList = parent instanceof PsiReferenceParameterList ? (PsiReferenceParameterList)parent : null;
        if (parameterList != null && parameterList.getTypeArguments().length > 0 && (member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)parameterList, PsiMember.class)) instanceof PsiAnonymousClass) {
            PsiClassType.ClassResolveResult result = ((PsiAnonymousClass)member).getBaseClassType().resolveGenerics();
            PsiClass baseClass = result.getElement();
            return baseClass != null && baseClass.getTypeParameters().length == parameterList.getTypeParameterElements().length && ((PsiAnonymousClass)member).getBaseClassReference().getParameterList() == parameterList;
        }
        return false;
    }

    public void invoke(final @NotNull Project project, final Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiClass aClass;
        PsiTypeElement typeElement;
        PsiReferenceParameterList parameterList;
        if (project == null) {
            ChangeClassParametersIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ChangeClassParametersIntention.$$$reportNull$$$0(5);
        }
        if ((parameterList = (PsiReferenceParameterList)PsiTreeUtil.getParentOfType((PsiElement)(typeElement = (PsiTypeElement)PsiTreeUtil.getTopmostParentOfType((PsiElement)element, PsiTypeElement.class)), PsiReferenceParameterList.class)) != null && (aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class)) instanceof PsiAnonymousClass) {
            editor.getCaretModel().moveToOffset(aClass.getTextOffset());
            Object[] typeElements = parameterList.getTypeParameterElements();
            int changeIdx = ArrayUtil.find((Object[])typeElements, (Object)typeElement);
            final PsiClassType.ClassResolveResult result = ((PsiAnonymousClass)aClass).getBaseClassType().resolveGenerics();
            final PsiClass baseClass = result.getElement();
            LOG.assertTrue(baseClass != null);
            final PsiTypeParameter typeParameter = baseClass.getTypeParameters()[changeIdx];
            TemplateBuilderImpl templateBuilder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)aClass);
            final String oldTypeText = typeElement.getText();
            @NonNls String varName = "param";
            templateBuilder.replaceElement((PsiElement)typeElement, "param", (Expression)new TypeExpression(project, new PsiType[]{typeElement.getType()}), true);
            Template template = templateBuilder.buildInlineTemplate();
            TemplateManager.getInstance((Project)project).startTemplate(editor, template, false, null, (TemplateEditingListener)new TemplateEditingAdapter(this){
                private String myNewType;

                public void beforeTemplateFinished(@NotNull TemplateState state, Template template) {
                    TextResult value;
                    if (state == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    this.myNewType = (value = state.getVariableValue("param")) != null ? value.getText() : "";
                    int segmentsCount = state.getSegmentsCount();
                    Document document = state.getEditor().getDocument();
                    ApplicationManager.getApplication().runWriteAction(() -> {
                        for (int i = 0; i < segmentsCount; ++i) {
                            TextRange segmentRange = state.getSegmentRange(i);
                            document.replaceString(segmentRange.getStartOffset(), segmentRange.getEndOffset(), (CharSequence)oldTypeText);
                        }
                    });
                }

                public void templateFinished(@NotNull Template template, boolean brokenOff) {
                    if (template == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (!brokenOff) {
                        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                        try {
                            PsiType targetParam = elementFactory.createTypeFromText(this.myNewType, (PsiElement)aClass);
                            if (!(targetParam instanceof PsiClassType)) {
                                HintManager.getInstance().showErrorHint(editor, JavaCompilationErrorBundle.message((String)"type.argument.primitive", (Object[])new Object[0]));
                                return;
                            }
                            PsiClassType classType = (PsiClassType)targetParam;
                            PsiClass target = classType.resolve();
                            if (target == null) {
                                HintManager.getInstance().showErrorHint(editor, JavaErrorBundle.message((String)"cannot.resolve.symbol", (Object[])new Object[]{classType.getPresentableText()}));
                                return;
                            }
                            PsiSubstitutor substitutor = result.getSubstitutor().put(typeParameter, targetParam);
                            PsiClassType targetClassType = elementFactory.createType(baseClass, substitutor);
                            JavaBaseRefactoringSupportProvider supportProvider = CommonJavaRefactoringUtil.getRefactoringSupport();
                            ChangeTypeSignatureHandlerBase handler = supportProvider.getChangeTypeSignatureHandler();
                            handler.runHighlightingTypeMigrationSilently(project, editor, (SearchScope)new LocalSearchScope((PsiElement)aClass), (PsiElement)((PsiAnonymousClass)aClass).getBaseClassReference().getParameterList(), (PsiType)targetClassType);
                        }
                        catch (IncorrectOperationException e) {
                            HintManager.getInstance().showErrorHint(editor, TypeMigrationBundle.message("change.class.parameter.incorrect.type.error.hint", new Object[0]));
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "state";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "template";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/refactoring/typeMigration/intentions/ChangeClassParametersIntention$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "beforeTemplateFinished";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "templateFinished";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/intentions/ChangeClassParametersIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/intentions/ChangeClassParametersIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

