/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.AllowedApiFilterExtension;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationBundle;
import com.intellij.refactoring.typeMigration.TypeMigrationVariableTypeFixProvider;
import com.intellij.refactoring.typeMigration.intentions.ConvertFieldToAtomicIntention;
import com.intellij.util.IncorrectOperationException;
import java.util.HashMap;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConvertFieldToThreadLocalIntention
extends BaseElementAtCaretIntentionAction
implements LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(ConvertFieldToThreadLocalIntention.class);

    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = TypeMigrationBundle.message("convert.to.threadlocal.family.name", new Object[0]);
        if (string == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(3);
        }
        if (element == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(4);
        }
        if (!(element instanceof PsiIdentifier)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiField)) {
            return false;
        }
        PsiField field = (PsiField)parent;
        if (field.getLanguage() != JavaLanguage.INSTANCE) {
            return false;
        }
        if (field.getTypeElement() == null) {
            return false;
        }
        PsiType fieldType = field.getType();
        PsiClass fieldTypeClass = PsiUtil.resolveClassInType((PsiType)fieldType);
        if (fieldType instanceof PsiPrimitiveType && !PsiTypes.voidType().equals((Object)fieldType) || fieldType instanceof PsiArrayType) {
            return true;
        }
        return fieldTypeClass != null && !Comparing.strEqual((String)fieldTypeClass.getQualifiedName(), (String)ThreadLocal.class.getName()) && AllowedApiFilterExtension.isClassAllowed((String)ThreadLocal.class.getName(), (PsiElement)element);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiField psiField;
        if (project == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(7);
        }
        LOG.assertTrue((psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class)) != null);
        PsiType fromType = psiField.getType();
        PsiClassType toType = ConvertFieldToThreadLocalIntention.getMigrationTargetType(fromType, project, element);
        if (toType == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{psiField})) {
            return;
        }
        ConvertFieldToAtomicIntention.addExplicitInitializer((PsiVariable)psiField);
        String toTypeCanonicalText = toType.getCanonicalText();
        TypeMigrationVariableTypeFixProvider.runTypeMigrationOnVariable((PsiVariable)psiField, (PsiType)toType, editor, false, false);
        ConvertFieldToAtomicIntention.postProcessVariable((PsiVariable)psiField, toTypeCanonicalText);
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        String presentableText;
        PsiField psiField;
        if (project == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(9);
        }
        if (psiFile == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(10);
        }
        if ((psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(editor, psiFile), PsiField.class)) == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(11);
            }
            return intentionPreviewInfo;
        }
        PsiType type = psiField.getType();
        if (type == PsiTypes.nullType()) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            if (intentionPreviewInfo == null) {
                ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(12);
            }
            return intentionPreviewInfo;
        }
        String fieldName = psiField.getName();
        String genericArg = presentableText = type.getPresentableText();
        if (type instanceof PsiPrimitiveType) {
            genericArg = StringUtil.getShortName((String)Objects.requireNonNull(((PsiPrimitiveType)type).getBoxedTypeName()));
        }
        return new IntentionPreviewInfo.CustomDiff((FileType)JavaFileType.INSTANCE, null, presentableText + " " + fieldName, "ThreadLocal<" + genericArg + "> " + fieldName + " = ThreadLocal.withInitial(...)");
    }

    @Nullable
    private static PsiClassType getMigrationTargetType(@NotNull PsiType fromType, @NotNull Project project, @NotNull PsiElement context) {
        JavaPsiFacade psiFacade;
        PsiClass threadLocalClass;
        if (fromType == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(13);
        }
        if (project == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(14);
        }
        if (context == null) {
            ConvertFieldToThreadLocalIntention.$$$reportNull$$$0(15);
        }
        if ((threadLocalClass = (psiFacade = JavaPsiFacade.getInstance((Project)project)).findClass(ThreadLocal.class.getName(), GlobalSearchScope.allScope((Project)project))) == null) {
            return null;
        }
        HashMap<PsiTypeParameter, PsiType> substitutor = new HashMap<PsiTypeParameter, PsiType>();
        PsiTypeParameter[] typeParameters = threadLocalClass.getTypeParameters();
        if (typeParameters.length == 1) {
            PsiType type = fromType;
            if (fromType instanceof PsiPrimitiveType) {
                type = ((PsiPrimitiveType)fromType).getBoxedType(context);
            }
            substitutor.put(typeParameters[0], type);
        }
        PsiElementFactory factory = psiFacade.getElementFactory();
        return factory.createType(threadLocalClass, factory.createSubstitutor(substitutor));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToThreadLocalIntention";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromType";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/intentions/ConvertFieldToThreadLocalIntention";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMigrationTargetType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 10, 13, 14, 15 -> new IllegalArgumentException(string);
        };
    }
}

