/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ElementToArrayConversionRule
extends TypeConversionRule {
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        int dimensions;
        if (member != null && from instanceof PsiEllipsisType && to instanceof PsiArrayType && !(to instanceof PsiEllipsisType)) {
            from = ((PsiEllipsisType)from).getComponentType();
        }
        if ((dimensions = to.getArrayDimensions() - from.getArrayDimensions()) < 0) {
            PsiExpression expression = ElementToArrayConversionRule.unwrap(context, -dimensions);
            if (expression == null) {
                return null;
            }
            PsiType type = expression.getType();
            if (type != null && to.isAssignableFrom(type)) {
                return new TypeConversionDescriptorBase(this){

                    public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
                        PsiExpression unwrapped;
                        if (evaluator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((unwrapped = ElementToArrayConversionRule.unwrap(expression, -dimensions)) == null) {
                            return expression;
                        }
                        return (PsiExpression)expression.replace((PsiElement)unwrapped);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/ElementToArrayConversionRule$1", "replace"));
                    }
                };
            }
        }
        if (dimensions > 0 && to instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)to;
            if (ElementToArrayConversionRule.shouldConvert(context)) {
                PsiArrayType componentType = arrayType;
                for (int i = 0; i < dimensions; ++i) {
                    assert (componentType instanceof PsiArrayType);
                    componentType = componentType.getComponentType();
                }
                if ((componentType = TypeConversionUtil.erasure((PsiType)componentType)).isAssignableFrom(from)) {
                    PsiMethod method;
                    final boolean vararg = member instanceof PsiMethod && (method = (PsiMethod)member).isVarArgs();
                    PsiArrayType finalComponentType = componentType;
                    return new TypeConversionDescriptorBase(this, (PsiType)finalComponentType){
                        final /* synthetic */ PsiType val$finalComponentType;
                        {
                            this.val$finalComponentType = psiType;
                        }

                        public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
                            PsiVariable variable;
                            if (evaluator == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            String content = vararg ? 2.getVarargText((PsiElement)expression) : expression.getText();
                            String text = "{".repeat(dimensions) + content + "}".repeat(dimensions);
                            PsiElement parent = expression.getParent();
                            if (!(parent instanceof PsiVariable) || !(variable = (PsiVariable)parent).getType().equals(this.val$finalComponentType)) {
                                text = "new " + this.val$finalComponentType.getCanonicalText() + "[]".repeat(dimensions) + text;
                            }
                            PsiExpression newExpression = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(text, (PsiElement)expression);
                            if (vararg) {
                                PsiExpression last = expression;
                                for (PsiElement anchor = last.getNextSibling(); anchor != null && !PsiUtil.isJavaToken((PsiElement)anchor, (IElementType)JavaTokenType.RPARENTH); anchor = anchor.getNextSibling()) {
                                    last = anchor;
                                }
                                parent.deleteChildRange((PsiElement)expression, (PsiElement)last);
                                return (PsiExpression)parent.add((PsiElement)newExpression);
                            }
                            return (PsiExpression)expression.replace((PsiElement)newExpression);
                        }

                        private static String getVarargText(PsiElement element) {
                            StringBuilder result = new StringBuilder();
                            while (element != null && !PsiUtil.isJavaToken((PsiElement)element, (IElementType)JavaTokenType.RPARENTH)) {
                                result.append(element.getText());
                                element = element.getNextSibling();
                            }
                            return result.toString();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/ElementToArrayConversionRule$2", "replace"));
                        }
                    };
                }
            }
        }
        return null;
    }

    private static boolean shouldConvert(PsiExpression expression) {
        return !(expression instanceof PsiReferenceExpression) && !(expression.getParent() instanceof PsiExpressionStatement);
    }

    @Nullable
    private static PsiExpression unwrap(PsiExpression expression, int dimensions) {
        for (int i = 0; i < dimensions; ++i) {
            PsiArrayInitializerExpression arrayInitializer;
            if (expression instanceof PsiNewExpression) {
                PsiNewExpression newExpression = (PsiNewExpression)expression;
                arrayInitializer = newExpression.getArrayInitializer();
            } else if (expression instanceof PsiArrayInitializerExpression) {
                arrayInitializer = (PsiArrayInitializerExpression)expression;
            } else {
                return null;
            }
            if (arrayInitializer == null) {
                return null;
            }
            PsiExpression[] initializers = arrayInitializer.getInitializers();
            if (initializers.length != 1) {
                return null;
            }
            expression = initializers[0];
        }
        return expression;
    }
}

