/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public final class ListArrayConversionRule
extends TypeConversionRule {
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        PsiMethodCallExpression callExpression;
        PsiArrayType arrayType;
        PsiClassType classType;
        PsiExpression expression = context;
        Object object = from instanceof PsiClassType ? (PsiClassType)from : (classType = to instanceof PsiClassType ? (PsiClassType)to : null);
        Object object2 = from instanceof PsiArrayType ? (PsiArrayType)from : (arrayType = to instanceof PsiArrayType ? (PsiArrayType)to : null);
        if (classType == null || arrayType == null) {
            return null;
        }
        PsiType collectionType = ListArrayConversionRule.evaluateCollectionsType(classType, expression);
        if (collectionType == null) {
            return null;
        }
        if (member == null && (callExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethodCallExpression.class)) != null) {
            member = callExpression.resolveMethod();
            expression = callExpression;
        }
        if (member instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)member;
            TypeConversionDescriptor descriptor = ListArrayConversionRule.changeCollectionCallsToArray(method, (PsiElement)context, collectionType, arrayType);
            if (descriptor != null) {
                return descriptor;
            }
            @NonNls String memberName = member.getName();
            assert (memberName != null);
            switch (memberName) {
                case "sort": {
                    TypeConversionDescriptor typeConversionDescriptor;
                    if (method.getParameterList().getParametersCount() == 1) {
                        typeConversionDescriptor = new TypeConversionDescriptor("Arrays.sort($qualifier$)", "Collections.sort($qualifier$)", expression);
                        break;
                    }
                    typeConversionDescriptor = new TypeConversionDescriptor("Arrays.sort($qualifier$, $expr$)", "Collections.sort($qualifier$, $expr$)", expression);
                    break;
                }
                case "binarySearch": {
                    TypeConversionDescriptor typeConversionDescriptor;
                    if (method.getParameterList().getParametersCount() == 2) {
                        typeConversionDescriptor = new TypeConversionDescriptor("Arrays.binarySearch($qualifier$, $key$)", "Collections.binarySearch($qualifier$, $key$)", expression);
                        break;
                    }
                    typeConversionDescriptor = new TypeConversionDescriptor("Arrays.binarySearch($qualifier$, $key$, $comparator$)", "Collections.binarySearch($qualifier$, $key$, $comparator$)", expression);
                    break;
                }
                case "asList": {
                    TypeConversionDescriptor typeConversionDescriptor;
                    if (method.getParameterList().getParametersCount() == 1) {
                        typeConversionDescriptor = new TypeConversionDescriptor("Arrays.asList($qualifier$)", "$qualifier$", expression);
                        break;
                    }
                    typeConversionDescriptor = null;
                    break;
                }
                case "fill": {
                    TypeConversionDescriptor typeConversionDescriptor = new TypeConversionDescriptor("Arrays.fill($qualifier$, $filler$)", "Collections.fill($qualifier$, $filler$)", expression);
                    break;
                }
                default: {
                    TypeConversionDescriptor typeConversionDescriptor = descriptor = null;
                }
            }
            if (descriptor != null) {
                return from instanceof PsiClassType ? new TypeConversionDescriptor(descriptor.getReplaceByString(), descriptor.getStringToReplace(), descriptor.getExpression()) : descriptor;
            }
        }
        if (member instanceof PsiField && "length".equals(member.getName())) {
            return new TypeConversionDescriptor("$qualifier$.length", "$qualifier$.size()");
        }
        PsiElement parent = context.getParent();
        if (parent instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent).getLExpression() == context) {
            if (TypeConversionUtil.isAssignable((PsiType)collectionType, (PsiType)arrayType.getComponentType())) {
                return new TypeConversionDescriptor("$qualifier$[$idx$] = $expr$", "$qualifier$.set($idx$, $expr$)", (PsiExpression)parent);
            }
        } else if (context instanceof PsiArrayAccessExpression && TypeConversionUtil.isAssignable((PsiType)arrayType.getComponentType(), (PsiType)collectionType)) {
            return new TypeConversionDescriptor("$qualifier$[$idx$]", "$qualifier$.get($idx$)");
        }
        return null;
    }

    @Nullable
    public static PsiType evaluateCollectionsType(PsiClassType classType, PsiExpression expression) {
        PsiClassType.ClassResolveResult classResolveResult = PsiUtil.resolveGenericsClassInType((PsiType)classType);
        PsiClass psiClass = classResolveResult.getElement();
        if (psiClass != null) {
            GlobalSearchScope allScope = GlobalSearchScope.allScope((Project)psiClass.getProject());
            PsiClass collectionClass = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("java.util.List", allScope);
            if (collectionClass != null && InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)collectionClass, (boolean)true)) {
                PsiSubstitutor derivedSubstitutor = classResolveResult.getSubstitutor();
                if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)psiClass, (PsiSubstitutor)derivedSubstitutor)) {
                    return null;
                }
                PsiSubstitutor substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)collectionClass, (PsiClass)psiClass, (PsiSubstitutor)derivedSubstitutor);
                assert (substitutor != null);
                PsiType type = substitutor.substitute(collectionClass.getTypeParameters()[0]);
                assert (type != null);
                return PsiImplUtil.normalizeWildcardTypeByPosition((PsiType)type, (PsiExpression)expression);
            }
        }
        return null;
    }

    public Pair<PsiType, PsiType> bindTypeParameters(PsiType from, PsiType to, PsiMethod method, PsiExpression context, TypeMigrationLabeler labeler) {
        PsiType collectionType;
        if (this.findConversion(from, to, (PsiMember)method, context, labeler) == null) {
            return null;
        }
        if (from instanceof PsiArrayType && to instanceof PsiClassType && (collectionType = ListArrayConversionRule.evaluateCollectionsType((PsiClassType)to, context)) != null) {
            return Pair.create((Object)((PsiArrayType)from).getComponentType(), (Object)collectionType);
        }
        if (to instanceof PsiArrayType && from instanceof PsiClassType && (collectionType = ListArrayConversionRule.evaluateCollectionsType((PsiClassType)from, context)) != null) {
            return Pair.create((Object)collectionType, (Object)((PsiArrayType)to).getComponentType());
        }
        return null;
    }

    @Nullable
    private static TypeConversionDescriptor changeCollectionCallsToArray(PsiMethod method, PsiElement context, PsiType collectionType, PsiArrayType arrayType) {
        String methodName;
        return switch (methodName = method.getName()) {
            case "toArray" -> {
                if (method.getParameterList().isEmpty()) {
                    yield new TypeConversionDescriptor("$qualifier$.toArray()", "$qualifier$");
                }
                yield new TypeConversionDescriptor("$qualifier$.toArray($expr$)", "$qualifier$");
            }
            case "size" -> new TypeConversionDescriptor("$qualifier$.size()", "$qualifier$.length");
            case "get" -> {
                if (TypeConversionUtil.isAssignable((PsiType)collectionType, (PsiType)arrayType.getComponentType())) {
                    yield new TypeConversionDescriptor("$qualifier$.get($i$)", "$qualifier$[$i$]", (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)context, PsiMethodCallExpression.class));
                }
                yield null;
            }
            case "set" -> {
                if (TypeConversionUtil.isAssignable((PsiType)arrayType.getComponentType(), (PsiType)collectionType)) {
                    yield new TypeConversionDescriptor("$qualifier$.set($i$, $val$)", "$qualifier$[$i$] = $val$");
                }
                yield null;
            }
            default -> null;
        };
    }
}

