/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.codeInsight.daemon.impl.quickfix.VariableAccessFromInnerClassFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiPrecedenceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.ArrayInitializerAwareConversionDescriptor;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRuleUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ThreadLocalConversionRule
extends TypeConversionRule {
    private static final Logger LOG = Logger.getInstance(ThreadLocalConversionRule.class);

    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        PsiClassType toClassType;
        if (to instanceof PsiClassType && ThreadLocalConversionRule.isThreadLocalTypeMigration(from, toClassType = (PsiClassType)to, context)) {
            return ThreadLocalConversionRule.findDirectConversion((PsiElement)context, toClassType, from, labeler);
        }
        return null;
    }

    private static boolean isThreadLocalTypeMigration(PsiType from, PsiClassType to, PsiExpression context) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)to);
        PsiClass threadLocalClass = resolveResult.getElement();
        if (threadLocalClass != null) {
            String typeQualifiedName = threadLocalClass.getQualifiedName();
            if (!Comparing.strEqual((String)typeQualifiedName, (String)ThreadLocal.class.getName())) {
                return false;
            }
            PsiTypeParameter[] typeParameters = threadLocalClass.getTypeParameters();
            if (typeParameters.length != 1) {
                return !PsiUtil.isAvailable((JavaFeature)JavaFeature.GENERICS, (PsiElement)context);
            }
            PsiType toTypeParameterValue = resolveResult.getSubstitutor().substitute(typeParameters[0]);
            if (toTypeParameterValue != null) {
                if (from instanceof PsiPrimitiveType) {
                    PsiPrimitiveType unboxedInitialType = PsiPrimitiveType.getUnboxedType((PsiType)toTypeParameterValue);
                    if (unboxedInitialType != null) {
                        return TypeConversionUtil.areTypesConvertible((PsiType)from, (PsiType)unboxedInitialType);
                    }
                } else {
                    return TypeConversionUtil.isAssignable((PsiType)toTypeParameterValue, (PsiType)from);
                }
            }
            return !PsiUtil.isLanguageLevel5OrHigher((PsiElement)context);
        }
        return false;
    }

    @Nullable
    private static TypeConversionDescriptor findDirectConversion(PsiElement context, PsiClassType to, PsiType from, TypeMigrationLabeler labeler) {
        PsiPrefixExpression prefixExpression;
        IElementType operationSign;
        PsiClass toTypeClass = to.resolve();
        LOG.assertTrue(toTypeClass != null);
        PsiElement parent = context.getParent();
        if (parent.equals((Object)labeler.getCurrentRoot().getElement()) && ((PsiVariable)parent).getInitializer() == context) {
            return ThreadLocalConversionRule.wrapWithNewExpression(from, to, (PsiExpression)context);
        }
        if (context instanceof PsiArrayAccessExpression) {
            return new TypeConversionDescriptor("$qualifier$[$val$]", "$qualifier$.get()[$val$]");
        }
        if (parent instanceof PsiAssignmentExpression && (operationSign = ((PsiAssignmentExpression)parent).getOperationTokenType()) == JavaTokenType.EQ) {
            boolean rightInfected = ((PsiAssignmentExpression)parent).getLExpression() == context;
            String replacement = rightInfected ? "$qualifier$ = $val$.get()" : "$qualifier$.set(" + ThreadLocalConversionRule.coerceType("$val$", from, to, context) + ")";
            return new TypeConversionDescriptor("$qualifier$ = $val$", replacement, (PsiExpression)((PsiAssignmentExpression)parent));
        }
        if (context instanceof PsiReferenceExpression) {
            PsiExpression qualifierExpression = ((PsiReferenceExpression)context).getQualifierExpression();
            PsiExpression expression = context.getParent() instanceof PsiMethodCallExpression && qualifierExpression != null ? qualifierExpression : (PsiExpression)context;
            return new TypeConversionDescriptor("$qualifier$", ThreadLocalConversionRule.toPrimitive("$qualifier$.get()", from, context), expression);
        }
        if (context instanceof PsiPrefixExpression && (prefixExpression = (PsiPrefixExpression)context).getOperationSign().getTokenType() == JavaTokenType.EXCL) {
            return new TypeConversionDescriptor("!$qualifier$", "!$qualifier$.get()");
        }
        if (parent instanceof PsiExpressionStatement) {
            if (context instanceof PsiPostfixExpression) {
                PsiPostfixExpression postfixExpression = (PsiPostfixExpression)context;
                String sign = postfixExpression.getOperationSign().getText();
                return new TypeConversionDescriptor("$qualifier$" + sign, "$qualifier$.set(" + ThreadLocalConversionRule.getBoxedWrapper(from, to, ThreadLocalConversionRule.toPrimitive("$qualifier$.get()", from, context) + " " + sign.charAt(0) + " 1", labeler, context, postfixExpression.getOperand().getText() + sign.charAt(0) + " 1") + ")");
            }
            if (context instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression2 = (PsiPrefixExpression)context;
                String sign = prefixExpression2.getOperationSign().getText();
                PsiExpression operand = prefixExpression2.getOperand();
                return new TypeConversionDescriptor(sign + "$qualifier$", "$qualifier$.set(" + ThreadLocalConversionRule.getBoxedWrapper(from, to, ThreadLocalConversionRule.toPrimitive("$qualifier$.get()", from, context) + " " + sign.charAt(0) + " 1", labeler, context, operand != null ? operand.getText() + sign.charAt(0) + " 1" : null) + ")");
            }
            if (context instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)context;
                PsiJavaToken signToken = assignmentExpression.getOperationSign();
                IElementType operationSign2 = signToken.getTokenType();
                String sign = signToken.getText();
                PsiExpression lExpression = assignmentExpression.getLExpression();
                if (operationSign2 == JavaTokenType.EQ) {
                    PsiElement element;
                    if (lExpression instanceof PsiReferenceExpression && (element = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiVariable && ((PsiVariable)element).hasModifierProperty("final")) {
                        return ThreadLocalConversionRule.wrapWithNewExpression(from, to, ((PsiAssignmentExpression)context).getRExpression());
                    }
                    return new TypeConversionDescriptor("$qualifier$ = $val$", "$qualifier$.set(" + ThreadLocalConversionRule.coerceType("$val$", from, to, context) + ")");
                }
                PsiExpression rExpression = assignmentExpression.getRExpression();
                String boxedWrapper = ThreadLocalConversionRule.getBoxedWrapper(from, to, ThreadLocalConversionRule.toPrimitive("$qualifier$.get()", from, context) + " " + sign.charAt(0) + " $val$", labeler, context, rExpression != null ? lExpression.getText() + sign.charAt(0) + rExpression.getText() : null);
                return new TypeConversionDescriptor("$qualifier$" + sign + "$val$", "$qualifier$.set(%s)".formatted(boxedWrapper));
            }
        }
        return null;
    }

    private static TypeConversionDescriptor wrapWithNewExpression(PsiType from, PsiClassType to, PsiExpression initializer) {
        List<PsiVariable> toMakeFinal = TypeConversionRuleUtil.getVariablesToMakeFinal(initializer);
        if (toMakeFinal == null) {
            return null;
        }
        return new WrappingWithInnerClassOrLambdaDescriptor("$qualifier$", ThreadLocalConversionRule.createThreadLocalInitializerReplacement(from, to, (PsiElement)initializer), initializer, toMakeFinal);
    }

    @NonNls
    private static String createThreadLocalInitializerReplacement(PsiType from, PsiClassType to, PsiElement context) {
        if (PsiUtil.isAvailable((JavaFeature)JavaFeature.THREAD_LOCAL_WITH_INITIAL, (PsiElement)context)) {
            return "java.lang.ThreadLocal.withInitial(() -> " + ThreadLocalConversionRule.coerceType("$qualifier$", from, to, context) + ")";
        }
        StringBuilder result = new StringBuilder("new ");
        result.append(to.getCanonicalText()).append("() {\n");
        if (PsiUtil.isAvailable((JavaFeature)JavaFeature.ANNOTATIONS, (PsiElement)context)) {
            result.append("  @").append("java.lang.Override").append("\n");
        }
        result.append("  protected ").append(PsiUtil.isAvailable((JavaFeature)JavaFeature.GENERICS, (PsiElement)context) ? to.getParameters()[0].getCanonicalText() : "java.lang.Object").append(" initialValue() {\n").append("    return ").append(ThreadLocalConversionRule.coerceType("$qualifier$", from, to, context)).append(";\n").append("  }\n").append("}");
        return result.toString();
    }

    @NonNls
    private static String toPrimitive(@NonNls String replaceByArg, PsiType from, PsiElement context) {
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)context)) {
            return replaceByArg;
        }
        return from instanceof PsiPrimitiveType ? "((" + ((PsiPrimitiveType)from).getBoxedTypeName() + ")" + replaceByArg + ")." + from.getCanonicalText() + "Value()" : "((" + from.getCanonicalText() + ")" + replaceByArg + ")";
    }

    @NonNls
    private static String coerceType(@NonNls String replaceByArg, PsiType from, PsiClassType to, PsiElement context) {
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)context)) {
            PsiPrimitiveType unboxed;
            if (from instanceof PsiPrimitiveType && (unboxed = PsiPrimitiveType.getUnboxedType((PsiType)to.getParameters()[0])) != null && !from.equals(unboxed)) {
                PsiExpression expression;
                String result;
                if (PsiTypes.longType().equals((Object)unboxed) && (result = ThreadLocalConversionRule.longLiteralText(context, replaceByArg)) != null) {
                    return result;
                }
                return context instanceof PsiExpression && PsiPrecedenceUtil.getPrecedence((PsiExpression)(expression = (PsiExpression)context)) > 4 ? "(" + unboxed.getCanonicalText() + ")(" + replaceByArg + ")" : "(" + unboxed.getCanonicalText() + ")" + replaceByArg;
            }
            return replaceByArg;
        }
        return from instanceof PsiPrimitiveType ? "new " + ((PsiPrimitiveType)from).getBoxedTypeName() + "(" + replaceByArg + ")" : replaceByArg;
    }

    private static String longLiteralText(PsiElement context, String text) {
        if (context instanceof PsiLiteralExpression) {
            return text + "L";
        }
        if (context instanceof PsiPrefixExpression) {
            PsiPrefixExpression expression = (PsiPrefixExpression)context;
            return ThreadLocalConversionRule.longLiteralText((PsiElement)expression.getOperand(), text);
        }
        return null;
    }

    @NonNls
    private static String getBoxedWrapper(PsiType from, PsiClassType to, @NotNull @NonNls String arg, TypeMigrationLabeler labeler, PsiElement context, @Nullable String tryType) {
        if (arg == null) {
            ThreadLocalConversionRule.$$$reportNull$$$0(0);
        }
        if (from instanceof PsiPrimitiveType) {
            PsiType initial;
            PsiPrimitiveType unboxedInitialType;
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)to);
            PsiClass threadLocalClass = resolveResult.getElement();
            LOG.assertTrue(threadLocalClass != null);
            PsiTypeParameter[] typeParameters = threadLocalClass.getTypeParameters();
            if (typeParameters.length == 1 && (unboxedInitialType = PsiPrimitiveType.getUnboxedType((PsiType)(initial = resolveResult.getSubstitutor().substitute(typeParameters[0])))) != null) {
                PsiType exprType;
                if (tryType != null && (exprType = labeler.getTypeEvaluator().evaluateType(JavaPsiFacade.getElementFactory((Project)threadLocalClass.getProject()).createExpressionFromText(tryType, context))) != null && unboxedInitialType.isAssignableFrom(exprType)) {
                    return ThreadLocalConversionRule.coerceType(arg, from, to, context);
                }
                return PsiUtil.isLanguageLevel5OrHigher((PsiElement)context) ? "(" + unboxedInitialType.getCanonicalText() + ")(" + arg + ")" : "new " + initial.getCanonicalText() + "((" + unboxedInitialType.getCanonicalText() + ")(" + arg + "))";
            }
        }
        return ThreadLocalConversionRule.coerceType(arg, from, to, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arg", "com/intellij/refactoring/typeMigration/rules/ThreadLocalConversionRule", "getBoxedWrapper"));
    }

    private static final class WrappingWithInnerClassOrLambdaDescriptor
    extends ArrayInitializerAwareConversionDescriptor {
        private final List<? extends PsiVariable> myVariablesToMakeFinal;

        private WrappingWithInnerClassOrLambdaDescriptor(@NonNls String stringToReplace, @NonNls String replaceByString, PsiExpression expression, @NotNull List<? extends PsiVariable> toMakeFinal) {
            if (toMakeFinal == null) {
                WrappingWithInnerClassOrLambdaDescriptor.$$$reportNull$$$0(0);
            }
            super(stringToReplace, replaceByString, expression);
            this.myVariablesToMakeFinal = toMakeFinal;
        }

        @Override
        public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
            if (evaluator == null) {
                WrappingWithInnerClassOrLambdaDescriptor.$$$reportNull$$$0(1);
            }
            PsiExpression replaced = super.replace(expression, evaluator);
            boolean effectivelyFinalSupported = PsiUtil.isAvailable((JavaFeature)JavaFeature.EFFECTIVELY_FINAL, (PsiElement)replaced);
            for (PsiVariable psiVariable : this.myVariablesToMakeFinal) {
                if (effectivelyFinalSupported && ControlFlowUtil.isEffectivelyFinal((PsiVariable)psiVariable, (PsiElement)replaced)) continue;
                VariableAccessFromInnerClassFix.fixAccess((PsiVariable)psiVariable, (PsiElement)replaced);
            }
            return replaced;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toMakeFinal";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "evaluator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/ThreadLocalConversionRule$WrappingWithInnerClassOrLambdaDescriptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "replace";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

