/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.siyeh.ig.controlflow.UnnecessaryReturnInspection;
import com.siyeh.ig.fixes.DeleteUnnecessaryStatementFix;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VoidConversionRule
extends TypeConversionRule {
    @Nullable
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        if (PsiTypes.voidType().equals((Object)to) && context.getParent() instanceof PsiReturnStatement) {
            return new TypeConversionDescriptorBase(this){

                public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
                    PsiElement parent;
                    PsiDocTag docTag;
                    PsiDocComment docComment;
                    PsiMethod method;
                    if (evaluator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class)) != null && (docComment = method.getDocComment()) != null && (docTag = docComment.findTagByName("return")) != null) {
                        docTag.delete();
                    }
                    if ((parent = expression.getParent()) instanceof PsiReturnStatement) {
                        PsiElementFactory factory;
                        PsiReturnStatement replaced;
                        if (SideEffectChecker.mayHaveSideEffects((PsiExpression)expression)) {
                            List sideEffectExpressions = SideEffectChecker.extractSideEffectExpressions((PsiExpression)expression);
                            PsiStatement[] sideEffectStatements = StatementExtractor.generateStatements((List)sideEffectExpressions, (PsiExpression)expression);
                            PsiElement grandParent = parent.getParent();
                            for (PsiStatement statement : sideEffectStatements) {
                                grandParent.addBefore((PsiElement)statement, parent);
                            }
                        }
                        if (UnnecessaryReturnInspection.isReturnRedundant((PsiReturnStatement)(replaced = (PsiReturnStatement)parent.replace((PsiElement)(factory = JavaPsiFacade.getElementFactory((Project)expression.getProject())).createStatementFromText("return;", null))), (boolean)false, (boolean)false, null)) {
                            DeleteUnnecessaryStatementFix.deleteUnnecessaryStatement((PsiStatement)replaced);
                        }
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/VoidConversionRule$1", "replace"));
                }
            };
        }
        return null;
    }
}

