/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.inspections.GuavaConversionSettings;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GuavaConversionUtil {
    private static final Logger LOG = Logger.getInstance(GuavaConversionUtil.class);

    GuavaConversionUtil() {
    }

    @Nullable
    public static PsiType getFunctionReturnType(PsiExpression functionExpression) {
        if (functionExpression instanceof PsiFunctionalExpression) {
            return LambdaUtil.getFunctionalInterfaceReturnType((PsiFunctionalExpression)((PsiFunctionalExpression)functionExpression));
        }
        PsiType currentType = functionExpression.getType();
        if (currentType == null) {
            return null;
        }
        block0: do {
            if (LambdaUtil.isFunctionalType((PsiType)currentType)) {
                return LambdaUtil.getFunctionalInterfaceReturnType((PsiType)currentType);
            }
            PsiType[] superTypes = currentType.getSuperTypes();
            currentType = null;
            for (PsiType type : superTypes) {
                PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)type);
                if (aClass == null || !InheritanceUtil.isInheritor((PsiClass)aClass, (String)GuavaLambda.FUNCTION.getClassQName())) continue;
                currentType = type;
                continue block0;
            }
        } while (currentType != null);
        return null;
    }

    @NotNull
    public static PsiType addTypeParameters(@NotNull String baseClassQualifiedName, @Nullable PsiType type, @NotNull PsiElement context) {
        String canonicalText;
        if (baseClassQualifiedName == null) {
            GuavaConversionUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            GuavaConversionUtil.$$$reportNull$$$0(1);
        }
        String parameterText = "";
        if (type != null && (canonicalText = type.getCanonicalText(false)).contains("<")) {
            parameterText = canonicalText.substring(canonicalText.indexOf(60));
        }
        PsiType psiType = JavaPsiFacade.getElementFactory((Project)context.getProject()).createTypeFromText(baseClassQualifiedName + parameterText, context);
        if (psiType == null) {
            GuavaConversionUtil.$$$reportNull$$$0(2);
        }
        return psiType;
    }

    public static boolean isJavaLambda(PsiElement element, TypeEvaluator evaluator) {
        PsiElement parent;
        if (element instanceof PsiLocalVariable) {
            return GuavaLambda.findJavaAnalogueFor(evaluator.getType(element)) != null;
        }
        if (element instanceof PsiReturnStatement) {
            PsiElement methodOrLambda = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            PsiType methodReturnType = null;
            if (methodOrLambda instanceof PsiMethod) {
                methodReturnType = evaluator.getType(methodOrLambda);
            }
            return GuavaLambda.findJavaAnalogueFor(methodReturnType) != null;
        }
        if (element instanceof PsiExpressionList && (parent = element.getParent()) instanceof PsiMethodCallExpression) {
            return evaluator.getType(parent) != null;
        }
        return false;
    }

    public static PsiExpression adjustLambdaContainingExpression(PsiExpression expression, boolean insertTypeCase, PsiType targetType, @NotNull TypeEvaluator evaluator) {
        PsiExpression qualifier;
        PsiType evaluatedType;
        GuavaLambda lambda;
        if (evaluator == null) {
            GuavaConversionUtil.$$$reportNull$$$0(3);
        }
        if (expression instanceof PsiNewExpression) {
            PsiAnonymousClass anonymousClass = ((PsiNewExpression)expression).getAnonymousClass();
            if (anonymousClass != null) {
                return GuavaConversionUtil.convertAnonymousClass((PsiNewExpression)expression, anonymousClass, evaluator);
            }
            GuavaLambda lambda2 = GuavaLambda.findFor(evaluator.evaluateType(expression));
            if (lambda2 == null) {
                return expression;
            }
            PsiExpression expressionWithMethodReference = GuavaConversionUtil.addMethodReference(expression, lambda2);
            if (insertTypeCase) {
                return GuavaConversionUtil.adjustLambdaContainingExpression(expressionWithMethodReference, true, targetType, evaluator);
            }
            return expressionWithMethodReference;
        }
        if (expression instanceof PsiMethodReferenceExpression && (lambda = GuavaLambda.findJavaAnalogueFor(evaluatedType = evaluator.evaluateType(qualifier = ((PsiMethodReferenceExpression)expression).getQualifierExpression()))) != null) {
            PsiExpression replaced = (PsiExpression)expression.replace((PsiElement)qualifier);
            if (targetType == null && lambda.getSamName().equals(((PsiMethodReferenceExpression)expression).getReferenceName())) {
                return replaced;
            }
            return GuavaConversionUtil.adjustLambdaContainingExpression(replaced, insertTypeCase, targetType, evaluator);
        }
        if (expression instanceof PsiFunctionalExpression) {
            if (insertTypeCase) {
                return JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText("((" + targetType.getCanonicalText() + ")" + expression.getText() + ")", (PsiElement)expression);
            }
        } else if (expression instanceof PsiMethodCallExpression || expression instanceof PsiReferenceExpression) {
            GuavaLambda lambda3;
            PsiType type = expression.getType();
            if (targetType != null && type != null && !targetType.isAssignableFrom(type) && (lambda3 = GuavaLambda.findFor(evaluator.evaluateType(expression))) != null) {
                expression = GuavaConversionUtil.addMethodReference(expression, lambda3);
                return GuavaConversionUtil.adjustLambdaContainingExpression(expression, insertTypeCase, targetType, evaluator);
            }
        }
        return expression;
    }

    public static PsiExpression convertAnonymousClass(@NotNull PsiNewExpression expression, @NotNull PsiAnonymousClass anonymousClass, @NotNull TypeEvaluator typeEvaluator) {
        GuavaConversionSettings settings;
        Set<Object> ignoredAnnotations;
        if (expression == null) {
            GuavaConversionUtil.$$$reportNull$$$0(4);
        }
        if (anonymousClass == null) {
            GuavaConversionUtil.$$$reportNull$$$0(5);
        }
        if (typeEvaluator == null) {
            GuavaConversionUtil.$$$reportNull$$$0(6);
        }
        Set<Object> set = ignoredAnnotations = (settings = (GuavaConversionSettings)typeEvaluator.getSettings(GuavaConversionSettings.class)) != null ? settings.getIgnoredAnnotations() : Collections.emptySet();
        if (AnonymousCanBeLambdaInspection.canBeConvertedToLambda((PsiAnonymousClass)anonymousClass, (boolean)true, ignoredAnnotations)) {
            return AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)expression, (boolean)true, (boolean)true);
        }
        return GuavaConversionUtil.tryConvertClassAndSamNameToJava(expression);
    }

    public static PsiExpression tryConvertClassAndSamNameToJava(PsiNewExpression expression) {
        PsiElement currentClassName;
        GuavaLambda lambda = GuavaLambda.findFor(expression.getType());
        if (lambda == null) {
            return expression;
        }
        PsiAnonymousClass aClass = expression.getAnonymousClass();
        LOG.assertTrue(aClass != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
        if (!lambda.getSamName().equals(lambda.getJavaAnalogueSamName())) {
            boolean isFound = false;
            for (PsiMethod method : aClass.findMethodsByName(lambda.getSamName(), false)) {
                if (method.getParameterList().getParametersCount() == lambda.getParametersCount()) {
                    for (PsiMethod psiMethod : method.findSuperMethods()) {
                        PsiClass superMethodContainingClass = psiMethod.getContainingClass();
                        if (superMethodContainingClass == null || !lambda.getClassQName().equals(superMethodContainingClass.getQualifiedName())) continue;
                        PsiIdentifier methodNameIdentifier = method.getNameIdentifier();
                        LOG.assertTrue(methodNameIdentifier != null);
                        methodNameIdentifier.replace((PsiElement)factory.createIdentifier(lambda.getJavaAnalogueSamName()));
                        isFound = true;
                        break;
                    }
                }
                if (isFound) break;
            }
        }
        if ((currentClassName = aClass.getBaseClassReference().getReferenceNameElement()) != null) {
            PsiJavaCodeReferenceElement newNameElement = factory.createReferenceFromText(lambda.getJavaAnalogueClassQName(), null);
            currentClassName.replace((PsiElement)newNameElement);
        }
        return (PsiExpression)expression.replace((PsiElement)factory.createExpressionFromText(expression.getText(), null));
    }

    private static PsiExpression addMethodReference(@NotNull PsiExpression expression, @NotNull GuavaLambda lambda) {
        if (expression == null) {
            GuavaConversionUtil.$$$reportNull$$$0(7);
        }
        if (lambda == null) {
            GuavaConversionUtil.$$$reportNull$$$0(8);
        }
        PsiExpression methodReference = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(expression.getText() + "::" + lambda.getSamName(), (PsiElement)expression);
        return (PsiExpression)expression.replace((PsiElement)methodReference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassQualifiedName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeEvaluator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/guava/GuavaConversionUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addTypeParameters";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "adjustLambdaContainingExpression";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertAnonymousClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addMethodReference";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

