/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.inspections.GuavaConversionSettings;
import com.intellij.refactoring.typeMigration.rules.guava.BaseGuavaTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.FunctionalInterfaceTypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaLambdaConversionRule
extends BaseGuavaTypeConversionRule {
    private final GuavaLambda myLambda;

    protected GuavaLambdaConversionRule(GuavaLambda lambda) {
        this.myLambda = lambda;
    }

    @Override
    protected void fillSimpleDescriptors(Map<String, TypeConversionDescriptorBase> descriptorsMap) {
        descriptorsMap.put(this.myLambda.getSamName(), new FunctionalInterfaceTypeConversionDescriptor(this.myLambda.getSamName(), this.myLambda.getJavaAnalogueSamName(), this.myLambda.getJavaAnalogueClassQName()));
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForVariableReference(PsiExpression context) {
        return new FunctionalInterfaceTypeConversionDescriptor(this.myLambda.getSamName(), this.myLambda.getJavaAnalogueSamName(), this.myLambda.getJavaAnalogueClassQName());
    }

    @Override
    @NotNull
    public String ruleFromClass() {
        String string = this.myLambda.getClassQName();
        if (string == null) {
            GuavaLambdaConversionRule.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String ruleToClass() {
        String string = this.myLambda.getJavaAnalogueClassQName();
        if (string == null) {
            GuavaLambdaConversionRule.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected TypeConversionDescriptorBase getUnknownMethodConversion() {
        return new TypeConversionDescriptor("$q$.$m$($args$)", "$q$.$m$($args$)::" + this.myLambda.getJavaAnalogueSamName());
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForAnonymous(@NotNull PsiAnonymousClass anonymousClass, GuavaConversionSettings settings) {
        TypeConversionDescriptorBase conversion;
        if (anonymousClass == null) {
            GuavaLambdaConversionRule.$$$reportNull$$$0(2);
        }
        if ((conversion = super.findConversionForAnonymous(anonymousClass, settings)) != null) {
            return conversion;
        }
        PsiClass baseClass = anonymousClass.getBaseClassType().resolve();
        return baseClass != null && this.myLambda.getClassQName().equals(baseClass.getQualifiedName()) ? new ConvertLambdaClassToJavaClassDescriptor() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/rules/guava/GuavaLambdaConversionRule";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anonymousClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "ruleFromClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ruleToClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/rules/guava/GuavaLambdaConversionRule";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findConversionForAnonymous";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }

    private static class ConvertLambdaClassToJavaClassDescriptor
    extends TypeConversionDescriptorBase {
        private ConvertLambdaClassToJavaClassDescriptor() {
        }

        public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
            if (evaluator == null) {
                ConvertLambdaClassToJavaClassDescriptor.$$$reportNull$$$0(0);
            }
            return GuavaConversionUtil.tryConvertClassAndSamNameToJava((PsiNewExpression)expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaLambdaConversionRule$ConvertLambdaClassToJavaClassDescriptor", "replace"));
        }
    }

    public static final class Supplier
    extends GuavaLambdaConversionRule {
        public Supplier() {
            super(GuavaLambda.SUPPLIER);
        }
    }

    public static final class Function
    extends GuavaLambdaConversionRule {
        public Function() {
            super(GuavaLambda.FUNCTION);
        }
    }
}

