/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/javascript/microservices/HttpClientIndexingHandler;", "Lcom/intellij/lang/javascript/index/FrameworkIndexingHandler;", "<init>", "()V", "httpClientIdentifiers", "", "", "getMarkers", "", "elementToIndex", "Lcom/intellij/psi/PsiElement;", "functionIsCallingHttp", "", "node", "Lcom/intellij/lang/ASTNode;", "shouldCreateStubForCallExpression", "intellij.javascript.langInjection"})
public final class HttpClientIndexingHandler
extends FrameworkIndexingHandler {
    @NotNull
    private final Set<String> httpClientIdentifiers;

    public HttpClientIndexingHandler() {
        Object[] objectArray = new String[]{"fetch", "axios"};
        this.httpClientIdentifiers = SetsKt.setOf((Object[])objectArray);
    }

    @NotNull
    public List<String> getMarkers(@NotNull PsiElement elementToIndex) {
        Intrinsics.checkNotNullParameter((Object)elementToIndex, (String)"elementToIndex");
        if (!(elementToIndex instanceof JSCallExpression)) {
            List list = super.getMarkers(elementToIndex);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getMarkers(...)");
            return list;
        }
        ASTNode aSTNode = ((JSCallExpression)elementToIndex).getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        if (this.functionIsCallingHttp(aSTNode)) {
            return CollectionsKt.listOf((Object)"HTTP_REQUEST_CALLER");
        }
        return CollectionsKt.emptyList();
    }

    private final boolean functionIsCallingHttp(ASTNode node) {
        ASTNode methodExpression = node.getFirstChildNode();
        if (methodExpression.getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
            return false;
        }
        ASTNode aSTNode = methodExpression.getFirstChildNode();
        if (aSTNode == null) {
            return false;
        }
        ASTNode referencedNameElement = aSTNode;
        return this.httpClientIdentifiers.contains(referencedNameElement.getText());
    }

    public boolean shouldCreateStubForCallExpression(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.functionIsCallingHttp(node);
    }
}

