/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.action;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.terminal.frontend.action.SendShortcutToTerminalActionKt;
import com.intellij.terminal.frontend.view.impl.TerminalEventsHandler;
import com.intellij.terminal.frontend.view.impl.TerminalEventsHandlerKt;
import com.intellij.terminal.frontend.view.impl.TimedKeyEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalBundle;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0000\u00a2\u0006\u0002\b\rJ\u0015\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/terminal/frontend/action/SendShortcutToTerminalAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "handler", "Lcom/intellij/terminal/frontend/view/impl/TerminalEventsHandler;", "<init>", "(Lcom/intellij/terminal/frontend/view/impl/TerminalEventsHandler;)V", "actions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "register", "", "component", "Ljavax/swing/JComponent;", "register$intellij_terminal_frontend", "unregister", "unregister$intellij_terminal_frontend", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "Companion", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nSendShortcutToTerminalAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SendShortcutToTerminalAction.kt\ncom/intellij/terminal/frontend/action/SendShortcutToTerminalAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,108:1\n1391#2:109\n1480#2,5:110\n37#3,2:115\n67#4,4:117\n13#4:121\n*S KotlinDebug\n*F\n+ 1 SendShortcutToTerminalAction.kt\ncom/intellij/terminal/frontend/action/SendShortcutToTerminalAction\n*L\n47#1:109\n47#1:110,5\n48#1:115,2\n89#1:117,4\n94#1:121\n*E\n"})
public final class SendShortcutToTerminalAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalEventsHandler handler;
    @NotNull
    private List<? extends AnAction> actions;
    @NotNull
    private static final Logger LOG;

    public SendShortcutToTerminalAction(@NotNull TerminalEventsHandler handler) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        this.handler = handler;
        this.actions = CollectionsKt.emptyList();
        this.getTemplatePresentation().putClientProperty(SendShortcutToTerminalActionKt.access$getKEY$p(), (Object)Unit.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public final void register$intellij_terminal_frontend(@NotNull JComponent component2, @NotNull List<? extends AnAction> actions) {
        void $this$toTypedArray$iv;
        void $this$flatMapTo$iv$iv;
        Collection $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Iterable iterable = actions;
        boolean $i$f$flatMap = false;
        void var7_5 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            AnAction it = (AnAction)element$iv$iv;
            boolean bl = false;
            Shortcut[] shortcutArray = it.getShortcutSet().getShortcuts();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            Iterable list$iv$iv = ArraysKt.toList((Object[])shortcutArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Shortcut[] shortcutArray = thisCollection$iv.toArray(new Shortcut[0]);
        Shortcut[] shortcutArray2 = Arrays.copyOf(shortcutArray, shortcutArray.length);
        CustomShortcutSet terminalShortcuts = new CustomShortcutSet(shortcutArray2);
        this.registerCustomShortcutSet((ShortcutSet)terminalShortcuts, component2);
        this.actions = actions;
    }

    public final void unregister$intellij_terminal_frontend(@NotNull JComponent component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        this.unregisterCustomShortcutSet(component2);
        this.actions = CollectionsKt.emptyList();
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!(e.getInputEvent() instanceof KeyEvent)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Shortcut shortcut = IdeEventQueue.Companion.getInstance().getKeyEventDispatcher().getContext().getShortcut();
        if (shortcut == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        for (AnAction anAction : this.actions) {
            Shortcut[] shortcutArray = anAction.getShortcutSet().getShortcuts();
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            if (!ArraysKt.contains((Object[])shortcutArray, (Object)shortcut) || !e.getUpdateSession().presentation(anAction).isEnabled()) continue;
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Object[] objectArray = new Object[]{shortcut.toString()};
        e.getPresentation().setText(TerminalBundle.message("action.Terminal.SendShortcut.detailed.text", objectArray));
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        InputEvent inputEvent = e.getInputEvent();
        KeyEvent keyEvent = inputEvent instanceof KeyEvent ? (KeyEvent)inputEvent : null;
        if (keyEvent == null) {
            return;
        }
        KeyEvent event = keyEvent;
        Logger $this$trace$iv = LOG;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("All actions bound to this shortcut are disabled, sending key event to terminal: " + event);
        }
        TerminalEventsHandlerKt.handleKeyEvent(this.handler, new TimedKeyEvent(event, null, 2, null));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SendShortcutToTerminalAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/terminal/frontend/action/SendShortcutToTerminalAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

