/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerKeys;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.frontend.editor.TerminalViewFileEditor;
import com.intellij.terminal.frontend.editor.TerminalViewVirtualFile;
import com.intellij.terminal.ui.TerminalWidget;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.vfs.ClassicTerminalSessionEditor;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/terminal/frontend/editor/TerminalViewFileEditorProvider;", "Lcom/intellij/openapi/fileEditor/FileEditorProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "accept", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "acceptRequiresReadAction", "createEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getEditorTypeId", "", "Lorg/jetbrains/annotations/NonNls;", "getPolicy", "Lcom/intellij/openapi/fileEditor/FileEditorPolicy;", "intellij.terminal.frontend"})
public final class TerminalViewFileEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file instanceof TerminalViewVirtualFile;
    }

    public boolean acceptRequiresReadAction() {
        return false;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        TerminalViewVirtualFile terminalFile = (TerminalViewVirtualFile)file;
        if (Intrinsics.areEqual((Object)file.getUserData(FileEditorManagerKeys.CLOSING_TO_REOPEN), (Object)true)) {
            return new TerminalViewFileEditor(project, terminalFile);
        }
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable tempDisposable = disposable;
        ShellStartupOptions options = new ShellStartupOptions.Builder().build();
        TerminalWidget terminalWidget = new LocalTerminalDirectRunner(project).startShellTerminalWidget(tempDisposable, options, true);
        Intrinsics.checkNotNullExpressionValue((Object)terminalWidget, (String)"startShellTerminalWidget(...)");
        TerminalWidget newWidget = terminalWidget;
        TerminalSessionVirtualFileImpl newFile = new TerminalSessionVirtualFileImpl(terminalFile.getName(), newWidget, (SettingsProvider)new JBTerminalSystemSettingsProvider());
        ClassicTerminalSessionEditor editor = new ClassicTerminalSessionEditor(project, newFile);
        Disposer.dispose((Disposable)tempDisposable);
        return editor;
    }

    @NotNull
    public String getEditorTypeId() {
        return "terminal-view-editor";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        return FileEditorPolicy.HIDE_DEFAULT_EDITOR;
    }
}

