/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.fus;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.terminal.frontend.fus.FocusedComponent;
import com.intellij.terminal.frontend.fus.FocusedNonToolWindow;
import com.intellij.terminal.frontend.fus.FocusedTerminal;
import com.intellij.terminal.frontend.fus.FocusedToolWindow;
import com.intellij.terminal.frontend.fus.InitialState;
import com.intellij.terminal.frontend.fus.TerminalFocusFusServiceKt;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.ui.ComponentUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalPanelMarker;
import org.jetbrains.plugins.terminal.fus.ReworkedTerminalUsageCollector;
import org.jetbrains.plugins.terminal.fus.TerminalNonToolWindowFocus;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\f\b\u0001\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\nH\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0015H\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\u000e\u0010\u001a\u001a\u00020\u0015H\u0082@\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\nH\u0002J\u0010\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\r\u001a\u0004\u0018\u00010\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000b\u001a\u0004\u0018\u00010\u0010@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lcom/intellij/terminal/frontend/fus/TerminalFocusFusService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "stateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/terminal/frontend/fus/FocusedComponent;", "value", "Ljava/awt/Window;", "focusedWindow", "setFocusedWindow", "(Ljava/awt/Window;)V", "Ljava/awt/Component;", "focusedComponent", "setFocusedComponent", "(Ljava/awt/Component;)V", "updateState", "", "computeCurrentState", "ensureInitialized", "initializeState", "installAWTListener", "collectState", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "logFocusEnteringTerminal", "previousState", "logFocusLeavingTerminal", "nextState", "Companion", "intellij.terminal.frontend"})
public final class TerminalFocusFusService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private final MutableStateFlow<FocusedComponent> stateFlow;
    @Nullable
    private Window focusedWindow;
    @Nullable
    private Component focusedComponent;

    public TerminalFocusFusService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.initialized = new AtomicBoolean(false);
        this.stateFlow = StateFlowKt.MutableStateFlow((Object)InitialState.INSTANCE);
    }

    private final void setFocusedWindow(Window value) {
        this.focusedWindow = value;
        this.updateState();
    }

    private final void setFocusedComponent(Component value) {
        this.focusedComponent = value;
        this.updateState();
    }

    private final void updateState() {
        this.stateFlow.setValue((Object)this.computeCurrentState());
    }

    private final FocusedComponent computeCurrentState() {
        FocusedComponent focusedComponent;
        Component focusedComponent2 = this.focusedComponent;
        Window focusedWindow = this.focusedWindow;
        if (focusedComponent2 == null || focusedWindow == null) {
            focusedComponent = new FocusedNonToolWindow(TerminalNonToolWindowFocus.OTHER_APPLICATION);
        } else if (ComponentUtil.getParentOfType(TerminalPanelMarker.class, (Component)focusedComponent2) != null) {
            focusedComponent = FocusedTerminal.INSTANCE;
        } else if (ComponentUtil.getParentOfType(EditorsSplitters.class, (Component)focusedComponent2) != null) {
            focusedComponent = new FocusedNonToolWindow(TerminalNonToolWindowFocus.EDITOR);
        } else {
            String id;
            InternalDecoratorImpl internalDecoratorImpl = (InternalDecoratorImpl)ComponentUtil.getParentOfType(InternalDecoratorImpl.class, (Component)focusedComponent2);
            String string = id = internalDecoratorImpl != null ? internalDecoratorImpl.getToolWindowId() : null;
            focusedComponent = Intrinsics.areEqual((Object)id, (Object)"Terminal") ? (FocusedComponent)FocusedTerminal.INSTANCE : (id != null ? (FocusedComponent)new FocusedToolWindow(id) : (FocusedComponent)new FocusedNonToolWindow(TerminalNonToolWindowFocus.OTHER_COMPONENT));
        }
        return focusedComponent;
    }

    private final void ensureInitialized() {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getUI((Dispatchers)Dispatchers.INSTANCE).plus((CoroutineContext)new CoroutineName("TerminalFocusFusService initialization")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalFocusFusService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        TerminalFocusFusService.access$initializeState(this.this$0);
                        TerminalFocusFusService.access$installAWTListener(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)new CoroutineName("TerminalFocusFusService state collector")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TerminalFocusFusService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TerminalFocusFusService.access$collectState(this.this$0, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final void initializeState() {
        this.setFocusedWindow(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow());
        this.setFocusedComponent(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
    }

    private final void installAWTListener() {
        AWTEventListener listener2 = arg_0 -> TerminalFocusFusService.installAWTListener$lambda$0(this, arg_0);
        Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 524292L);
        JobKt.getJob((CoroutineContext)this.coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> TerminalFocusFusService.installAWTListener$lambda$1(listener2, this, arg_0));
    }

    private final Object collectState(Continuation<? super Unit> $completion) {
        Ref.ObjectRef previousState = new Ref.ObjectRef();
        previousState.element = InitialState.INSTANCE;
        Object object = FlowKt.collectLatest((Flow)FlowKt.distinctUntilChanged((Flow)FlowKt.debounce((Flow)((Flow)this.stateFlow), (long)500L)), (Function2)((Function2)new Function2<FocusedComponent, Continuation<? super Unit>, Object>((Ref.ObjectRef<FocusedComponent>)previousState, this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ Ref.ObjectRef<FocusedComponent> $previousState;
            final /* synthetic */ TerminalFocusFusService this$0;
            {
                this.$previousState = $previousState;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                FocusedComponent focusedComponent = (FocusedComponent)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void state;
                        ResultKt.throwOnFailure((Object)$result);
                        if (!TerminalFocusFusServiceKt.access$isTerminalFocused((FocusedComponent)this.$previousState.element) && TerminalFocusFusServiceKt.access$isTerminalFocused((FocusedComponent)state)) {
                            TerminalFocusFusService.access$logFocusEnteringTerminal(this.this$0, (FocusedComponent)this.$previousState.element);
                        } else if (TerminalFocusFusServiceKt.access$isTerminalFocused((FocusedComponent)this.$previousState.element) && !TerminalFocusFusServiceKt.access$isTerminalFocused((FocusedComponent)state)) {
                            TerminalFocusFusService.access$logFocusLeavingTerminal(this.this$0, (FocusedComponent)state);
                        }
                        this.$previousState.element = state;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(FocusedComponent p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void logFocusEnteringTerminal(FocusedComponent previousState) {
        String fusString = previousState.toFusString();
        if (fusString == null) {
            TerminalFocusFusServiceKt.access$getLOG$p().debug("Not logging the terminal focus event because it's the first focused component");
            return;
        }
        TerminalFocusFusServiceKt.access$getLOG$p().debug("The terminal gained focus from '" + fusString + "'");
        ReworkedTerminalUsageCollector.logFocusGained(fusString);
    }

    private final void logFocusLeavingTerminal(FocusedComponent nextState) {
        String fusString = nextState.toFusString();
        if (fusString == null) {
            TerminalFocusFusServiceKt.access$getLOG$p().warn("Focus is leaving the terminal, but it's not known where it's going. This is a bug");
            return;
        }
        TerminalFocusFusServiceKt.access$getLOG$p().debug("Focus is going from the terminal to '" + fusString + "'");
        ReworkedTerminalUsageCollector.logFocusLost(fusString);
    }

    private static final void installAWTListener$lambda$0(TerminalFocusFusService this$0, AWTEvent event) {
        switch (event.getID()) {
            case 207: {
                Object object = event.getSource();
                this$0.setFocusedWindow(object instanceof Window ? (Window)object : null);
                break;
            }
            case 208: {
                this$0.setFocusedWindow(null);
                break;
            }
            case 1004: {
                Object object = event.getSource();
                this$0.setFocusedComponent(object instanceof Component ? (Component)object : null);
            }
        }
    }

    private static final Unit installAWTListener$lambda$1(AWTEventListener $listener, TerminalFocusFusService this$0, Throwable it) {
        Toolkit.getDefaultToolkit().removeAWTEventListener($listener);
        this$0.setFocusedWindow(null);
        this$0.setFocusedComponent(null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$initializeState(TerminalFocusFusService $this) {
        $this.initializeState();
    }

    public static final /* synthetic */ void access$installAWTListener(TerminalFocusFusService $this) {
        $this.installAWTListener();
    }

    public static final /* synthetic */ Object access$collectState(TerminalFocusFusService $this, Continuation $completion) {
        return $this.collectState((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$logFocusEnteringTerminal(TerminalFocusFusService $this, FocusedComponent previousState) {
        $this.logFocusEnteringTerminal(previousState);
    }

    public static final /* synthetic */ void access$logFocusLeavingTerminal(TerminalFocusFusService $this, FocusedComponent nextState) {
        $this.logFocusLeavingTerminal(nextState);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/terminal/frontend/fus/TerminalFocusFusService$Companion;", "", "<init>", "()V", "ensureInitialized", "", "intellij.terminal.frontend"})
    @SourceDebugExtension(value={"SMAP\nTerminalFocusFusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalFocusFusService.kt\ncom/intellij/terminal/frontend/fus/TerminalFocusFusService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,190:1\n42#2,3:191\n*S KotlinDebug\n*F\n+ 1 TerminalFocusFusService.kt\ncom/intellij/terminal/frontend/fus/TerminalFocusFusService$Companion\n*L\n161#1:191,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void ensureInitialized() {
            boolean $i$f$service = false;
            Class<TerminalFocusFusService> serviceClass$iv = TerminalFocusFusService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            ((TerminalFocusFusService)object).ensureInitialized();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

