/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.completion;

import com.intellij.codeInsight.completion.CompletionLookupArrangerImpl;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.OffsetsInFile;
import com.intellij.codeInsight.completion.impl.CompletionSorterImpl;
import com.intellij.codeInsight.lookup.LookupArranger;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.LookupListener;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionContext;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionProcess;
import com.intellij.terminal.frontend.view.completion.TerminalCommandCompletionService;
import com.intellij.terminal.frontend.view.impl.TerminalViewImplKt;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0006H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0010H\u0016J\u000e\u0010&\u001a\u00020'2\u0006\u0010\r\u001a\u00020\u000eJ$\u0010(\u001a\u00020'2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0017J\b\u0010,\u001a\u00020\u0012H\u0007J\b\u0010-\u001a\u00020'H\u0016J\b\u0010.\u001a\u00020'H\u0003J\b\u0010/\u001a\u00020\u0012H\u0007J\u0010\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u000202H\u0002J\u001a\u00103\u001a\u00020'2\b\u00104\u001a\u0004\u0018\u0001022\u0006\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u00020'H\u0016J \u00108\u001a\u00020'2\u0006\u00109\u001a\u00020\u00172\u000e\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010<0;H\u0016J\b\u0010=\u001a\u00020'H\u0007J\u001f\u0010>\u001a\u00020'2\u000b\u0010?\u001a\u00070<\u00a2\u0006\u0002\b@2\b\u0010A\u001a\u0004\u0018\u00010BH\u0016J\u0010\u0010C\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020GH\u0016J\u001a\u0010H\u001a\u00020'2\u0010\u0010I\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010K0JH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001a\u00a8\u0006L"}, d2={"Lcom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionProcess;", "Lcom/intellij/codeInsight/completion/CompletionProcessEx;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "context", "Lcom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionContext;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionContext;Lcom/intellij/codeInsight/lookup/impl/LookupImpl;Lkotlinx/coroutines/CoroutineScope;)V", "getContext", "()Lcom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionContext;", "arranger", "Lcom/intellij/codeInsight/completion/CompletionLookupArrangerImpl;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "restartOnPrefixChange", "", "value", "restartPending", "getRestartPending", "()Z", "", "beforePrefixReplacementLength", "getBeforePrefixReplacementLength", "()I", "afterPrefixReplacementLength", "getAfterPrefixReplacementLength", "getProject", "Lcom/intellij/openapi/project/Project;", "getEditor", "Lcom/intellij/openapi/editor/Editor;", "getLookup", "getCaret", "Lcom/intellij/openapi/editor/Caret;", "isAutopopupCompletion", "getParameters", "setLookupArranger", "", "addItems", "items", "", "Lcom/intellij/codeInsight/completion/CompletionResult;", "tryInsertOrShowPopup", "prefixUpdated", "closeLookupIfMeaningless", "isPopupMeaningless", "isAlreadyTyped", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "itemSelected", "item", "completionChar", "", "scheduleRestart", "addWatchedPrefix", "startOffset", "restartCondition", "Lcom/intellij/patterns/ElementPattern;", "", "cancel", "addAdvertisement", "message", "Lcom/intellij/openapi/util/NlsContexts$PopupAdvertisement;", "icon", "Ljavax/swing/Icon;", "setParameters", "getOffsetMap", "Lcom/intellij/codeInsight/completion/OffsetMap;", "getHostOffsets", "Lcom/intellij/codeInsight/completion/OffsetsInFile;", "registerChildDisposable", "child", "Ljava/util/function/Supplier;", "Lcom/intellij/openapi/Disposable;", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nTerminalCommandCompletionProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCommandCompletionProcess.kt\ncom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,258:1\n1786#2,3:259\n*S KotlinDebug\n*F\n+ 1 TerminalCommandCompletionProcess.kt\ncom/intellij/terminal/frontend/view/completion/TerminalCommandCompletionProcess\n*L\n188#1:259,3\n*E\n"})
public final class TerminalCommandCompletionProcess
extends UserDataHolderBase
implements CompletionProcessEx {
    @NotNull
    private final TerminalCommandCompletionContext context;
    @NotNull
    private final LookupImpl lookup;
    @NotNull
    private final CoroutineScope coroutineScope;
    @Nullable
    private CompletionLookupArrangerImpl arranger;
    @NotNull
    private final CompletionParameters parameters;
    private boolean restartOnPrefixChange;
    private boolean restartPending;
    private int beforePrefixReplacementLength;
    private int afterPrefixReplacementLength;

    public TerminalCommandCompletionProcess(@NotNull TerminalCommandCompletionContext context, @NotNull LookupImpl lookup, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.context = context;
        this.lookup = lookup;
        this.coroutineScope = coroutineScope;
        LookupArranger lookupArranger = this.lookup.getArranger();
        this.arranger = lookupArranger instanceof CompletionLookupArrangerImpl ? (CompletionLookupArrangerImpl)lookupArranger : null;
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(this.getEditor().getDocument());
        if (psiFile == null) {
            throw new IllegalStateException(("Can't find PSI file for " + this.getEditor().getDocument()).toString());
        }
        PsiFile psiFile2 = psiFile;
        int offset = RangesKt.coerceIn((int)this.getEditor().getCaretModel().getOffset(), (int)0, (int)(this.getEditor().getDocument().getTextLength() - 1));
        PsiElement psiElement = psiFile2.findElementAt(0);
        Intrinsics.checkNotNull((Object)psiElement);
        PsiElement element = psiElement;
        this.parameters = new CompletionParameters(element, psiFile2, CompletionType.BASIC, offset, 1, this.getEditor(), (CompletionProcess)this);
        this.lookup.setCalculating(true);
        LookupListener lookupListener2 = new LookupListener(this){
            final /* synthetic */ TerminalCommandCompletionProcess this$0;
            {
                this.this$0 = $receiver;
            }

            public void lookupCanceled(LookupEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.this$0.cancel();
            }
        };
        this.lookup.addLookupListener(lookupListener2);
        JobKt.getJob((CoroutineContext)this.coroutineScope.getCoroutineContext()).invokeOnCompletion(arg_0 -> TerminalCommandCompletionProcess._init_$lambda$0(this, lookupListener2, arg_0));
    }

    @NotNull
    public final TerminalCommandCompletionContext getContext() {
        return this.context;
    }

    public final boolean getRestartPending() {
        return this.restartPending;
    }

    public final int getBeforePrefixReplacementLength() {
        return this.beforePrefixReplacementLength;
    }

    public final int getAfterPrefixReplacementLength() {
        return this.afterPrefixReplacementLength;
    }

    @NotNull
    public Project getProject() {
        return this.context.getProject();
    }

    @NotNull
    public Editor getEditor() {
        return this.context.getEditor();
    }

    @NotNull
    public LookupImpl getLookup() {
        return this.lookup;
    }

    @NotNull
    public Caret getCaret() {
        Caret caret = this.getEditor().getCaretModel().getPrimaryCaret();
        Intrinsics.checkNotNullExpressionValue((Object)caret, (String)"getPrimaryCaret(...)");
        return caret;
    }

    public boolean isAutopopupCompletion() {
        return this.context.isAutoPopup();
    }

    @NotNull
    public CompletionParameters getParameters() {
        return this.parameters;
    }

    public final void setLookupArranger(@NotNull CompletionLookupArrangerImpl arranger2) {
        Intrinsics.checkNotNullParameter((Object)arranger2, (String)"arranger");
        this.arranger = arranger2;
        this.lookup.setArranger((LookupArranger)arranger2);
    }

    public final void addItems(@NotNull List<CompletionResult> items, int beforePrefixReplacementLength, int afterPrefixReplacementLength) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (this.lookup.isLookupDisposed()) {
            return;
        }
        this.beforePrefixReplacementLength = beforePrefixReplacementLength;
        this.afterPrefixReplacementLength = afterPrefixReplacementLength;
        CompletionLookupArrangerImpl completionLookupArrangerImpl = this.arranger;
        if (completionLookupArrangerImpl == null) {
            throw new IllegalStateException("CompletionLookupArrangerImpl is null".toString());
        }
        CompletionLookupArrangerImpl curArranger = completionLookupArrangerImpl;
        curArranger.batchUpdate(() -> TerminalCommandCompletionProcess.addItems$lambda$0(items, this, curArranger));
        curArranger.setLastLookupPrefix(this.lookup.getAdditionalPrefix());
    }

    @RequiresEdt
    public final boolean tryInsertOrShowPopup() {
        this.lookup.setCalculating(false);
        this.lookup.refreshUi(true, false);
        List list = this.lookup.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        List items = list;
        if (items.isEmpty()) {
            return false;
        }
        if (!this.isAutopopupCompletion() && items.size() == 1) {
            this.lookup.finishLookup('\u0000', (LookupElement)CollectionsKt.single((List)items));
            return false;
        }
        if (!this.lookup.isShown()) {
            boolean shown = this.lookup.showLookup();
            if (!shown) {
                return false;
            }
            this.lookup.refreshUi(true, true);
            this.lookup.ensureSelectionVisible(true);
        }
        return true;
    }

    public void prefixUpdated() {
        int startOffset = this.lookup.getLookupStart();
        int cursorOffset = TerminalViewImplKt.toRelative(this.context.getOutputModel().getCursorOffset(), this.context.getOutputModel());
        if (cursorOffset > startOffset && this.restartOnPrefixChange) {
            this.scheduleRestart();
        }
        this.closeLookupIfMeaningless();
    }

    @RequiresEdt
    private final void closeLookupIfMeaningless() {
        if (this.lookup.isLookupDisposed() || this.lookup.isCalculating() || this.restartPending) {
            return;
        }
        this.lookup.refreshUi(true, true);
        if (this.isPopupMeaningless()) {
            this.cancel();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RequiresEdt
    public final boolean isPopupMeaningless() {
        LookupElement it;
        List list = this.lookup.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        List items = list;
        if (items.isEmpty()) return true;
        Iterable $this$all$iv = items;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (LookupElement)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
        } while (this.isAlreadyTyped(it));
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAlreadyTyped(LookupElement element) {
        TerminalOutputModel model = this.context.getOutputModel();
        TerminalOffset startOffset = model.getCursorOffset().minus(this.lookup.itemPattern(element).length());
        if (startOffset.compareTo(model.getStartOffset()) < 0) return false;
        CharSequence charSequence = model.getText(startOffset, model.getEndOffset());
        String string = element.getLookupString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLookupString(...)");
        if (!StringsKt.startsWith$default((CharSequence)charSequence, (CharSequence)string, (boolean)false, (int)2, null)) return false;
        return true;
    }

    public void itemSelected(@Nullable LookupElement item, char completionChar) {
        this.cancel();
    }

    public void scheduleRestart() {
        if (this.restartPending) {
            return;
        }
        this.restartPending = true;
        this.cancel();
        TerminalCommandCompletionService.Companion.getInstance(this.getProject()).invokeCompletion(this.context.getTerminalView(), this.context.getEditor(), this.context.getOutputModel(), this.context.getShellIntegration(), this.context.isAutoPopup());
    }

    public void addWatchedPrefix(int startOffset, @NotNull ElementPattern<String> restartCondition) {
        Intrinsics.checkNotNullParameter(restartCondition, (String)"restartCondition");
        this.restartOnPrefixChange = true;
    }

    @RequiresEdt
    public final void cancel() {
        CoroutineScopeKt.cancel$default((CoroutineScope)this.coroutineScope, null, (int)1, null);
        this.lookup.setCalculating(false);
        if (!this.restartPending) {
            this.lookup.hideLookup(false);
        }
    }

    public void addAdvertisement(@NotNull String message, @Nullable Icon icon) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
    }

    public void setParameters(@NotNull CompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public OffsetMap getOffsetMap() {
        throw new NotImplementedError(null, 1, null);
    }

    @NotNull
    public OffsetsInFile getHostOffsets() {
        throw new NotImplementedError(null, 1, null);
    }

    public void registerChildDisposable(@NotNull Supplier<? extends Disposable> child) {
        Intrinsics.checkNotNullParameter(child, (String)"child");
        throw new NotImplementedError(null, 1, null);
    }

    private static final Unit _init_$lambda$0(TerminalCommandCompletionProcess this$0, lookupListener.1 $lookupListener, Throwable it) {
        this$0.lookup.removeLookupListener((LookupListener)$lookupListener);
        return Unit.INSTANCE;
    }

    private static final void addItems$lambda$0(List $items, TerminalCommandCompletionProcess this$0, CompletionLookupArrangerImpl $curArranger) {
        for (CompletionResult item : $items) {
            JobKt.ensureActive((CoroutineContext)this$0.coroutineScope.getCoroutineContext());
            LookupElement lookupElement = item.getLookupElement();
            CompletionSorter completionSorter = item.getSorter();
            Intrinsics.checkNotNull((Object)completionSorter, (String)"null cannot be cast to non-null type com.intellij.codeInsight.completion.impl.CompletionSorterImpl");
            $curArranger.associateSorter(lookupElement, (CompletionSorterImpl)completionSorter);
            this$0.lookup.addItem(item.getLookupElement(), item.getPrefixMatcher());
        }
    }
}

