/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal.frontend.view.hyperlinks;

import com.intellij.execution.impl.EditorTextDecoration;
import com.intellij.execution.impl.EditorTextDecorationApplier;
import com.intellij.execution.impl.EditorTextDecorationApplierKt;
import com.intellij.execution.impl.EditorTextDecorationId;
import com.intellij.execution.impl.HighlightingBuilder;
import com.intellij.execution.impl.HighlightingDecoration;
import com.intellij.execution.impl.HyperlinkBuilder;
import com.intellij.execution.impl.HyperlinkDecoration;
import com.intellij.execution.impl.InlayDecoration;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.terminal.frontend.view.impl.TerminalInput;
import com.intellij.terminal.frontend.view.impl.TerminalViewImplKt;
import com.intellij.util.CoroutineScopeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.reworked.hyperlinks.TerminalHyperlinksModel;
import org.jetbrains.plugins.terminal.session.impl.TerminalFilterResultInfo;
import org.jetbrains.plugins.terminal.session.impl.TerminalHighlightingInfo;
import org.jetbrains.plugins.terminal.session.impl.TerminalHyperlinkId;
import org.jetbrains.plugins.terminal.session.impl.TerminalHyperlinkInfo;
import org.jetbrains.plugins.terminal.session.impl.TerminalHyperlinksChangedEvent;
import org.jetbrains.plugins.terminal.session.impl.TerminalHyperlinksModelStateKt;
import org.jetbrains.plugins.terminal.session.impl.TerminalInlayInfo;
import org.jetbrains.plugins.terminal.session.impl.dto.TerminalFilterResultInfoDto;
import org.jetbrains.plugins.terminal.session.impl.dto.TerminalHyperlinksDtoKt;
import org.jetbrains.plugins.terminal.session.impl.dto.TerminalHyperlinksModelStateDto;
import org.jetbrains.plugins.terminal.view.TerminalOffset;
import org.jetbrains.plugins.terminal.view.TerminalOutputModel;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u0010\u0010\u0018\u001a\u00020\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0016\u0010\u001e\u001a\u00020\u00132\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u000e\u0010\"\u001a\u0004\u0018\u00010#*\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/terminal/frontend/view/hyperlinks/FrontendTerminalHyperlinkFacade;", "", "isInAlternateBuffer", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "outputModel", "Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;", "terminalInput", "Lcom/intellij/terminal/frontend/view/impl/TerminalInput;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(ZLcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/plugins/terminal/view/TerminalOutputModel;Lcom/intellij/terminal/frontend/view/impl/TerminalInput;Lkotlinx/coroutines/CoroutineScope;)V", "model", "Lorg/jetbrains/plugins/terminal/block/reworked/hyperlinks/TerminalHyperlinksModel;", "applier", "Lcom/intellij/execution/impl/EditorTextDecorationApplier;", "updateHyperlinks", "", "event", "Lorg/jetbrains/plugins/terminal/session/impl/TerminalHyperlinksChangedEvent;", "getHoveredHyperlinkId", "Lorg/jetbrains/plugins/terminal/session/impl/TerminalHyperlinkId;", "restoreFromState", "hyperlinksModelState", "Lorg/jetbrains/plugins/terminal/session/impl/dto/TerminalHyperlinksModelStateDto;", "removeHyperlinks", "absoluteStartOffset", "", "addHyperlinks", "hyperlinks", "", "Lorg/jetbrains/plugins/terminal/session/impl/TerminalFilterResultInfo;", "toEditorDecoration", "Lcom/intellij/execution/impl/EditorTextDecoration;", "intellij.terminal.frontend"})
@SourceDebugExtension(value={"SMAP\nFrontendTerminalHyperlinkFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendTerminalHyperlinkFacade.kt\ncom/intellij/terminal/frontend/view/hyperlinks/FrontendTerminalHyperlinkFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1586#2:101\n1661#2,3:102\n1586#2:105\n1661#2,3:106\n1586#2:109\n1661#2,3:110\n1642#2,10:113\n1915#2:123\n1916#2:125\n1652#2:126\n1#3:124\n*S KotlinDebug\n*F\n+ 1 FrontendTerminalHyperlinkFacade.kt\ncom/intellij/terminal/frontend/view/hyperlinks/FrontendTerminalHyperlinkFacade\n*L\n42#1:101\n42#1:102,3\n52#1:105\n52#1:106,3\n57#1:109\n57#1:110,3\n63#1:113,10\n63#1:123\n63#1:125\n63#1:126\n63#1:124\n*E\n"})
public final class FrontendTerminalHyperlinkFacade {
    private final boolean isInAlternateBuffer;
    @NotNull
    private final TerminalOutputModel outputModel;
    @NotNull
    private final TerminalInput terminalInput;
    @NotNull
    private final TerminalHyperlinksModel model;
    @NotNull
    private final EditorTextDecorationApplier applier;

    public FrontendTerminalHyperlinkFacade(boolean isInAlternateBuffer, @NotNull EditorEx editor, @NotNull TerminalOutputModel outputModel, @NotNull TerminalInput terminalInput, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)outputModel, (String)"outputModel");
        Intrinsics.checkNotNullParameter((Object)terminalInput, (String)"terminalInput");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.isInAlternateBuffer = isInAlternateBuffer;
        this.outputModel = outputModel;
        this.terminalInput = terminalInput;
        this.model = new TerminalHyperlinksModel(this.isInAlternateBuffer ? "Frontend AltBuf" : "Frontend Output", this.outputModel);
        this.applier = EditorTextDecorationApplierKt.createEditorTextDecorationApplier((EditorEx)editor, (Disposable)CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope));
    }

    /*
     * WARNING - void declaration
     */
    public final void updateHyperlinks(@NotNull TerminalHyperlinksChangedEvent event) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Long removedFrom = event.getRemoveFromOffset();
        if (removedFrom != null) {
            this.removeHyperlinks(removedFrom);
        }
        Iterable iterable = event.getHyperlinks();
        FrontendTerminalHyperlinkFacade frontendTerminalHyperlinkFacade = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TerminalFilterResultInfoDto terminalFilterResultInfoDto = (TerminalFilterResultInfoDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TerminalHyperlinksDtoKt.toFilterResultInfo((TerminalFilterResultInfoDto)it));
        }
        frontendTerminalHyperlinkFacade.addHyperlinks((List)destination$iv$iv);
    }

    @Nullable
    public final TerminalHyperlinkId getHoveredHyperlinkId() {
        HyperlinkDecoration hyperlinkDecoration = this.applier.getHoveredHyperlink();
        return hyperlinkDecoration != null && (hyperlinkDecoration = hyperlinkDecoration.getId()) != null ? TerminalHyperlinksModelStateKt.toTerminalId((EditorTextDecorationId)hyperlinkDecoration) : null;
    }

    /*
     * WARNING - void declaration
     */
    public final void restoreFromState(@Nullable TerminalHyperlinksModelStateDto hyperlinksModelState) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (hyperlinksModelState == null) {
            return;
        }
        this.removeHyperlinks(0L);
        Iterable iterable = hyperlinksModelState.getHyperlinks();
        FrontendTerminalHyperlinkFacade frontendTerminalHyperlinkFacade = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TerminalFilterResultInfoDto terminalFilterResultInfoDto = (TerminalFilterResultInfoDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TerminalHyperlinksDtoKt.toFilterResultInfo((TerminalFilterResultInfoDto)it));
        }
        frontendTerminalHyperlinkFacade.addHyperlinks((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void removeHyperlinks(long absoluteStartOffset) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Collection<TerminalHyperlinkId> removed = this.model.removeHyperlinks(absoluteStartOffset);
        Iterable iterable = removed;
        EditorTextDecorationApplier editorTextDecorationApplier = this.applier;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TerminalHyperlinkId terminalHyperlinkId = (TerminalHyperlinkId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TerminalHyperlinksModelStateKt.toPlatformId((TerminalHyperlinkId)it));
        }
        editorTextDecorationApplier.removeDecorations((Collection)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final void addHyperlinks(List<? extends TerminalFilterResultInfo> hyperlinks) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        this.model.addHyperlinks(hyperlinks);
        Iterable iterable = hyperlinks;
        EditorTextDecorationApplier editorTextDecorationApplier = this.applier;
        boolean $i$f$mapNotNull = false;
        void var4_5 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            EditorTextDecoration it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            TerminalFilterResultInfo it = (TerminalFilterResultInfo)element$iv$iv;
            boolean bl2 = false;
            if (this.toEditorDecoration(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        editorTextDecorationApplier.addDecorations((Collection)((List)destination$iv$iv));
    }

    private final EditorTextDecoration toEditorDecoration(TerminalFilterResultInfo $this$toEditorDecoration) {
        EditorTextDecoration editorTextDecoration;
        TerminalFilterResultInfo terminalFilterResultInfo = $this$toEditorDecoration;
        if (terminalFilterResultInfo instanceof TerminalHyperlinkInfo) {
            editorTextDecoration = (EditorTextDecoration)EditorTextDecorationApplierKt.buildHyperlink((EditorTextDecorationId)TerminalHyperlinksModelStateKt.toPlatformId(((TerminalHyperlinkInfo)$this$toEditorDecoration).getId()), (int)TerminalViewImplKt.toRelative(TerminalOffset.Companion.of(((TerminalHyperlinkInfo)$this$toEditorDecoration).getAbsoluteStartOffset()), this.outputModel), (int)TerminalViewImplKt.toRelative(TerminalOffset.Companion.of(((TerminalHyperlinkInfo)$this$toEditorDecoration).getAbsoluteEndOffset()), this.outputModel), arg_0 -> FrontendTerminalHyperlinkFacade.toEditorDecoration$lambda$0(this, $this$toEditorDecoration, arg_0), arg_0 -> FrontendTerminalHyperlinkFacade.toEditorDecoration$lambda$1($this$toEditorDecoration, arg_0));
        } else if (terminalFilterResultInfo instanceof TerminalHighlightingInfo) {
            HighlightingDecoration highlightingDecoration;
            TextAttributes textAttributes = ((TerminalHighlightingInfo)$this$toEditorDecoration).getStyle();
            if (textAttributes != null) {
                TextAttributes style = textAttributes;
                boolean bl = false;
                highlightingDecoration = EditorTextDecorationApplierKt.buildHighlighting((EditorTextDecorationId)TerminalHyperlinksModelStateKt.toPlatformId(((TerminalHighlightingInfo)$this$toEditorDecoration).getId()), (int)TerminalViewImplKt.toRelative(TerminalOffset.Companion.of(((TerminalHighlightingInfo)$this$toEditorDecoration).getAbsoluteStartOffset()), this.outputModel), (int)TerminalViewImplKt.toRelative(TerminalOffset.Companion.of(((TerminalHighlightingInfo)$this$toEditorDecoration).getAbsoluteEndOffset()), this.outputModel), (TextAttributes)style, FrontendTerminalHyperlinkFacade::toEditorDecoration$lambda$2$0);
            } else {
                highlightingDecoration = null;
            }
            editorTextDecoration = (EditorTextDecoration)highlightingDecoration;
        } else if (terminalFilterResultInfo instanceof TerminalInlayInfo) {
            InlayDecoration inlayDecoration;
            InlayProvider inlayProvider = ((TerminalInlayInfo)$this$toEditorDecoration).getInlayProvider();
            if (inlayProvider != null) {
                InlayProvider inlayProvider2 = inlayProvider;
                boolean bl = false;
                inlayDecoration = EditorTextDecorationApplierKt.buildInlay$default((EditorTextDecorationId)TerminalHyperlinksModelStateKt.toPlatformId(((TerminalInlayInfo)$this$toEditorDecoration).getId()), (int)TerminalViewImplKt.toRelative(TerminalOffset.Companion.of(((TerminalInlayInfo)$this$toEditorDecoration).getAbsoluteEndOffset()), this.outputModel), (InlayProvider)inlayProvider2, null, (int)8, null);
            } else {
                inlayDecoration = null;
            }
            editorTextDecoration = (EditorTextDecoration)inlayDecoration;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return editorTextDecoration;
    }

    private static final Unit toEditorDecoration$lambda$2$0(HighlightingBuilder $this$buildHighlighting) {
        Intrinsics.checkNotNullParameter((Object)$this$buildHighlighting, (String)"$this$buildHighlighting");
        $this$buildHighlighting.setLayer($this$buildHighlighting.getLayer());
        return Unit.INSTANCE;
    }

    private static final Unit toEditorDecoration$lambda$0(FrontendTerminalHyperlinkFacade this$0, TerminalFilterResultInfo $this_toEditorDecoration, EditorMouseEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.terminalInput.sendLinkClicked(this$0.isInAlternateBuffer, ((TerminalHyperlinkInfo)$this_toEditorDecoration).getId(), it);
        return Unit.INSTANCE;
    }

    private static final Unit toEditorDecoration$lambda$1(TerminalFilterResultInfo $this_toEditorDecoration, HyperlinkBuilder $this$buildHyperlink) {
        Intrinsics.checkNotNullParameter((Object)$this$buildHyperlink, (String)"$this$buildHyperlink");
        $this$buildHyperlink.setAttributes(((TerminalHyperlinkInfo)$this_toEditorDecoration).getStyle());
        $this$buildHyperlink.setFollowedAttributes(((TerminalHyperlinkInfo)$this_toEditorDecoration).getFollowedStyle());
        $this$buildHyperlink.setHoveredAttributes(((TerminalHyperlinkInfo)$this_toEditorDecoration).getHoveredStyle());
        $this$buildHyperlink.setLayer($this$buildHyperlink.getLayer());
        return Unit.INSTANCE;
    }
}

