/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.arrangement;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.ijent.IjentChildPtyProcessAdapter;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.system.OS;
import com.pty4j.windows.conpty.WinConPtyProcess;
import com.pty4j.windows.winpty.WinPtyProcess;
import java.io.File;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelIterator;
import kotlinx.coroutines.channels.ChannelKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.arrangement.ProcessInfoUtil;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0002\u0018\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0086@\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000f2\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u0004\u0018\u00010\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/terminal/arrangement/ProcessInfoUtil;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "cwdComputeRequests", "Lkotlinx/coroutines/channels/Channel;", "Lorg/jetbrains/plugins/terminal/arrangement/ProcessInfoUtil$CwdComputeRequest;", "getCurrentWorkingDirectory", "", "process", "Ljava/lang/Process;", "(Ljava/lang/Process;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCurrentWorkingDirectoryDeferred", "Lkotlinx/coroutines/CompletableDeferred;", "doGetCwd", "tryGetCwdFastOnUnix", "pid", "", "getCwdOnUnix", "parseWorkingDirectory", "stdoutLines", "", "CwdComputeRequest", "Companion", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nProcessInfoUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessInfoUtil.kt\norg/jetbrains/plugins/terminal/arrangement/ProcessInfoUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,151:1\n61#2,4:152\n13#2:156\n*S KotlinDebug\n*F\n+ 1 ProcessInfoUtil.kt\norg/jetbrains/plugins/terminal/arrangement/ProcessInfoUtil\n*L\n106#1:152,4\n147#1:156\n*E\n"})
public final class ProcessInfoUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Channel<CwdComputeRequest> cwdComputeRequests;
    @NotNull
    private static final Logger LOG;
    private static final int TIMEOUT_MILLIS = 2000;

    public ProcessInfoUtil(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.cwdComputeRequests = ChannelKt.Channel$default((int)0, null, null, (int)7, null);
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ ProcessInfoUtil this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = ProcessInfoUtil.access$getCwdComputeRequests$p(this.this$0).iterator();
lbl6:
                        // 3 sources

                        while (true) {
                            this.L$0 = var2_3;
                            this.label = 1;
                            v0 = var2_3.hasNext((Continuation)this);
                            if (v0 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl17
                            break;
                        }
                    }
                    case 1: {
                        var2_3 = (ChannelIterator)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl17:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) ** GOTO lbl31
                        request = (CwdComputeRequest)var2_3.next();
                        try {
                            cwd = ProcessInfoUtil.access$doGetCwd(this.this$0, request.getProcess());
                            request.getCwdDeferred().complete((Object)cwd);
                            ** GOTO lbl6
                        }
                        catch (CancellationException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            request.getCwdDeferred().completeExceptionally((Throwable)e);
                            ** continue;
                        }
lbl31:
                        // 1 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object getCurrentWorkingDirectory(@NotNull Process process, @NotNull Continuation<? super String> $completion) throws ExecutionException, IllegalStateException {
        if (!($completion instanceof getCurrentWorkingDirectory.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ ProcessInfoUtil this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getCurrentWorkingDirectory(null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!process.isAlive()) break;
                deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                request = new CwdComputeRequest(process, (CompletableDeferred<String>)deferred);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)process);
                $continuation.L$1 = deferred;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.label = 1;
                v0 = this.cwdComputeRequests.send((Object)request, (Continuation)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl29
            }
            case 1: {
                request = (CwdComputeRequest)$continuation.L$2;
                deferred = (CompletableDeferred)$continuation.L$1;
                process = (Process)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl29:
                // 2 sources

                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)process);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)deferred);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)request);
                $continuation.label = 2;
                v1 = deferred.await((Continuation)$continuation);
                if (v1 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl43
            }
            case 2: {
                request = (CwdComputeRequest)$continuation.L$2;
                deferred = (CompletableDeferred)$continuation.L$1;
                process = (Process)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                return v1;
            }
        }
        return null;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CompletableDeferred<String> getCurrentWorkingDirectoryDeferred(@NotNull Process process) {
        CompletableDeferred completableDeferred;
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        if (process.isAlive()) {
            void var2_2;
            CompletableDeferred deferred2 = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
            CwdComputeRequest request = new CwdComputeRequest(process, (CompletableDeferred<String>)deferred2);
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, request, null){
                int label;
                final /* synthetic */ ProcessInfoUtil this$0;
                final /* synthetic */ CwdComputeRequest $request;
                {
                    this.this$0 = $receiver;
                    this.$request = $request;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = ProcessInfoUtil.access$getCwdComputeRequests$p(this.this$0).send((Object)this.$request, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            completableDeferred = var2_2;
        } else {
            completableDeferred = CompletableDeferredKt.CompletableDeferred(null);
        }
        return completableDeferred;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String doGetCwd(Process process) throws IllegalStateException {
        String string;
        if (process instanceof IjentChildPtyProcessAdapter) {
            return null;
        }
        if (SystemInfo.isUnix) {
            int pid = (int)process.pid();
            String string2 = this.tryGetCwdFastOnUnix(pid);
            string = string2;
            if (string2 != null) return string;
            string = this.getCwdOnUnix(pid);
            return string;
        } else {
            if (!SystemInfo.isWindows) throw new IllegalStateException(("Unsupported OS: " + OS.CURRENT).toString());
            Process process2 = process;
            if (process2 instanceof WinPtyProcess) {
                string = ((WinPtyProcess)process).getWorkingDirectory();
                return string;
            } else {
                if (!(process2 instanceof WinConPtyProcess)) throw new IllegalStateException(("Cwd cannot be fetched for " + process.getClass()).toString());
                string = ((WinConPtyProcess)process).getWorkingDirectory();
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String tryGetCwdFastOnUnix(int pid) {
        block3: {
            String procPath = "/proc/" + pid + "/cwd";
            try {
                File dir = Paths.get(procPath, new String[0]).toRealPath(new LinkOption[0]).toFile();
                if (dir.isDirectory()) {
                    return dir.getAbsolutePath();
                }
            }
            catch (Exception e) {
                void $this$debug$iv;
                Logger logger = LOG;
                Throwable t$iv = e;
                boolean $i$f$debug = false;
                if (!$this$debug$iv.isDebugEnabled()) break block3;
                void var8_8 = $this$debug$iv;
                boolean bl = false;
                var8_8.debug("Cannot resolve cwd from " + procPath + ", fallback to lsof -a -d cwd -p " + pid, t$iv);
            }
        }
        return null;
    }

    private final String getCwdOnUnix(int pid) throws ExecutionException {
        String[] stringArray = new String[]{"lsof", "-a", "-d", "cwd", "-p", String.valueOf(pid), "-Fn"};
        GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
        CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)new OSProcessHandler(commandLine));
        ProcessOutput processOutput = runner.runProcess(2000);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        ProcessOutput output = processOutput;
        if (output.isTimeout()) {
            throw new ExecutionException("Timeout running " + commandLine.getCommandLineString());
        }
        if (output.getExitCode() != 0) {
            throw new ExecutionException("Exit code " + output.getExitCode() + " for " + commandLine.getCommandLineString());
        }
        List list = output.getStdoutLines();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStdoutLines(...)");
        String string = this.parseWorkingDirectory(list, pid);
        if (string == null) {
            throw new ExecutionException("Cannot parse working directory from " + commandLine.getCommandLineString());
        }
        return string;
    }

    private final String parseWorkingDirectory(List<String> stdoutLines, int pid) {
        boolean pidEncountered = false;
        for (String line : stdoutLines) {
            if (StringsKt.startsWith$default((String)line, (String)"p", (boolean)false, (int)2, null)) {
                String string = line.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                int p = StringUtil.parseInt((String)string, (int)-1);
                pidEncountered = pidEncountered || p == pid;
                continue;
            }
            if (!pidEncountered || !StringsKt.startsWith$default((String)line, (String)"n", (boolean)false, (int)2, null)) continue;
            String string = line.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }
        return null;
    }

    @JvmStatic
    @NotNull
    public static final ProcessInfoUtil getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ Channel access$getCwdComputeRequests$p(ProcessInfoUtil $this) {
        return $this.cwdComputeRequests;
    }

    public static final /* synthetic */ String access$doGetCwd(ProcessInfoUtil $this, Process process) {
        return $this.doGetCwd(process);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProcessInfoUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/terminal/arrangement/ProcessInfoUtil$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/plugins/terminal/arrangement/ProcessInfoUtil;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "TIMEOUT_MILLIS", "", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nProcessInfoUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessInfoUtil.kt\norg/jetbrains/plugins/terminal/arrangement/ProcessInfoUtil$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,151:1\n42#2,3:152\n*S KotlinDebug\n*F\n+ 1 ProcessInfoUtil.kt\norg/jetbrains/plugins/terminal/arrangement/ProcessInfoUtil$Companion\n*L\n145#1:152,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProcessInfoUtil getInstance() {
            boolean $i$f$service = false;
            Class<ProcessInfoUtil> serviceClass$iv = ProcessInfoUtil.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ProcessInfoUtil)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0011\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u00c6\u0003J%\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0006H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/terminal/arrangement/ProcessInfoUtil$CwdComputeRequest;", "", "process", "Ljava/lang/Process;", "cwdDeferred", "Lkotlinx/coroutines/CompletableDeferred;", "", "<init>", "(Ljava/lang/Process;Lkotlinx/coroutines/CompletableDeferred;)V", "getProcess", "()Ljava/lang/Process;", "getCwdDeferred", "()Lkotlinx/coroutines/CompletableDeferred;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal"})
    private static final class CwdComputeRequest {
        @NotNull
        private final Process process;
        @NotNull
        private final CompletableDeferred<String> cwdDeferred;

        public CwdComputeRequest(@NotNull Process process, @NotNull CompletableDeferred<String> cwdDeferred) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Intrinsics.checkNotNullParameter(cwdDeferred, (String)"cwdDeferred");
            this.process = process;
            this.cwdDeferred = cwdDeferred;
        }

        @NotNull
        public final Process getProcess() {
            return this.process;
        }

        @NotNull
        public final CompletableDeferred<String> getCwdDeferred() {
            return this.cwdDeferred;
        }

        @NotNull
        public final Process component1() {
            return this.process;
        }

        @NotNull
        public final CompletableDeferred<String> component2() {
            return this.cwdDeferred;
        }

        @NotNull
        public final CwdComputeRequest copy(@NotNull Process process, @NotNull CompletableDeferred<String> cwdDeferred) {
            Intrinsics.checkNotNullParameter((Object)process, (String)"process");
            Intrinsics.checkNotNullParameter(cwdDeferred, (String)"cwdDeferred");
            return new CwdComputeRequest(process, cwdDeferred);
        }

        public static /* synthetic */ CwdComputeRequest copy$default(CwdComputeRequest cwdComputeRequest, Process process, CompletableDeferred completableDeferred, int n, Object object) {
            if ((n & 1) != 0) {
                process = cwdComputeRequest.process;
            }
            if ((n & 2) != 0) {
                completableDeferred = cwdComputeRequest.cwdDeferred;
            }
            return cwdComputeRequest.copy(process, completableDeferred);
        }

        @NotNull
        public String toString() {
            return "CwdComputeRequest(process=" + this.process + ", cwdDeferred=" + this.cwdDeferred + ")";
        }

        public int hashCode() {
            int result2 = this.process.hashCode();
            result2 = result2 * 31 + this.cwdDeferred.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CwdComputeRequest)) {
                return false;
            }
            CwdComputeRequest cwdComputeRequest = (CwdComputeRequest)other;
            if (!Intrinsics.areEqual((Object)this.process, (Object)cwdComputeRequest.process)) {
                return false;
            }
            return Intrinsics.areEqual(this.cwdDeferred, cwdComputeRequest.cwdDeferred);
        }
    }
}

