/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.prompt.renderer;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalColorPalette;
import com.jediterm.core.Color;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.ArrayTerminalDataStream;
import com.jediterm.terminal.CursorShape;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TerminalDisplay;
import com.jediterm.terminal.TerminalMode;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.emulator.JediEmulator;
import com.jediterm.terminal.emulator.mouse.MouseFormat;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import com.jediterm.terminal.model.CharBuffer;
import com.jediterm.terminal.model.JediTerminal;
import com.jediterm.terminal.model.LinesBuffer;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalLine;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.TerminalTextBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.EmptyTextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.HighlightingInfo;
import org.jetbrains.plugins.terminal.block.output.TerminalTextHighlighterKt;
import org.jetbrains.plugins.terminal.block.output.TextStyleAdapter;
import org.jetbrains.plugins.terminal.block.output.TextWithHighlightings;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptRenderingInfo;
import org.jetbrains.plugins.terminal.block.prompt.TerminalPromptState;
import org.jetbrains.plugins.terminal.block.prompt.renderer.BuiltInPromptRenderer;
import org.jetbrains.plugins.terminal.block.prompt.renderer.TerminalPromptRenderer;
import org.jetbrains.plugins.terminal.block.session.ShellCommandOutputScraperImpl;
import org.jetbrains.plugins.terminal.block.session.StyledCommandOutput;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtilsKt;
import org.jetbrains.plugins.terminal.session.impl.StyleRange;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 &2\u00020\u0001:\u0003$%&B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\b\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\u001a\u001a\u00020\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J\u001c\u0010\u001f\u001a\u00020 *\u00020 2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0019H\u0002J\f\u0010#\u001a\u00020 *\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/renderer/ShellPromptRenderer;", "Lorg/jetbrains/plugins/terminal/block/prompt/renderer/TerminalPromptRenderer;", "colorPalette", "Lcom/intellij/terminal/TerminalColorPalette;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "terminalSizeProvider", "Lkotlin/Function0;", "Lcom/jediterm/core/util/TermSize;", "<init>", "(Lcom/intellij/terminal/TerminalColorPalette;Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;Lkotlin/jvm/functions/Function0;)V", "fallbackRenderer", "calculateRenderingInfo", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptRenderingInfo;", "state", "Lorg/jetbrains/plugins/terminal/block/prompt/TerminalPromptState;", "expandPrompt", "Lorg/jetbrains/plugins/terminal/block/prompt/renderer/ShellPromptRenderer$ExpandedPromptInfo;", "escapedPrompt", "", "toHighlightings", "", "Lorg/jetbrains/plugins/terminal/block/output/HighlightingInfo;", "Lorg/jetbrains/plugins/terminal/session/impl/StyleRange;", "totalTextLength", "", "cursorToLogicalPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "Lcom/jediterm/terminal/model/LinesBuffer;", "cursorX", "cursorY", "subtext", "Lorg/jetbrains/plugins/terminal/block/output/TextWithHighlightings;", "startOffset", "endOffset", "trimStart", "ExpandedPromptInfo", "FakeDisplay", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellPromptRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellPromptRenderer.kt\norg/jetbrains/plugins/terminal/block/prompt/renderer/ShellPromptRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,239:1\n1#2:240\n1849#3,3:241\n363#3,7:244\n363#3,7:251\n759#3,10:258\n13#4:268\n*S KotlinDebug\n*F\n+ 1 ShellPromptRenderer.kt\norg/jetbrains/plugins/terminal/block/prompt/renderer/ShellPromptRenderer\n*L\n65#1:241,3\n150#1:244,7\n151#1:251,7\n174#1:258,10\n236#1:268\n*E\n"})
public final class ShellPromptRenderer
implements TerminalPromptRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TerminalColorPalette colorPalette;
    @NotNull
    private final JBTerminalSystemSettingsProviderBase settings;
    @NotNull
    private final Function0<TermSize> terminalSizeProvider;
    @NotNull
    private final TerminalPromptRenderer fallbackRenderer;
    @NotNull
    private static final Logger LOG;

    public ShellPromptRenderer(@NotNull TerminalColorPalette colorPalette, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull Function0<TermSize> terminalSizeProvider) {
        Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(terminalSizeProvider, (String)"terminalSizeProvider");
        this.colorPalette = colorPalette;
        this.settings = settings;
        this.terminalSizeProvider = terminalSizeProvider;
        this.fallbackRenderer = new BuiltInPromptRenderer(this.colorPalette, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TerminalPromptRenderingInfo calculateRenderingInfo(@NotNull TerminalPromptState state) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        String escapedPrompt = state.getOriginalPrompt();
        String escapedRightPrompt = state.getOriginalRightPrompt();
        if (escapedPrompt == null) {
            LOG.warn("Original prompt is null, falling back to built-in prompt. Prompt state: " + state);
            return this.fallbackRenderer.calculateRenderingInfo(state);
        }
        if (escapedRightPrompt != null) {
            pair = TuplesKt.to((Object)this.expandPrompt(escapedPrompt).getContent(), (Object)this.expandPrompt(escapedRightPrompt).getContent());
        } else {
            boolean bl;
            ExpandedPromptInfo promptInfo = this.expandPrompt(escapedPrompt);
            String[] stringArray = new String[]{"\n"};
            List lines = StringsKt.split$default((CharSequence)promptInfo.getContent().getText(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean bl2 = bl = lines.size() == promptInfo.getCursorY() + 1;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-ShellPromptRenderer$calculateRenderingInfo$32 = false;
                String $i$a$-assert-ShellPromptRenderer$calculateRenderingInfo$32 = "Cursor is not at the last prompt line. Expanded prompt: " + promptInfo + ", prompt state: " + state;
                throw new AssertionError((Object)$i$a$-assert-ShellPromptRenderer$calculateRenderingInfo$32);
            }
            boolean bl3 = bl = ((String)lines.get(promptInfo.getCursorY())).length() >= promptInfo.getCursorX();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-ShellPromptRenderer$calculateRenderingInfo$42 = false;
                String $i$a$-assert-ShellPromptRenderer$calculateRenderingInfo$42 = "Cursor X position is out of prompt line length. Expanded prompt: " + promptInfo + ", prompt state: " + state;
                throw new AssertionError((Object)$i$a$-assert-ShellPromptRenderer$calculateRenderingInfo$42);
            }
            String string = ((String)lines.get(promptInfo.getCursorY())).substring(promptInfo.getCursorX());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String rightText = string;
            if (!StringsKt.isBlank((CharSequence)rightText)) {
                void $this$fold$iv;
                List fullLines = lines.subList(0, lines.size() - 1);
                Iterable iterable = fullLines;
                int initial$iv = 0;
                boolean $i$f$fold = false;
                int accumulator$iv = initial$iv;
                for (Object element$iv : $this$fold$iv) {
                    void line;
                    String string2 = (String)element$iv;
                    int acc = accumulator$iv;
                    boolean bl4 = false;
                    accumulator$iv = acc + line.length();
                }
                int cursorOffset = accumulator$iv + fullLines.size() + promptInfo.getCursorX();
                TextWithHighlightings leftPart = this.subtext(promptInfo.getContent(), 0, cursorOffset);
                TextWithHighlightings rightPart = this.trimStart(this.subtext(promptInfo.getContent(), cursorOffset, promptInfo.getContent().getText().length()));
                pair = TuplesKt.to((Object)leftPart, (Object)rightPart);
            } else {
                pair = TuplesKt.to((Object)promptInfo.getContent(), (Object)new TextWithHighlightings("", CollectionsKt.emptyList()));
            }
        }
        Pair pair2 = pair;
        TextWithHighlightings prompt = (TextWithHighlightings)pair2.component1();
        TextWithHighlightings rightPrompt = (TextWithHighlightings)pair2.component2();
        return new TerminalPromptRenderingInfo(prompt.getText(), prompt.getHighlightings(), rightPrompt.getText(), rightPrompt.getHighlightings());
    }

    private final ExpandedPromptInfo expandPrompt(String escapedPrompt) {
        StyleState styleState = new StyleState();
        TextStyle defaultStyle = new TextStyle(new TerminalColor(() -> ShellPromptRenderer.expandPrompt$lambda$0(this)), new TerminalColor(() -> ShellPromptRenderer.expandPrompt$lambda$1(this)));
        styleState.setDefaultStyle(defaultStyle);
        TermSize terminalSize = (TermSize)this.terminalSizeProvider.invoke();
        TerminalTextBuffer textBuffer = new TerminalTextBuffer(terminalSize.getColumns(), terminalSize.getRows(), styleState, 0);
        JediTerminal terminal = new JediTerminal((TerminalDisplay)new FakeDisplay(this.settings), textBuffer, styleState);
        terminal.setModeEnabled(TerminalMode.AutoNewLine, true);
        char[] cArray = escapedPrompt.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        ArrayTerminalDataStream dataStream = new ArrayTerminalDataStream(cArray);
        JediEmulator emulator = new JediEmulator((TerminalDataStream)dataStream, (Terminal)terminal);
        while (emulator.hasNext()) {
            emulator.next();
        }
        StyledCommandOutput output = ShellCommandOutputScraperImpl.Companion.scrapeOutput$default(ShellCommandOutputScraperImpl.Companion, textBuffer, 0, 2, null);
        List<HighlightingInfo> highlightings = this.toHighlightings(output.getStyleRanges(), output.getText().length());
        LogicalPosition logicalPosition = this.cursorToLogicalPosition(textBuffer.getScreenBuffer(), terminal.getCursorX() - 1, terminal.getCursorY() - 1);
        return new ExpandedPromptInfo(new TextWithHighlightings(output.getText(), highlightings), logicalPosition.column, logicalPosition.line);
    }

    private final List<HighlightingInfo> toHighlightings(List<StyleRange> $this$toHighlightings, int totalTextLength) {
        List highlightings = new ArrayList();
        int curOffset = 0;
        for (StyleRange range : $this$toHighlightings) {
            if ((long)curOffset < range.getStartOffset()) {
                highlightings.add(new HighlightingInfo(curOffset, (int)range.getStartOffset(), EmptyTextAttributesProvider.INSTANCE));
            }
            highlightings.add(new HighlightingInfo((int)range.getStartOffset(), (int)range.getEndOffset(), new TextStyleAdapter(range.getStyle(), this.colorPalette, false, 4, null)));
            curOffset = (int)range.getEndOffset();
        }
        if (curOffset < totalTextLength) {
            highlightings.add(new HighlightingInfo(curOffset, totalTextLength, EmptyTextAttributesProvider.INSTANCE));
        }
        return highlightings;
    }

    /*
     * WARNING - void declaration
     */
    private final LogicalPosition cursorToLogicalPosition(LinesBuffer $this$cursorToLogicalPosition, int cursorX, int cursorY) {
        boolean bl;
        boolean bl2 = bl = cursorX >= 0 && cursorY >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        int logicalLine = 0;
        for (int curY = 0; curY < cursorY; ++curY) {
            if ($this$cursorToLogicalPosition.getLine(curY).isWrapped()) continue;
            ++logicalLine;
        }
        List wrappedLines = new ArrayList();
        for (int curY = cursorY - 1; curY >= 0 && $this$cursorToLogicalPosition.getLine(curY).isWrapped(); --curY) {
            TerminalLine terminalLine = $this$cursorToLogicalPosition.getLine(curY);
            Intrinsics.checkNotNullExpressionValue((Object)terminalLine, (String)"getLine(...)");
            wrappedLines.add(terminalLine);
        }
        Iterable iterable = wrappedLines;
        int n = 0;
        for (Object t : iterable) {
            void line;
            TerminalLine terminalLine = (TerminalLine)t;
            int n2 = n;
            boolean bl3 = false;
            List list = line.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntries(...)");
            Iterable iterable2 = list;
            int n3 = 0;
            for (Object t2 : iterable2) {
                void it;
                TerminalLine.TextEntry textEntry = (TerminalLine.TextEntry)t2;
                int n4 = n3;
                boolean bl4 = false;
                CharBuffer charBuffer = it.getText();
                Intrinsics.checkNotNullExpressionValue((Object)charBuffer, (String)"getText(...)");
                int n5 = TerminalUiUtilsKt.normalize(charBuffer).length();
                n3 = n4 + n5;
            }
            int n6 = n3;
            n = n2 + n6;
        }
        int wrappedLinesLength = n;
        int logicalColumn = wrappedLinesLength + cursorX;
        return new LogicalPosition(logicalLine, logicalColumn);
    }

    private final TextWithHighlightings subtext(TextWithHighlightings $this$subtext, int startOffset, int endOffset) {
        List list;
        boolean $this$indexOfFirst$iv32;
        int n;
        int startHighlightingIndex;
        block10: {
            int n2;
            block9: {
                boolean bl;
                boolean bl2 = bl = (0 <= startOffset ? startOffset <= endOffset : false) && endOffset <= $this$subtext.getText().length();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                if (startOffset == endOffset) {
                    return new TextWithHighlightings("", CollectionsKt.emptyList());
                }
                List<HighlightingInfo> $this$indexOfFirst$iv2 = $this$subtext.getHighlightings();
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<HighlightingInfo> iterator = $this$indexOfFirst$iv2.iterator();
                while (iterator.hasNext()) {
                    HighlightingInfo highlightingInfo;
                    HighlightingInfo it = highlightingInfo = iterator.next();
                    boolean bl3 = false;
                    int n3 = it.getStartOffset();
                    boolean bl4 = startOffset < it.getEndOffset() ? n3 <= startOffset : false;
                    if (bl4) {
                        n2 = index$iv;
                        break block9;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            startHighlightingIndex = n2;
            List<HighlightingInfo> $this$indexOfFirst$iv32 = $this$subtext.getHighlightings();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<HighlightingInfo> iterator = $this$indexOfFirst$iv32.iterator();
            while (iterator.hasNext()) {
                HighlightingInfo item$iv3;
                HighlightingInfo it = item$iv3 = iterator.next();
                boolean bl = false;
                int n4 = it.getStartOffset();
                int n5 = it.getEndOffset();
                int n6 = endOffset - 1;
                boolean bl5 = n4 <= n6 ? n6 < n5 : false;
                if (bl5) {
                    n = index$iv;
                    break block10;
                }
                ++index$iv;
            }
            n = -1;
        }
        int endHighlightingIndex = n;
        boolean bl = $this$indexOfFirst$iv32 = startHighlightingIndex >= 0 && endHighlightingIndex >= 0;
        if (_Assertions.ENABLED && !$this$indexOfFirst$iv32) {
            String $i$f$indexOfFirst = "Assertion failed";
            throw new AssertionError((Object)$i$f$indexOfFirst);
        }
        HighlightingInfo startHighlighting = $this$subtext.getHighlightings().get(startHighlightingIndex);
        HighlightingInfo endHighlighting = $this$subtext.getHighlightings().get(endHighlightingIndex);
        if (startHighlightingIndex != endHighlightingIndex) {
            List list2;
            List $this$subtext_u24lambda_u242 = list2 = CollectionsKt.createListBuilder();
            boolean bl6 = false;
            $this$subtext_u24lambda_u242.add(new HighlightingInfo(startOffset, startHighlighting.getEndOffset(), startHighlighting.getTextAttributesProvider()));
            $this$subtext_u24lambda_u242.addAll((Collection)$this$subtext.getHighlightings().subList(startHighlightingIndex + 1, endHighlightingIndex));
            $this$subtext_u24lambda_u242.add(new HighlightingInfo(endHighlighting.getStartOffset(), endOffset, endHighlighting.getTextAttributesProvider()));
            list = CollectionsKt.build((List)list2);
        } else {
            list = CollectionsKt.listOf((Object)new HighlightingInfo(startOffset, endOffset, startHighlighting.getTextAttributesProvider()));
        }
        List newHighlightings = list;
        List<HighlightingInfo> list3 = TerminalTextHighlighterKt.rebase(newHighlightings, -((HighlightingInfo)CollectionsKt.first((List)newHighlightings)).getStartOffset());
        String string = $this$subtext.getText().substring(startOffset, endOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return new TextWithHighlightings(string, list3);
    }

    private final TextWithHighlightings trimStart(TextWithHighlightings $this$trimStart) {
        if (((CharSequence)$this$trimStart.getText()).length() == 0) {
            return $this$trimStart;
        }
        Iterable $this$dropWhile$iv = $this$trimStart.getHighlightings();
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$dropWhile$iv) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            HighlightingInfo it = (HighlightingInfo)item$iv;
            boolean bl = false;
            String string = $this$trimStart.getText().substring(it.getStartOffset(), it.getEndOffset());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            if (StringsKt.isBlank((CharSequence)string) && it.getTextAttributesProvider() == EmptyTextAttributesProvider.INSTANCE) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        List newHighlightings = list$iv;
        if (newHighlightings.isEmpty()) {
            return new TextWithHighlightings("", CollectionsKt.emptyList());
        }
        int startOffset = ((HighlightingInfo)CollectionsKt.first((List)newHighlightings)).getStartOffset();
        List<HighlightingInfo> adjustedHighlightings = TerminalTextHighlighterKt.rebase(newHighlightings, -startOffset);
        String string = $this$trimStart.getText().substring(startOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return new TextWithHighlightings(string, adjustedHighlightings);
    }

    private static final Color expandPrompt$lambda$0(ShellPromptRenderer this$0) {
        return this$0.colorPalette.getDefaultForeground();
    }

    private static final Color expandPrompt$lambda$1(ShellPromptRenderer this$0) {
        return this$0.colorPalette.getDefaultBackground();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ShellPromptRenderer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/renderer/ShellPromptRenderer$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.terminal"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0005H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u0017H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/renderer/ShellPromptRenderer$ExpandedPromptInfo;", "", "content", "Lorg/jetbrains/plugins/terminal/block/output/TextWithHighlightings;", "cursorX", "", "cursorY", "<init>", "(Lorg/jetbrains/plugins/terminal/block/output/TextWithHighlightings;II)V", "getContent", "()Lorg/jetbrains/plugins/terminal/block/output/TextWithHighlightings;", "getCursorX", "()I", "getCursorY", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.terminal"})
    private static final class ExpandedPromptInfo {
        @NotNull
        private final TextWithHighlightings content;
        private final int cursorX;
        private final int cursorY;

        public ExpandedPromptInfo(@NotNull TextWithHighlightings content, int cursorX, int cursorY) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
            this.cursorX = cursorX;
            this.cursorY = cursorY;
        }

        @NotNull
        public final TextWithHighlightings getContent() {
            return this.content;
        }

        public final int getCursorX() {
            return this.cursorX;
        }

        public final int getCursorY() {
            return this.cursorY;
        }

        @NotNull
        public final TextWithHighlightings component1() {
            return this.content;
        }

        public final int component2() {
            return this.cursorX;
        }

        public final int component3() {
            return this.cursorY;
        }

        @NotNull
        public final ExpandedPromptInfo copy(@NotNull TextWithHighlightings content, int cursorX, int cursorY) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return new ExpandedPromptInfo(content, cursorX, cursorY);
        }

        public static /* synthetic */ ExpandedPromptInfo copy$default(ExpandedPromptInfo expandedPromptInfo, TextWithHighlightings textWithHighlightings, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                textWithHighlightings = expandedPromptInfo.content;
            }
            if ((n3 & 2) != 0) {
                n = expandedPromptInfo.cursorX;
            }
            if ((n3 & 4) != 0) {
                n2 = expandedPromptInfo.cursorY;
            }
            return expandedPromptInfo.copy(textWithHighlightings, n, n2);
        }

        @NotNull
        public String toString() {
            return "ExpandedPromptInfo(content=" + this.content + ", cursorX=" + this.cursorX + ", cursorY=" + this.cursorY + ")";
        }

        public int hashCode() {
            int result2 = this.content.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.cursorX);
            result2 = result2 * 31 + Integer.hashCode(this.cursorY);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExpandedPromptInfo)) {
                return false;
            }
            ExpandedPromptInfo expandedPromptInfo = (ExpandedPromptInfo)other;
            if (!Intrinsics.areEqual((Object)this.content, (Object)expandedPromptInfo.content)) {
                return false;
            }
            if (this.cursorX != expandedPromptInfo.cursorX) {
                return false;
            }
            return this.cursorY == expandedPromptInfo.cursorY;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/plugins/terminal/block/prompt/renderer/ShellPromptRenderer$FakeDisplay;", "Lcom/jediterm/terminal/TerminalDisplay;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "<init>", "(Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;)V", "setCursor", "", "x", "", "y", "setCursorShape", "cursorShape", "Lcom/jediterm/terminal/CursorShape;", "beep", "scrollArea", "scrollRegionTop", "scrollRegionSize", "dy", "setCursorVisible", "isCursorVisible", "", "useAlternateScreenBuffer", "getWindowTitle", "", "setWindowTitle", "windowTitle", "getSelection", "Lcom/jediterm/terminal/model/TerminalSelection;", "terminalMouseModeSet", "mouseMode", "Lcom/jediterm/terminal/emulator/mouse/MouseMode;", "setMouseFormat", "mouseFormat", "Lcom/jediterm/terminal/emulator/mouse/MouseFormat;", "ambiguousCharsAreDoubleWidth", "intellij.terminal"})
    private static final class FakeDisplay
    implements TerminalDisplay {
        @NotNull
        private final JBTerminalSystemSettingsProviderBase settings;

        public FakeDisplay(@NotNull JBTerminalSystemSettingsProviderBase settings) {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            this.settings = settings;
        }

        public void setCursor(int x, int y) {
        }

        public void setCursorShape(@Nullable CursorShape cursorShape) {
        }

        public void beep() {
        }

        public void scrollArea(int scrollRegionTop, int scrollRegionSize, int dy) {
        }

        public void setCursorVisible(boolean isCursorVisible) {
        }

        public void useAlternateScreenBuffer(boolean useAlternateScreenBuffer) {
        }

        @NotNull
        public String getWindowTitle() {
            return "";
        }

        public void setWindowTitle(@NotNull String windowTitle) {
            Intrinsics.checkNotNullParameter((Object)windowTitle, (String)"windowTitle");
        }

        @Nullable
        public TerminalSelection getSelection() {
            return null;
        }

        public void terminalMouseModeSet(@NotNull MouseMode mouseMode) {
            Intrinsics.checkNotNullParameter((Object)mouseMode, (String)"mouseMode");
        }

        public void setMouseFormat(@NotNull MouseFormat mouseFormat) {
            Intrinsics.checkNotNullParameter((Object)mouseFormat, (String)"mouseFormat");
        }

        public boolean ambiguousCharsAreDoubleWidth() {
            return this.settings.ambiguousCharsAreDoubleWidth();
        }
    }
}

