/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.runner;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.starter.TerminalLocalPathTranslator;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013J2\u0010\u0014\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u001a\u0010\f\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator;", "", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "envs", "", "", "customizerClass", "Ljava/lang/Class;", "Lorg/jetbrains/plugins/terminal/LocalTerminalCustomizer;", "<init>", "(Lcom/intellij/platform/eel/EelDescriptor;Ljava/util/Map;Ljava/lang/Class;)V", "translator", "Lorg/jetbrains/plugins/terminal/starter/TerminalLocalPathTranslator;", "multiPathEnvs", "", "Lorg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator$PathLikeEnv;", "singlePathEnvs", "translate", "", "translateEnvs", "pathLikeEnvs", "Lkotlin/Function2;", "PathLikeEnv", "Companion", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalCustomizerLocalPathTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCustomizerLocalPathTranslator.kt\norg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,88:1\n60#2,5:89\n13#2:94\n*S KotlinDebug\n*F\n+ 1 TerminalCustomizerLocalPathTranslator.kt\norg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator\n*L\n62#1:89,5\n74#1:94\n*E\n"})
public final class TerminalCustomizerLocalPathTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EelDescriptor descriptor;
    @NotNull
    private final Map<String, String> envs;
    @NotNull
    private final Class<? extends LocalTerminalCustomizer> customizerClass;
    @NotNull
    private final TerminalLocalPathTranslator translator;
    @NotNull
    private final List<PathLikeEnv> multiPathEnvs;
    @NotNull
    private final List<PathLikeEnv> singlePathEnvs;
    @NotNull
    private static final Logger LOG;

    public TerminalCustomizerLocalPathTranslator(@NotNull EelDescriptor descriptor, @NotNull Map<String, String> envs, @NotNull Class<? extends LocalTerminalCustomizer> customizerClass) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Intrinsics.checkNotNullParameter(customizerClass, (String)"customizerClass");
        this.descriptor = descriptor;
        this.envs = envs;
        this.customizerClass = customizerClass;
        this.translator = new TerminalLocalPathTranslator(this.descriptor);
        this.multiPathEnvs = TerminalCustomizerLocalPathTranslator.Companion.capturePathEnvs(TerminalLocalPathTranslator.Companion.getMULTI_PATH_ENV_NAMES$intellij_terminal(), this.envs, this.descriptor);
        this.singlePathEnvs = TerminalCustomizerLocalPathTranslator.Companion.capturePathEnvs(TerminalLocalPathTranslator.Companion.getSINGLE_PATH_ENV_NAMES$intellij_terminal(), this.envs, this.descriptor);
    }

    public final void translate() {
        this.translateEnvs(this.multiPathEnvs, (Function2<? super PathLikeEnv, ? super String, String>)((Function2)(arg_0, arg_1) -> TerminalCustomizerLocalPathTranslator.translate$lambda$0(this, arg_0, arg_1)));
        this.translateEnvs(this.singlePathEnvs, (Function2<? super PathLikeEnv, ? super String, String>)((Function2)(arg_0, arg_1) -> TerminalCustomizerLocalPathTranslator.translate$lambda$1(this, arg_0, arg_1)));
    }

    private final void translateEnvs(List<PathLikeEnv> pathLikeEnvs, Function2<? super PathLikeEnv, ? super String, String> translator) {
        for (PathLikeEnv pathLikeEnv : pathLikeEnvs) {
            String translatedValue;
            String newValue = this.envs.get(pathLikeEnv.getName());
            if (newValue == null || Intrinsics.areEqual((Object)newValue, (Object)pathLikeEnv.getPrevValue()) || (translatedValue = (String)translator.invoke((Object)pathLikeEnv, (Object)newValue)) == null) continue;
            Logger $this$debug_u24default$iv = LOG;
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Translated " + pathLikeEnv.getName() + " for " + this.customizerClass.getName() + ": " + pathLikeEnv.getPrevValue() + " -> " + newValue + " -> " + translatedValue, t$iv);
            }
            this.envs.put(pathLikeEnv.getName(), translatedValue);
        }
    }

    private static final String translate$lambda$0(TerminalCustomizerLocalPathTranslator this$0, PathLikeEnv pathLikeEnv, String newValue) {
        Intrinsics.checkNotNullParameter((Object)pathLikeEnv, (String)"pathLikeEnv");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        return this$0.translator.translateMultiPathEnv(pathLikeEnv.getName(), pathLikeEnv.getPrevValue(), newValue, this$0.customizerClass);
    }

    private static final String translate$lambda$1(TerminalCustomizerLocalPathTranslator this$0, PathLikeEnv pathLikeEnv, String newValue) {
        Intrinsics.checkNotNullParameter((Object)pathLikeEnv, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
        return this$0.translator.translateAbsoluteLocalPathStringToRemote(newValue);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TerminalCustomizerLocalPathTranslator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "capturePathEnvs", "", "Lorg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator$PathLikeEnv;", "envNamesToCapture", "", "", "envs", "", "descriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "intellij.terminal"})
    @SourceDebugExtension(value={"SMAP\nTerminalCustomizerLocalPathTranslator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCustomizerLocalPathTranslator.kt\norg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1586#2:89\n1661#2,3:90\n*S KotlinDebug\n*F\n+ 1 TerminalCustomizerLocalPathTranslator.kt\norg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator$Companion\n*L\n82#1:89\n82#1:90,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<PathLikeEnv> capturePathEnvs(Set<String> envNamesToCapture, Map<String, String> envs, EelDescriptor descriptor) {
            List list;
            if (Intrinsics.areEqual((Object)descriptor, (Object)LocalEelDescriptor.INSTANCE)) {
                list = CollectionsKt.emptyList();
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = envNamesToCapture;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string2 = envs.get(it);
                    if (string2 == null) {
                        string2 = "";
                    }
                    collection.add(new PathLikeEnv((String)it, string2));
                }
                list = (List)destination$iv$iv;
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u00d6\u0081\u0004J\n\u0010\u0012\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/runner/TerminalCustomizerLocalPathTranslator$PathLikeEnv;", "", "name", "", "prevValue", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPrevValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.terminal"})
    private static final class PathLikeEnv {
        @NotNull
        private final String name;
        @NotNull
        private final String prevValue;

        public PathLikeEnv(@NotNull String name, @NotNull String prevValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)prevValue, (String)"prevValue");
            this.name = name;
            this.prevValue = prevValue;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getPrevValue() {
            return this.prevValue;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.prevValue;
        }

        @NotNull
        public final PathLikeEnv copy(@NotNull String name, @NotNull String prevValue) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)prevValue, (String)"prevValue");
            return new PathLikeEnv(name, prevValue);
        }

        public static /* synthetic */ PathLikeEnv copy$default(PathLikeEnv pathLikeEnv, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = pathLikeEnv.name;
            }
            if ((n & 2) != 0) {
                string2 = pathLikeEnv.prevValue;
            }
            return pathLikeEnv.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "PathLikeEnv(name=" + this.name + ", prevValue=" + this.prevValue + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.prevValue.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathLikeEnv)) {
                return false;
            }
            PathLikeEnv pathLikeEnv = (PathLikeEnv)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)pathLikeEnv.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.prevValue, (Object)pathLikeEnv.prevValue);
        }
    }
}

