/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.starter;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.starter.ShellCustomizer;
import org.jetbrains.plugins.terminal.starter.ShellExecCommand;
import org.jetbrains.plugins.terminal.starter.ShellExecOptions;
import org.jetbrains.plugins.terminal.starter.ShellExecOptionsImplKt;
import org.jetbrains.plugins.terminal.starter.TerminalLocalPathTranslator;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t\u0012\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\nH\u0016J\u001a\u0010#\u001a\u00020!2\u0006\u0010\"\u001a\u00020\n2\b\u0010$\u001a\u0004\u0018\u00010%H\u0016J\u0010\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020%H\u0016J\u0010\u0010(\u001a\u00020!2\u0006\u0010'\u001a\u00020%H\u0016J\u0018\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020%H\u0016J\u0018\u0010,\u001a\u00020!2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020%H\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010\n2\u0006\u0010$\u001a\u00020%H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR \u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006."}, d2={"Lorg/jetbrains/plugins/terminal/starter/ShellExecOptionsImpl;", "Lorg/jetbrains/plugins/terminal/starter/ShellExecOptions;", "eelDescriptor", "Lcom/intellij/platform/eel/EelDescriptor;", "workingDirectory", "Lcom/intellij/platform/eel/path/EelPath;", "initialExecCommand", "Lorg/jetbrains/plugins/terminal/starter/ShellExecCommand;", "mutableEnvs", "", "", "requester", "Ljava/lang/Class;", "Lorg/jetbrains/plugins/terminal/starter/ShellCustomizer;", "<init>", "(Lcom/intellij/platform/eel/EelDescriptor;Lcom/intellij/platform/eel/path/EelPath;Lorg/jetbrains/plugins/terminal/starter/ShellExecCommand;Ljava/util/Map;Ljava/lang/Class;)V", "getEelDescriptor", "()Lcom/intellij/platform/eel/EelDescriptor;", "getWorkingDirectory", "()Lcom/intellij/platform/eel/path/EelPath;", "translator", "Lorg/jetbrains/plugins/terminal/starter/TerminalLocalPathTranslator;", "value", "execCommand", "getExecCommand", "()Lorg/jetbrains/plugins/terminal/starter/ShellExecCommand;", "setExecCommand", "(Lorg/jetbrains/plugins/terminal/starter/ShellExecCommand;)V", "envs", "", "getEnvs", "()Ljava/util/Map;", "setEnvironmentVariable", "", "name", "setEnvironmentVariableToPath", "path", "Ljava/nio/file/Path;", "prependEntryToPATH", "pathEntry", "appendEntryToPATH", "prependEntryToPathLikeEnv", "envName", "entryPath", "appendEntryToPathLikeEnv", "translatePathToRemote", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nShellExecOptionsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellExecOptionsImpl.kt\norg/jetbrains/plugins/terminal/starter/ShellExecOptionsImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,100:1\n60#2,5:101\n60#2,5:106\n60#2,5:111\n60#2,5:116\n60#2,5:121\n60#2,5:126\n60#2,5:131\n60#2,5:136\n60#2,5:141\n60#2,5:146\n*S KotlinDebug\n*F\n+ 1 ShellExecOptionsImpl.kt\norg/jetbrains/plugins/terminal/starter/ShellExecOptionsImpl\n*L\n34#1:101,5\n39#1:106,5\n46#1:111,5\n52#1:116,5\n55#1:121,5\n70#1:126,5\n74#1:131,5\n79#1:136,5\n83#1:141,5\n88#1:146,5\n*E\n"})
public final class ShellExecOptionsImpl
implements ShellExecOptions {
    @NotNull
    private final EelDescriptor eelDescriptor;
    @NotNull
    private final EelPath workingDirectory;
    @NotNull
    private final Map<String, String> mutableEnvs;
    @NotNull
    private final Class<? extends ShellCustomizer> requester;
    @NotNull
    private final TerminalLocalPathTranslator translator;
    @NotNull
    private ShellExecCommand execCommand;
    @NotNull
    private final Map<String, String> envs;

    public ShellExecOptionsImpl(@NotNull EelDescriptor eelDescriptor, @NotNull EelPath workingDirectory, @NotNull ShellExecCommand initialExecCommand, @NotNull Map<String, String> mutableEnvs, @NotNull Class<? extends ShellCustomizer> requester) {
        Intrinsics.checkNotNullParameter((Object)eelDescriptor, (String)"eelDescriptor");
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkNotNullParameter((Object)initialExecCommand, (String)"initialExecCommand");
        Intrinsics.checkNotNullParameter(mutableEnvs, (String)"mutableEnvs");
        Intrinsics.checkNotNullParameter(requester, (String)"requester");
        this.eelDescriptor = eelDescriptor;
        this.workingDirectory = workingDirectory;
        this.mutableEnvs = mutableEnvs;
        this.requester = requester;
        this.translator = new TerminalLocalPathTranslator(this.getEelDescriptor());
        this.execCommand = initialExecCommand;
        Map<String, String> map2 = Collections.unmodifiableMap(this.mutableEnvs);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
        this.envs = map2;
    }

    @Override
    @NotNull
    public EelDescriptor getEelDescriptor() {
        return this.eelDescriptor;
    }

    @Override
    @NotNull
    public EelPath getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    @NotNull
    public ShellExecCommand getExecCommand() {
        return this.execCommand;
    }

    @Override
    public void setExecCommand(@NotNull ShellExecCommand value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ShellExecOptionsImplKt.access$getLOG$p().info(this.requester + " changed shell command from " + this.execCommand + " to " + value);
        this.execCommand = value;
    }

    @Override
    @NotNull
    public Map<String, String> getEnvs() {
        return this.envs;
    }

    @Override
    public void setEnvironmentVariable(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            this.mutableEnvs.remove(name);
            Logger $this$debug_u24default$iv = ShellExecOptionsImplKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug(this.requester + " removed environment variable '" + name + "'", t$iv);
            }
        } else {
            String translatedValue = this.translator.translateEnvValue(name, this.getEnvs().get(name), value, this.requester);
            this.mutableEnvs.put(name, translatedValue);
            Logger $this$debug_u24default$iv = ShellExecOptionsImplKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug(this.requester + ": setEnvironmentVariable('" + name + "', '" + translatedValue + "')", t$iv);
            }
        }
    }

    @Override
    public void setEnvironmentVariableToPath(@NotNull String name, @Nullable Path path) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (path == null) {
            this.mutableEnvs.remove(name);
            Logger $this$debug_u24default$iv = ShellExecOptionsImplKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug(this.requester + " removed environment variable '" + name + "'", t$iv);
            }
        } else {
            String translatedPath = this.translatePathToRemote(path);
            if (translatedPath != null) {
                this.mutableEnvs.put(name, translatedPath);
                Logger $this$debug_u24default$iv = ShellExecOptionsImplKt.access$getLOG$p();
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug(this.requester + ": setEnvironmentVariableToPath('" + name + "', '" + translatedPath + "')", t$iv);
                }
            } else {
                Logger $this$debug_u24default$iv = ShellExecOptionsImplKt.access$getLOG$p();
                Throwable t$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    Logger logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug(this.requester + ": setEnvironmentVariableToPath('" + name + "', '" + path + "') failed, skipping", t$iv);
                }
            }
        }
    }

    @Override
    public void prependEntryToPATH(@NotNull Path pathEntry) {
        Intrinsics.checkNotNullParameter((Object)pathEntry, (String)"pathEntry");
        this.prependEntryToPathLikeEnv("PATH", pathEntry);
    }

    @Override
    public void appendEntryToPATH(@NotNull Path pathEntry) {
        Intrinsics.checkNotNullParameter((Object)pathEntry, (String)"pathEntry");
        this.appendEntryToPathLikeEnv("PATH", pathEntry);
    }

    @Override
    public void prependEntryToPathLikeEnv(@NotNull String envName, @NotNull Path entryPath) {
        Intrinsics.checkNotNullParameter((Object)envName, (String)"envName");
        Intrinsics.checkNotNullParameter((Object)entryPath, (String)"entryPath");
        String string = this.translatePathToRemote(entryPath);
        if (string == null) {
            ShellExecOptionsImpl $this$prependEntryToPathLikeEnv_u24lambda_u240 = this;
            boolean bl = false;
            Logger $this$debug_u24default$iv = ShellExecOptionsImplKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug($this$prependEntryToPathLikeEnv_u24lambda_u240.requester + ": prependEntryToPathLikeEnv('" + envName + "', '" + entryPath + "') failed, skipping", t$iv);
            }
            return;
        }
        String remotePath = string;
        String string2 = this.getEnvs().get(envName);
        if (string2 == null) {
            string2 = "";
        }
        this.mutableEnvs.put(envName, this.translator.joinEntries$intellij_terminal(remotePath, string2));
        Logger $this$debug_u24default$iv = ShellExecOptionsImplKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(this.requester + ": prependEntryToPathLikeEnv('" + envName + "', '" + remotePath + "')", t$iv);
        }
    }

    @Override
    public void appendEntryToPathLikeEnv(@NotNull String envName, @NotNull Path entryPath) {
        Intrinsics.checkNotNullParameter((Object)envName, (String)"envName");
        Intrinsics.checkNotNullParameter((Object)entryPath, (String)"entryPath");
        String string = this.translatePathToRemote(entryPath);
        if (string == null) {
            ShellExecOptionsImpl $this$appendEntryToPathLikeEnv_u24lambda_u240 = this;
            boolean bl = false;
            Logger $this$debug_u24default$iv = ShellExecOptionsImplKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl2 = false;
                logger.debug($this$appendEntryToPathLikeEnv_u24lambda_u240.requester + ": appendEntryToPathLikeEnv('" + envName + "', '" + entryPath + "') failed, skipping", t$iv);
            }
            return;
        }
        String remotePath = string;
        String string2 = this.getEnvs().get(envName);
        if (string2 == null) {
            string2 = "";
        }
        this.mutableEnvs.put(envName, this.translator.joinEntries$intellij_terminal(string2, remotePath));
        Logger $this$debug_u24default$iv = ShellExecOptionsImplKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug(this.requester + ": appendEntryToPathLikeEnv('" + envName + "', '" + remotePath + "')", t$iv);
        }
    }

    private final String translatePathToRemote(Path path) {
        if (!path.isAbsolute()) {
            Logger $this$debug_u24default$iv = ShellExecOptionsImplKt.access$getLOG$p();
            Throwable t$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug(this.requester + ": Relative path '" + path + "' will be added as-is", t$iv);
            }
            return ((Object)path).toString();
        }
        if (Intrinsics.areEqual((Object)this.getEelDescriptor(), (Object)LocalEelDescriptor.INSTANCE)) {
            return ((Object)path).toString();
        }
        EelPath eelPath = this.translator.translateAbsoluteLocalPathToRemote(path);
        return eelPath != null ? eelPath.toString() : null;
    }
}

