/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jvm.advanced.java.instrumentation;

import com.intellij.debugger.engine.DebuggerAgentParametersModifier;
import com.intellij.debugger.engine.EvaluationUtilsKt;
import com.intellij.debugger.jvm.advanced.java.instrumentation.JvmBreakpointInstrumentationProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J2\u0010\n\u001a\u0004\u0018\u00010\u000b\"\u000e\b\u0000\u0010\f*\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010\b\u001a\u00020\t2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\f0\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/instrumentation/BreakpointInstrumentationAgentEnabler;", "Lcom/intellij/debugger/engine/DebuggerAgentParametersModifier;", "<init>", "()V", "modifyProperties", "", "properties", "Ljava/util/Properties;", "project", "Lcom/intellij/openapi/project/Project;", "getInstrumentationClassName", "", "T", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "xBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "intellij.debugger.jvm.advanced.java"})
@SourceDebugExtension(value={"SMAP\nBreakpointInstrumentationAgentEnabler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BreakpointInstrumentationAgentEnabler.kt\ncom/intellij/debugger/jvm/advanced/java/instrumentation/BreakpointInstrumentationAgentEnabler\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,60:1\n23#2:61\n*S KotlinDebug\n*F\n+ 1 BreakpointInstrumentationAgentEnabler.kt\ncom/intellij/debugger/jvm/advanced/java/instrumentation/BreakpointInstrumentationAgentEnabler\n*L\n54#1:61\n*E\n"})
public final class BreakpointInstrumentationAgentEnabler
implements DebuggerAgentParametersModifier {
    public void modifyProperties(@NotNull Properties properties, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        if (project == null) {
            return;
        }
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)project).getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointManager, (String)"getBreakpointManager(...)");
        XBreakpointManager breakpointManager = xBreakpointManager;
        int i = 0;
        XBreakpoint[] xBreakpointArray = breakpointManager.getAllBreakpoints();
        Intrinsics.checkNotNullExpressionValue((Object)xBreakpointArray, (String)"getAllBreakpoints(...)");
        for (XBreakpoint xBreakpoint : xBreakpointArray) {
            String className;
            if (!xBreakpoint.isEnabled() || !(xBreakpoint instanceof XBreakpointBase) || !EvaluationUtilsKt.shouldInstrumentBreakpoint((XBreakpointBase)((XBreakpointBase)xBreakpoint)) || (className = this.getInstrumentationClassName(project, xBreakpoint)) == null) continue;
            properties.setProperty("instrumentation.breakpoint.class" + i, StringsKt.replace$default((String)className, (String)".", (String)"/", (boolean)false, (int)4, null));
            ++i;
        }
    }

    private final <T extends XBreakpointProperties<?>> String getInstrumentationClassName(Project project, XBreakpoint<T> xBreakpoint) {
        try {
            return (String)ReadAction.nonBlocking(() -> BreakpointInstrumentationAgentEnabler.getInstrumentationClassName$lambda$0(project, xBreakpoint)).executeSynchronously();
        }
        catch (Throwable e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            BreakpointInstrumentationAgentEnabler $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BreakpointInstrumentationAgentEnabler.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot extract parameter information for instrumentation: " + xBreakpoint.getType(), e);
            return null;
        }
    }

    private static final String getInstrumentationClassName$lambda$0(Project $project, XBreakpoint $xBreakpoint) {
        return JvmBreakpointInstrumentationProvider.Companion.getInstrumentationClassNameIfPossible($project, $xBreakpoint);
    }
}

