/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jvm.advanced.java.instrumentation;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.jvm.advanced.java.instrumentation.BreakpointInstrumentationEngineKt;
import com.intellij.debugger.jvm.advanced.java.instrumentation.BreakpointInstrumentationOutcome;
import com.intellij.debugger.jvm.advanced.java.instrumentation.BreakpointInstrumentationStatisticsCollector;
import com.intellij.debugger.jvm.advanced.java.instrumentation.InstrumentationBreakpointStateImpl;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/instrumentation/DiagnosticRequestor;", "Lcom/intellij/debugger/ui/breakpoints/FilteredRequestor;", "<init>", "()V", "getSuspendPolicy", "", "processLocatableEvent", "", "action", "Lcom/intellij/debugger/engine/events/SuspendContextCommandImpl;", "event", "Lcom/sun/jdi/event/LocatableEvent;", "intellij.debugger.jvm.advanced.java"})
@SourceDebugExtension(value={"SMAP\nBreakpointInstrumentationEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BreakpointInstrumentationEngine.kt\ncom/intellij/debugger/jvm/advanced/java/instrumentation/DiagnosticRequestor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,532:1\n23#2:533\n*S KotlinDebug\n*F\n+ 1 BreakpointInstrumentationEngine.kt\ncom/intellij/debugger/jvm/advanced/java/instrumentation/DiagnosticRequestor\n*L\n205#1:533\n*E\n"})
final class DiagnosticRequestor
implements FilteredRequestor {
    @NotNull
    public static final DiagnosticRequestor INSTANCE = new DiagnosticRequestor();

    private DiagnosticRequestor() {
    }

    @NotNull
    public String getSuspendPolicy() {
        return "SuspendThread";
    }

    public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action, @Nullable LocatableEvent event) {
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        if (event == null) {
            return false;
        }
        List<Value> list = event.thread().frame(0).getArgumentValues();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getArgumentValues(...)");
        List<Value> argumentValues = list;
        Value messageValue = argumentValues.get(0);
        Value instrumentationIdValue = argumentValues.get(1);
        IntegerValue integerValue = instrumentationIdValue instanceof IntegerValue ? (IntegerValue)instrumentationIdValue : null;
        if (integerValue == null) {
            return false;
        }
        int id = integerValue.value();
        Object object = messageValue instanceof StringReference ? (StringReference)messageValue : null;
        if (object == null || (object = object.value()) == null) {
            object = "unknown error";
        }
        Object message = object;
        DiagnosticRequestor $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(DiagnosticRequestor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Impossible to instrument breakpoint with id " + id + ": " + (String)message);
        SuspendContextImpl suspendContextImpl = action.getSuspendContext();
        DebugProcessImpl debugProcess = suspendContextImpl != null ? suspendContextImpl.getDebugProcess() : null;
        Object object2 = (InstrumentationBreakpointStateImpl)BreakpointInstrumentationEngineKt.access$getInstrumentationMap$p().get(id);
        Language language = object2 != null && (object2 = ((InstrumentationBreakpointStateImpl)object2).getDiagnostic()) != null ? object2.getLanguage() : null;
        DebugProcessImpl debugProcessImpl = debugProcess;
        BreakpointInstrumentationStatisticsCollector.logInstrumentationOutcome((Project)(debugProcessImpl != null ? debugProcessImpl.getProject() : null), BreakpointInstrumentationOutcome.INSTRUMENTATION_IS_IMPOSSIBLE, language);
        return false;
    }
}

