/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend.frame;

import com.intellij.ide.ui.icons.IconId;
import com.intellij.ide.ui.icons.IconIdKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.frontend.frame.FrontendXStackFrame;
import com.intellij.platform.debugger.impl.frontend.storage.FrontendXStackFramesStorageKt;
import com.intellij.platform.debugger.impl.rpc.ComputeFramesConfig;
import com.intellij.platform.debugger.impl.rpc.XExecutionStackApi;
import com.intellij.platform.debugger.impl.rpc.XExecutionStackDto;
import com.intellij.platform.debugger.impl.rpc.XExecutionStackId;
import com.intellij.platform.debugger.impl.rpc.XStackFrameDto;
import com.intellij.platform.debugger.impl.rpc.XStackFramesEvent;
import com.intellij.xdebugger.frame.XDescriptor;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import fleet.util.logging.KLogger;
import fleet.util.logging.KLoggers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.future.FutureKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0096\u0082\u0004J\u0012\u0010\u001f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u000fH\u0016J\n\u0010!\u001a\u00020\u0016H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/frame/FrontendXExecutionStack;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "stackDto", "Lcom/intellij/platform/debugger/impl/rpc/XExecutionStackDto;", "project", "Lcom/intellij/openapi/project/Project;", "suspendContextLifetimeScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/platform/debugger/impl/rpc/XExecutionStackDto;Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "id", "Lcom/intellij/platform/debugger/impl/rpc/XExecutionStackId;", "getId", "()Lcom/intellij/platform/debugger/impl/rpc/XExecutionStackId;", "topValue", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "getTopFrame", "getTopFrameAsync", "computeStackFrames", "", "firstFrameIndex", "", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "createComputeFramesConfig", "Lcom/intellij/platform/debugger/impl/rpc/ComputeFramesConfig;", "equals", "", "other", "", "getXExecutionStackDescriptorAsync", "Lcom/intellij/xdebugger/frame/XDescriptor;", "hashCode", "Companion", "intellij.platform.debugger.impl.frontend"})
@SourceDebugExtension(value={"SMAP\nFrontendXExecutionStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendXExecutionStack.kt\ncom/intellij/platform/debugger/impl/frontend/frame/FrontendXExecutionStack\n+ 2 KLoggers.kt\nfleet/util/logging/KLoggersKt\n*L\n1#1,93:1\n18#2:94\n*S KotlinDebug\n*F\n+ 1 FrontendXExecutionStack.kt\ncom/intellij/platform/debugger/impl/frontend/frame/FrontendXExecutionStack\n*L\n90#1:94\n*E\n"})
public final class FrontendXExecutionStack
extends XExecutionStack {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final XExecutionStackDto stackDto;
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope suspendContextLifetimeScope;
    @NotNull
    private final XExecutionStackId id;
    @NotNull
    private final CompletableFuture<XStackFrame> topValue;
    @NotNull
    private static final KLogger logger;

    public FrontendXExecutionStack(@NotNull XExecutionStackDto stackDto, @NotNull Project project, @NotNull CoroutineScope suspendContextLifetimeScope) {
        Intrinsics.checkNotNullParameter((Object)stackDto, (String)"stackDto");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suspendContextLifetimeScope, (String)"suspendContextLifetimeScope");
        IconId iconId = stackDto.getIcon();
        super(stackDto.getDisplayName(), iconId != null ? IconIdKt.icon((IconId)iconId) : null);
        this.stackDto = stackDto;
        this.project = project;
        this.suspendContextLifetimeScope = suspendContextLifetimeScope;
        this.id = this.stackDto.getExecutionStackId();
        CompletionStage completionStage = ((CompletableFuture)FutureKt.asCompletableFuture((Deferred)this.stackDto.getTopFrame()).thenApply(arg_0 -> FrontendXExecutionStack.topValue$lambda$1(arg_0 -> FrontendXExecutionStack.topValue$lambda$0(this, arg_0), arg_0))).exceptionally(FrontendXExecutionStack::topValue$lambda$2);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"exceptionally(...)");
        this.topValue = completionStage;
    }

    @NotNull
    public final XExecutionStackId getId() {
        return this.id;
    }

    @Nullable
    public XStackFrame getTopFrame() {
        return this.topValue.getNow(null);
    }

    @NotNull
    public CompletableFuture<XStackFrame> getTopFrameAsync() {
        return this.topValue;
    }

    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        BuildersKt.launch$default((CoroutineScope)this.suspendContextLifetimeScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, firstFrameIndex, container, null){
            int label;
            final /* synthetic */ FrontendXExecutionStack this$0;
            final /* synthetic */ int $firstFrameIndex;
            final /* synthetic */ XExecutionStack.XStackFrameContainer $container;
            {
                this.this$0 = $receiver;
                this.$firstFrameIndex = $firstFrameIndex;
                this.$container = $container;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = XExecutionStackApi.Companion.getInstance((Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = ((XExecutionStackApi)v0).computeStackFrames(this.this$0.getId(), this.$firstFrameIndex, FrontendXExecutionStack.access$createComputeFramesConfig(this.this$0), (Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        this.label = 3;
                        v2 = ((Flow)v1).collect(new FlowCollector(this.$container, this.this$0){
                            final /* synthetic */ XExecutionStack.XStackFrameContainer $container;
                            final /* synthetic */ FrontendXExecutionStack this$0;
                            {
                                this.$container = $container;
                                this.this$0 = $receiver;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object emit(XStackFramesEvent event, Continuation<? super Unit> $completion) {
                                XStackFramesEvent xStackFramesEvent = event;
                                if (xStackFramesEvent instanceof XStackFramesEvent.ErrorOccurred) {
                                    this.$container.errorOccurred(((XStackFramesEvent.ErrorOccurred)event).getErrorMessage());
                                } else if (xStackFramesEvent instanceof XStackFramesEvent.XNewStackFrames) {
                                    void $this$mapTo$iv$iv;
                                    void $this$map$iv;
                                    Iterable iterable = ((XStackFramesEvent.XNewStackFrames)event).getFrames();
                                    FrontendXExecutionStack frontendXExecutionStack = this.this$0;
                                    boolean $i$f$map = false;
                                    void var8_7 = $this$map$iv;
                                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        void it;
                                        XStackFrameDto xStackFrameDto = (XStackFrameDto)item$iv$iv;
                                        Collection collection = destination$iv$iv;
                                        boolean bl = false;
                                        collection.add(FrontendXStackFramesStorageKt.getOrCreateStackFrame(FrontendXExecutionStack.access$getSuspendContextLifetimeScope$p(frontendXExecutionStack), (XStackFrameDto)it, FrontendXExecutionStack.access$getProject$p(frontendXExecutionStack)));
                                    }
                                    List feFrames = (List)destination$iv$iv;
                                    this.$container.addStackFrames(feFrames, ((XStackFramesEvent.XNewStackFrames)event).getLast());
                                } else if (xStackFramesEvent instanceof XStackFramesEvent.NewPresentation) {
                                    FrontendXStackFrame frame = FrontendXStackFramesStorageKt.findStackFrame(FrontendXExecutionStack.access$getSuspendContextLifetimeScope$p(this.this$0), ((XStackFramesEvent.NewPresentation)event).getStackFrameId());
                                    if (frame == null) {
                                        FrontendXExecutionStack.access$getLogger$cp().warn((Object)("Frame with id " + ((XStackFramesEvent.NewPresentation)event).getStackFrameId() + " not found. Probably presentation event was received earlier than stack frame"));
                                        return Unit.INSTANCE;
                                    }
                                    frame.newUiPresentation(((XStackFramesEvent.NewPresentation)event).getPresentation());
                                } else {
                                    throw new NoWhenBranchMatchedException();
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (v2 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl29
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl29:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final ComputeFramesConfig createComputeFramesConfig() {
        return new ComputeFramesConfig(XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames());
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FrontendXExecutionStack && Intrinsics.areEqual((Object)((FrontendXExecutionStack)((Object)other)).id, (Object)this.id);
    }

    @Nullable
    public CompletableFuture<XDescriptor> getXExecutionStackDescriptorAsync() {
        Deferred deferred2 = this.stackDto.getDescriptor();
        return deferred2 != null ? FutureKt.asCompletableFuture((Deferred)deferred2) : null;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    private static final XStackFrame topValue$lambda$0(FrontendXExecutionStack this$0, XStackFrameDto frameDto) {
        if (frameDto == null) {
            return null;
        }
        return FrontendXStackFramesStorageKt.getOrCreateStackFrame(this$0.suspendContextLifetimeScope, frameDto, this$0.project);
    }

    private static final XStackFrame topValue$lambda$1(Function1 $tmp0, Object p0) {
        return (XStackFrame)$tmp0.invoke(p0);
    }

    private static final XStackFrame topValue$lambda$2(Throwable it) {
        return null;
    }

    public static final /* synthetic */ ComputeFramesConfig access$createComputeFramesConfig(FrontendXExecutionStack $this) {
        return $this.createComputeFramesConfig();
    }

    public static final /* synthetic */ CoroutineScope access$getSuspendContextLifetimeScope$p(FrontendXExecutionStack $this) {
        return $this.suspendContextLifetimeScope;
    }

    public static final /* synthetic */ Project access$getProject$p(FrontendXExecutionStack $this) {
        return $this.project;
    }

    public static final /* synthetic */ KLogger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$logger = false;
        logger = KLoggers.INSTANCE.logger(Reflection.getOrCreateKotlinClass(FrontendXExecutionStack.class));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/frame/FrontendXExecutionStack$Companion;", "", "<init>", "()V", "logger", "Lfleet/util/logging/KLogger;", "intellij.platform.debugger.impl.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

