/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend.hotswap;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.frontend.hotswap.FrontendHotSwapManager;
import com.intellij.platform.debugger.impl.frontend.hotswap.HotSwapButtonStatus;
import com.intellij.platform.debugger.impl.frontend.hotswap.HotSwapFloatingToolbarProviderKt;
import com.intellij.platform.debugger.impl.frontend.hotswap.HotSwapToolbarComponent;
import com.intellij.platform.debugger.impl.rpc.HotSwapSource;
import com.intellij.platform.debugger.impl.rpc.XDebugHotSwapCurrentSessionStatus;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/hotswap/HotSwapWithRebuildAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "status", "Lcom/intellij/platform/debugger/impl/frontend/hotswap/HotSwapButtonStatus;", "getStatus", "()Lcom/intellij/platform/debugger/impl/frontend/hotswap/HotSwapButtonStatus;", "setStatus", "(Lcom/intellij/platform/debugger/impl/frontend/hotswap/HotSwapButtonStatus;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "update", "updateCustomComponent", "component", "intellij.platform.debugger.impl.frontend"})
public final class HotSwapWithRebuildAction
extends AnAction
implements CustomComponentAction,
DumbAware {
    @NotNull
    private HotSwapButtonStatus status = HotSwapButtonStatus.READY;

    @NotNull
    public final HotSwapButtonStatus getStatus() {
        return this.status;
    }

    public final void setStatus(@NotNull HotSwapButtonStatus hotSwapButtonStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)hotSwapButtonStatus), (String)"<set-?>");
        this.status = hotSwapButtonStatus;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        XDebugHotSwapCurrentSessionStatus xDebugHotSwapCurrentSessionStatus = HotSwapFloatingToolbarProviderKt.access$getCurrentStatus(project2);
        if (xDebugHotSwapCurrentSessionStatus == null) {
            return;
        }
        XDebugHotSwapCurrentSessionStatus status = xDebugHotSwapCurrentSessionStatus;
        FrontendHotSwapManager.Companion.getInstance(project2).performHotSwap(status.getSessionId(), HotSwapSource.RELOAD_MODIFIED_BUTTON);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return new HotSwapToolbarComponent(this, presentation, place);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        if (e.getPresentation().isEnabledAndVisible()) {
            HotSwapFloatingToolbarProviderKt.access$updateToolbarVisibility(project2);
        }
    }

    public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        ((HotSwapToolbarComponent)component).update(this.status, presentation);
    }
}

