/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.BadgeDotProvider;
import com.intellij.ui.BadgeShapeProvider;
import com.intellij.ui.icons.HoledIcon;
import com.intellij.ui.icons.IconReplacer;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\nJ\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0014J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0014J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ui/BadgeIcon;", "Lcom/intellij/ui/icons/HoledIcon;", "icon", "Ljavax/swing/Icon;", "paint", "Ljava/awt/Paint;", "provider", "Lcom/intellij/ui/BadgeShapeProvider;", "<init>", "(Ljavax/swing/Icon;Ljava/awt/Paint;Lcom/intellij/ui/BadgeShapeProvider;)V", "(Ljavax/swing/Icon;Ljava/awt/Paint;)V", "getPaint", "()Ljava/awt/Paint;", "getProvider", "()Lcom/intellij/ui/BadgeShapeProvider;", "copyWith", "createHole", "Ljava/awt/Shape;", "width", "", "height", "paintHole", "", "g", "Ljava/awt/Graphics2D;", "replaceBy", "replacer", "Lcom/intellij/ui/icons/IconReplacer;", "intellij.platform.core.ui"})
@ApiStatus.Internal
@ApiStatus.Experimental
public final class BadgeIcon
extends HoledIcon {
    @NotNull
    private final Paint paint;
    @NotNull
    private final BadgeShapeProvider provider;

    public BadgeIcon(@NotNull Icon icon, @NotNull Paint paint, @NotNull BadgeShapeProvider provider) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        super(icon);
        this.paint = paint;
        this.provider = provider;
    }

    @NotNull
    public final Paint getPaint() {
        return this.paint;
    }

    @NotNull
    public final BadgeShapeProvider getProvider() {
        return this.provider;
    }

    public BadgeIcon(@NotNull Icon icon, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        this(icon, paint, new BadgeDotProvider(0.0, 0.0, 0.0, 0.0, 15, null));
    }

    @NotNull
    protected BadgeIcon copyWith(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return new BadgeIcon(icon, this.paint, this.provider);
    }

    @Override
    @Nullable
    protected Shape createHole(int width, int height) {
        return this.provider.createShape(width, height, true);
    }

    @Override
    protected void paintHole(@NotNull Graphics2D g, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Shape shape = this.provider.createShape(width, height, false);
        if (shape == null) {
            return;
        }
        Shape shape2 = shape;
        g.setPaint(this.paint);
        g.fill(shape2);
    }

    @NotNull
    public BadgeIcon replaceBy(@NotNull IconReplacer replacer2) {
        Intrinsics.checkNotNullParameter((Object)replacer2, (String)"replacer");
        Icon icon = replacer2.replaceIcon(this.getIcon());
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"replaceIcon(...)");
        return new BadgeIcon(icon, this.paint, this.provider);
    }
}

