/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.NlsContexts;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

public final class RightAlignedLabelUI
extends BasicLabelUI {
    static final int LEADING = 10;
    static final int TRAILING = 11;
    static final int LEFT = 2;
    static final int RIGHT = 4;
    static final int TOP = 1;
    static final int CENTER = 0;

    @Override
    protected String layoutCL(JLabel label, FontMetrics fontMetrics, @NlsContexts.Label String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        String s = RightAlignedLabelUI.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
        if (s.isEmpty()) {
            return text;
        }
        return s;
    }

    private static String layoutCompoundLabel(JComponent c, FontMetrics fm, @NlsContexts.Label String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        int hAlign = switch (horizontalAlignment) {
            case 10 -> {
                if (orientationIsLeftToRight) {
                    yield 2;
                }
                yield 4;
            }
            case 11 -> {
                if (orientationIsLeftToRight) {
                    yield 4;
                }
                yield 2;
            }
            default -> horizontalAlignment;
        };
        int hTextPos = switch (horizontalTextPosition) {
            case 10 -> {
                if (orientationIsLeftToRight) {
                    yield 2;
                }
                yield 4;
            }
            case 11 -> {
                if (orientationIsLeftToRight) {
                    yield 4;
                }
                yield 2;
            }
            default -> horizontalTextPosition;
        };
        return RightAlignedLabelUI.layoutCompoundLabel(fm, text, icon, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    private static String layoutCompoundLabel(FontMetrics fm, @NlsContexts.Label String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int availTextWidth;
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.isEmpty();
        Object rettext = "";
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
        } else {
            Dimension dim = new Dimension(SwingUtilities.computeStringWidth(fm, text), fm.getHeight());
            textR.width = dim.width;
            textR.height = dim.height;
        }
        int n = gap = textIsEmpty || icon == null ? 0 : textIconGap;
        if (!textIsEmpty && textR.width > (availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap))) {
            String clipString = "...";
            int totalWidth = SwingUtilities.computeStringWidth(fm, clipString);
            rettext = "";
            for (int nChars = text.length() - 1; nChars >= 0 && (totalWidth += fm.charWidth(text.charAt(nChars))) <= availTextWidth; --nChars) {
                rettext = text.charAt(nChars) + (String)rettext;
            }
            rettext = clipString + (String)rettext;
            textR.width = SwingUtilities.computeStringWidth(fm, (String)rettext);
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        return rettext;
    }

    @Override
    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonic();
        g.setColor(l.getForeground());
        BasicGraphicsUtils.drawString(g, s, accChar, textX, textY);
    }

    @Override
    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        int accChar = l.getDisplayedMnemonic();
        g.setColor(l.getBackground());
        BasicGraphicsUtils.drawString(g, s, accChar, textX, textY);
    }
}

