/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u0002H\u0005\"\b\b\u0000\u0010\u0005*\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00050\bH\u0007\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/execution/configurations/ConfigurationTypeUtil;", "", "<init>", "()V", "findConfigurationType", "T", "Lcom/intellij/execution/configurations/ConfigurationType;", "configurationTypeClass", "Ljava/lang/Class;", "(Ljava/lang/Class;)Lcom/intellij/execution/configurations/ConfigurationType;", "configurationId", "", "isEditableInDumbMode", "", "runConfigurationType", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfiguration;", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "intellij.platform.execution"})
@SourceDebugExtension(value={"SMAP\nConfigurationTypeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfigurationTypeUtil.kt\ncom/intellij/execution/configurations/ConfigurationTypeUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,39:1\n296#2,2:40\n13225#3,2:42\n*S KotlinDebug\n*F\n+ 1 ConfigurationTypeUtil.kt\ncom/intellij/execution/configurations/ConfigurationTypeUtil\n*L\n25#1:40,2\n29#1:42,2\n*E\n"})
public final class ConfigurationTypeUtil {
    @NotNull
    public static final ConfigurationTypeUtil INSTANCE = new ConfigurationTypeUtil();

    private ConfigurationTypeUtil() {
    }

    @JvmStatic
    @NotNull
    public static final <T extends ConfigurationType> T findConfigurationType(@NotNull Class<T> configurationTypeClass) {
        Intrinsics.checkNotNullParameter(configurationTypeClass, (String)"configurationTypeClass");
        List types = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList();
        for (ConfigurationType type : types) {
            if (!configurationTypeClass.isInstance(type)) continue;
            Intrinsics.checkNotNull((Object)type, (String)"null cannot be cast to non-null type T of com.intellij.execution.configurations.ConfigurationTypeUtil.findConfigurationType");
            return (T)type;
        }
        throw new AssertionError((Object)(types + " loader: " + configurationTypeClass.getClassLoader() + ", " + configurationTypeClass));
    }

    @JvmStatic
    @Nullable
    public static final ConfigurationType findConfigurationType(@NotNull String configurationId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)configurationId, (String)"configurationId");
            Iterable $this$firstOrNull$iv = ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ConfigurationType it = (ConfigurationType)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)configurationId)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmStatic
    public static final boolean isEditableInDumbMode(@NotNull ConfigurationType runConfigurationType) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)runConfigurationType, (String)"runConfigurationType");
            ConfigurationFactory[] configurationFactoryArray = runConfigurationType.getConfigurationFactories();
            Intrinsics.checkNotNullExpressionValue((Object)configurationFactoryArray, (String)"getConfigurationFactories(...)");
            Object[] $this$any$iv = configurationFactoryArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ConfigurationFactory it = (ConfigurationFactory)element$iv;
                boolean bl2 = false;
                if (!it.isEditableInDumbMode()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final boolean isEditableInDumbMode(@NotNull RunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        ConfigurationFactory configurationFactory = runConfiguration.getFactory();
        return configurationFactory != null ? configurationFactory.isEditableInDumbMode() : false;
    }

    @JvmStatic
    public static final boolean isEditableInDumbMode(@NotNull RunnerAndConfigurationSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return settings.getFactory().isEditableInDumbMode();
    }
}

