/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ*\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/execution/runners/IndicatorIcon;", "Ljavax/swing/Icon;", "base", "emptyIconWidth", "", "emptyIconHeight", "color", "Ljava/awt/Color;", "<init>", "(Ljavax/swing/Icon;IILjava/awt/Color;)V", "getBase", "()Ljavax/swing/Icon;", "getEmptyIconWidth", "()I", "getEmptyIconHeight", "getColor", "()Ljava/awt/Color;", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "getIconWidth", "getIconHeight", "intellij.platform.execution"})
public final class IndicatorIcon
implements Icon {
    @Nullable
    private final Icon base;
    private final int emptyIconWidth;
    private final int emptyIconHeight;
    @NotNull
    private final Color color;

    public IndicatorIcon(@Nullable Icon base, int emptyIconWidth, int emptyIconHeight, @NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.base = base;
        this.emptyIconWidth = emptyIconWidth;
        this.emptyIconHeight = emptyIconHeight;
        this.color = color;
    }

    @Nullable
    public final Icon getBase() {
        return this.base;
    }

    public final int getEmptyIconWidth() {
        return this.emptyIconWidth;
    }

    public final int getEmptyIconHeight() {
        return this.emptyIconHeight;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintIcon(@Nullable Component c, @NotNull Graphics g, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        int iSize = JBUIScale.scale((int)4);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)graphics;
        try {
            GraphicsUtil.setupAAPainting((Graphics)g2d);
            g2d.setColor(this.color);
            Ellipse2D.Double shape = new Ellipse2D.Double(x + this.getIconWidth() - iSize, y + this.getIconHeight() - iSize, iSize, iSize);
            g2d.fill(shape);
            g2d.setColor(ColorUtil.withAlpha((Color)Color.BLACK, (double)0.4));
            g2d.draw(shape);
        }
        finally {
            g2d.dispose();
        }
    }

    @Override
    public int getIconWidth() {
        Icon icon = this.base;
        return icon != null ? icon.getIconWidth() : this.emptyIconWidth;
    }

    @Override
    public int getIconHeight() {
        Icon icon = this.base;
        return icon != null ? icon.getIconHeight() : this.emptyIconHeight;
    }
}

