/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.target.LanguageRuntimeType;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurations;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TargetEnvironmentAwareRunProfile
extends RunProfile {
    public boolean canRunOn(@NotNull TargetEnvironmentConfiguration var1);

    @Nullable
    public LanguageRuntimeType<?> getDefaultLanguageRuntimeType();

    @Nullable
    public String getDefaultTargetName();

    public void setDefaultTargetName(@Nullable String var1);

    default public void validateRunTarget(@NotNull Project project) throws RuntimeConfigurationException {
        String targetName;
        if (project == null) {
            TargetEnvironmentAwareRunProfile.$$$reportNull$$$0(0);
        }
        if ((targetName = TargetEnvironmentConfigurations.getEffectiveTargetName(this, project)) == null) {
            return;
        }
        TargetEnvironmentConfiguration target = (TargetEnvironmentConfiguration)ContainerUtil.find(TargetEnvironmentsManager.getInstance(project).getTargets().resolvedConfigs(), next -> targetName.equals(next.getDisplayName()));
        if (target == null) {
            throw new RuntimeConfigurationError(ExecutionBundle.message("TargetEnvironmentAwareRunProfile.error.cannot.find.run.target", targetName));
        }
        try {
            target.validateConfiguration();
        }
        catch (RuntimeConfigurationException e) {
            throw new RuntimeConfigurationError(ExecutionBundle.message("TargetEnvironmentAwareRunProfile.error.run.target.error.0", e.getMessage()));
        }
    }

    default public boolean needPrepareTarget() {
        Project project = this instanceof RunConfigurationBase ? ((RunConfigurationBase)((Object)this)).getProject() : null;
        String targetName = TargetEnvironmentConfigurations.getEffectiveTargetName(this, project);
        if (targetName == null) {
            return false;
        }
        TargetEnvironmentType type = (TargetEnvironmentType)TargetEnvironmentType.EXTENSION_NAME.findFirstSafe(t -> targetName.equals(t.getDisplayName()));
        return type == null || !type.isLocalTarget();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/target/TargetEnvironmentAwareRunProfile", "validateRunTarget"));
    }
}

