/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.export;

import com.intellij.DynamicBundle;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.export.ExportTestResultsConfiguration;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExportTestResultsForm {
    private JRadioButton myXmlRb;
    private JRadioButton myBundledTemplateRb;
    private TextFieldWithBrowseButton myCustomTemplateField;
    private TextFieldWithBrowseButton myFolderField;
    private JPanel myContentPane;
    private JLabel myOutputFolderLabel;
    private JRadioButton myCustomTemplateRb;
    private JTextField myFileNameField;
    private JLabel myMessageLabel;
    private JCheckBox myOpenExportedFileCb;
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public ExportTestResultsForm(ExportTestResultsConfiguration config, String defaultFileName, @NlsSafe String defaultFolder) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportTestResultsForm.this.updateOnFormatChange();
            }
        };
        this.myXmlRb.addActionListener(listener2);
        this.myBundledTemplateRb.addActionListener(listener2);
        this.myCustomTemplateRb.addActionListener(listener2);
        this.myOutputFolderLabel.setLabelFor(this.myFolderField.getChildComponent());
        this.myFileNameField.setText(defaultFileName);
        FileChooserDescriptor templateDescriptor = new FileChooserDescriptor(this, true, false, false, false, false, false){

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                return file != null && ("xsl".equalsIgnoreCase(file.getExtension()) || "xslt".equalsIgnoreCase(file.getExtension()));
            }
        }.withTitle(ExecutionBundle.message("export.test.results.custom.template.chooser.title", new Object[0]));
        this.myCustomTemplateField.addBrowseFolderListener(null, templateDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserDescriptor outputDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(ExecutionBundle.message("export.test.results.output.folder.chooser.title", new Object[0]));
        this.myFolderField.addBrowseFolderListener(null, outputDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myFileNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                ExportTestResultsForm.this.updateOpenInLabel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/testframework/export/ExportTestResultsForm$3", "textChanged"));
            }
        });
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.register((Component)this.myContentPane);
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                ((ChangeListener)ExportTestResultsForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
            }
        });
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        JRadioButton b = config.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml ? this.myXmlRb : (config.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.BundledTemplate ? this.myBundledTemplateRb : this.myCustomTemplateRb);
        b.setSelected(true);
        IdeFocusManager.findInstanceByComponent((Component)this.myContentPane).requestFocus((Component)b, true);
        this.myFolderField.setText(defaultFolder);
        this.myCustomTemplateField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)config.getUserTemplatePath())));
        this.myOpenExportedFileCb.setSelected(config.isOpenResults());
        this.updateOnFormatChange();
        this.updateOpenInLabel();
    }

    private void updateOpenInLabel() {
        this.myOpenExportedFileCb.setText(ExecutionBundle.message(ExportTestResultsForm.shouldOpenInBrowser(this.myFileNameField.getText()) ? "export.test.results.open.browser" : "export.test.results.open.editor", new Object[0]));
    }

    public static boolean shouldOpenInBrowser(String filename) {
        return StringUtil.isNotEmpty((String)filename) && (filename.endsWith(".html") || filename.endsWith(".htm"));
    }

    private void updateOnFormatChange() {
        if (this.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.UserTemplate) {
            this.myCustomTemplateField.setEnabled(true);
            IdeFocusManager.findInstanceByComponent((Component)this.myContentPane).requestFocus((Component)this.myCustomTemplateField.getChildComponent(), true);
        } else {
            this.myCustomTemplateField.setEnabled(false);
        }
        String filename = this.myFileNameField.getText();
        if (filename != null && filename.indexOf(46) != -1) {
            this.myFileNameField.setText(filename.substring(0, filename.lastIndexOf(46) + 1) + this.getExportFormat().getDefaultExtension());
        }
    }

    public void apply(ExportTestResultsConfiguration config) {
        config.setExportFormat(this.getExportFormat());
        config.setUserTemplatePath(FileUtil.toSystemIndependentName((String)this.myCustomTemplateField.getText()));
        config.setOutputFolder(FileUtil.toSystemIndependentName((String)this.myFolderField.getText()));
        config.setOpenResults(this.myOpenExportedFileCb.isSelected());
    }

    private ExportTestResultsConfiguration.ExportFormat getExportFormat() {
        if (this.myXmlRb.isSelected()) {
            return ExportTestResultsConfiguration.ExportFormat.Xml;
        }
        if (this.myBundledTemplateRb.isSelected()) {
            return ExportTestResultsConfiguration.ExportFormat.BundledTemplate;
        }
        return ExportTestResultsConfiguration.ExportFormat.UserTemplate;
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.myEventDispatcher.addListener((EventListener)changeListener);
    }

    @NlsContexts.Label
    @Nullable
    public String validate() {
        if (this.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.UserTemplate) {
            if (StringUtil.isEmpty((String)this.myCustomTemplateField.getText())) {
                return ExecutionBundle.message("export.test.results.custom.template.path.empty", new Object[0]);
            }
            File file = new File(this.myCustomTemplateField.getText());
            if (!file.isFile()) {
                return ExecutionBundle.message("export.test.results.custom.template.not.found", file.getAbsolutePath());
            }
        }
        if (StringUtil.isEmpty((String)this.myFileNameField.getText())) {
            return ExecutionBundle.message("export.test.results.output.filename.empty", new Object[0]);
        }
        if (StringUtil.isEmpty((String)this.myFolderField.getText())) {
            return ExecutionBundle.message("export.test.results.output.path.empty", new Object[0]);
        }
        return null;
    }

    public void showMessage(@NlsContexts.Label @Nullable String message) {
        this.myMessageLabel.setText(message);
        this.myMessageLabel.setVisible(message != null);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFileNameField;
    }

    public String getFileName() {
        return this.myFileNameField.getText();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/TestRunnerBundle", ExportTestResultsForm.class).getString("border.title.export.format"), (int)0, (int)0, null, null));
        this.myBundledTemplateRb = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("HTML");
        jRadioButton3.setMnemonic('H');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myXmlRb = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("XML");
        jRadioButton2.setMnemonic('X');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomTemplateRb = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, DynamicBundle.getBundle((String)"messages/TestRunnerBundle", ExportTestResultsForm.class).getString("radio.button.custom.apply.xsl.template"));
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomTemplateField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)DynamicBundle.getBundle((String)"messages/TestRunnerBundle", ExportTestResultsForm.class).getString("border.title.output"), (int)0, (int)0, null, null));
        this.myOutputFolderLabel = jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/TestRunnerBundle", ExportTestResultsForm.class).getString("label.folder"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFolderField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/TestRunnerBundle", ExportTestResultsForm.class).getString("label.file.name"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileNameField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText(" ");
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOpenExportedFileCb = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/ExecutionBundle", ExportTestResultsForm.class).getString("export.test.results.open.browser"));
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

