/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.service.AbstractDocumentFormattingService;
import com.intellij.formatting.service.AsyncDocumentFormattingSupport;
import com.intellij.formatting.service.AsyncDocumentFormattingSupportFactory;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import java.time.Duration;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AsyncDocumentFormattingService
extends AbstractDocumentFormattingService {
    public static final Key<Boolean> FORMAT_DOCUMENT_SYNCHRONOUSLY = Key.create((String)"com.intellij.formatting.service.AsyncDocumentFormattingService.FORMAT_DOCUMENT_SYNCHRONOUSLY");
    protected static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    private final AsyncDocumentFormattingSupport mySupport = ((AsyncDocumentFormattingSupportFactory)ApplicationManager.getApplication().getService(AsyncDocumentFormattingSupportFactory.class)).create(this);

    @Override
    public final void formatDocument(@NotNull Document document, @NotNull List<TextRange> formattingRanges, @NotNull FormattingContext formattingContext, boolean canChangeWhiteSpaceOnly, boolean quickFormat) {
        if (document == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(0);
        }
        if (formattingRanges == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(1);
        }
        if (formattingContext == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(2);
        }
        this.mySupport.formatDocument(document, formattingRanges, formattingContext, canChangeWhiteSpaceOnly, quickFormat);
    }

    @Nullable
    protected abstract FormattingTask createFormattingTask(@NotNull AsyncFormattingRequest var1);

    @NotNull
    protected abstract String getNotificationGroupId();

    @Nullable
    protected String getTimeoutNotificationDisplayId() {
        return null;
    }

    protected boolean needToUpdate() {
        return true;
    }

    @NotNull
    @NlsSafe
    protected abstract String getName();

    protected void prepareForFormatting(@NotNull Document document, @NotNull FormattingContext formattingContext) {
        if (document == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(3);
        }
        if (formattingContext == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(4);
        }
        FileDocumentManager.getInstance().saveDocument(document);
    }

    protected Duration getTimeout() {
        return DEFAULT_TIMEOUT;
    }

    protected AnAction[] getTimeoutActions(@NotNull FormattingContext context) {
        if (context == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(5);
        }
        return AnAction.EMPTY_ARRAY;
    }

    @ApiStatus.Internal
    public static FormattingTask createFormattingTask(@NotNull AsyncDocumentFormattingService service, @NotNull AsyncFormattingRequest request) {
        if (service == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(6);
        }
        if (request == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(7);
        }
        return service.createFormattingTask(request);
    }

    @ApiStatus.Internal
    @NotNull
    public static String getNotificationGroupId(@NotNull AsyncDocumentFormattingService service) {
        if (service == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(8);
        }
        String string = service.getNotificationGroupId();
        if (string == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(9);
        }
        return string;
    }

    @ApiStatus.Internal
    @Nullable
    public static String getTimeoutNotificationDisplayId(@NotNull AsyncDocumentFormattingService service) {
        if (service == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(10);
        }
        return service.getTimeoutNotificationDisplayId();
    }

    @ApiStatus.Internal
    public static boolean needToUpdate(@NotNull AsyncDocumentFormattingService service) {
        if (service == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(11);
        }
        return service.needToUpdate();
    }

    @ApiStatus.Internal
    @NotNull
    @NlsSafe
    public static String getName(@NotNull AsyncDocumentFormattingService service) {
        if (service == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(12);
        }
        String string = service.getName();
        if (string == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(13);
        }
        return string;
    }

    @ApiStatus.Internal
    public static void prepareForFormatting(@NotNull AsyncDocumentFormattingService service, @NotNull Document document, @NotNull FormattingContext formattingContext) {
        if (service == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(14);
        }
        if (document == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(15);
        }
        if (formattingContext == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(16);
        }
        service.prepareForFormatting(document, formattingContext);
    }

    @ApiStatus.Internal
    public static Duration getTimeout(@NotNull AsyncDocumentFormattingService service) {
        if (service == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(17);
        }
        return service.getTimeout();
    }

    @ApiStatus.Internal
    public static AnAction[] getTimeoutActions(@NotNull AsyncDocumentFormattingService service, @NotNull FormattingContext context) {
        if (service == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(18);
        }
        if (context == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(19);
        }
        return service.getTimeoutActions(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingRanges";
                break;
            }
            case 2: 
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingContext";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/formatting/service/AsyncDocumentFormattingService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/formatting/service/AsyncDocumentFormattingService";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotificationGroupId";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatDocument";
                break;
            }
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "prepareForFormatting";
                break;
            }
            case 5: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getTimeoutActions";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createFormattingTask";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNotificationGroupId";
                break;
            }
            case 9: 
            case 13: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTimeoutNotificationDisplayId";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "needToUpdate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTimeout";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9, 13 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.OverrideOnly
    public static interface FormattingTask
    extends Runnable {
        public boolean cancel();

        default public boolean isRunUnderProgress() {
            return false;
        }
    }
}

