/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.actions;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u0012\u0012\u0004\u0012\u00020\u00030\u0002j\b\u0012\u0004\u0012\u00020\u0003`\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0018\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u0003H\u0016J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0019H\u0002J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020 2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\""}, d2={"Lcom/intellij/ide/bookmark/actions/NextBookmarkService;", "Lcom/intellij/ide/bookmark/BookmarksListener;", "Ljava/util/Comparator;", "Lcom/intellij/ide/bookmark/LineBookmark;", "Lkotlin/Comparator;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/concurrent/atomic/AtomicReference;", "", "bookmarks", "getBookmarks", "()Ljava/util/List;", "getCachedBookmarks", "bookmarkAdded", "", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "bookmarkRemoved", "bookmarksChanged", "compareFiles", "", "bookmark1", "bookmark2", "compareLines", "compare", "next", "forward", "", "index", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nNextBookmarkService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextBookmarkService.kt\ncom/intellij/ide/bookmark/actions/NextBookmarkService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n812#2,12:85\n1#3:97\n*S KotlinDebug\n*F\n+ 1 NextBookmarkService.kt\ncom/intellij/ide/bookmark/actions/NextBookmarkService\n*L\n47#1:85,12\n*E\n"})
public final class NextBookmarkService
implements BookmarksListener,
Comparator<LineBookmark> {
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicReference<List<LineBookmark>> cache;

    public NextBookmarkService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.cache = new AtomicReference();
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this.project);
        Topic topic = BookmarksListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)this);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LineBookmark> getBookmarks() {
        Object object;
        block4: {
            block3: {
                void $this$filterIsInstanceTo$iv$iv;
                object = BookmarksManager.getInstance((Project)this.project);
                if (object == null || (object = object.getBookmarks()) == null) break block3;
                Iterable $this$filterIsInstance$iv = (Iterable)object;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof LineBookmark)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                object = CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)this);
                if (object != null) break block4;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<LineBookmark> getCachedBookmarks() {
        List<LineBookmark> list2;
        AtomicReference<List<LineBookmark>> atomicReference = this.cache;
        synchronized (atomicReference) {
            boolean bl = false;
            List<LineBookmark> list3 = this.cache.get();
            if (list3 == null) {
                List<LineBookmark> list4;
                List<LineBookmark> it = list4 = this.getBookmarks();
                boolean bl2 = false;
                this.cache.set(it);
                list3 = list4;
            }
            list2 = list3;
        }
        return list2;
    }

    public void bookmarkAdded(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.bookmarksChanged(bookmark);
    }

    public void bookmarkRemoved(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.bookmarksChanged(bookmark);
    }

    private final void bookmarksChanged(Bookmark bookmark) {
        if (bookmark instanceof LineBookmark) {
            this.cache.set(null);
        }
    }

    private final int compareFiles(LineBookmark bookmark1, LineBookmark bookmark2) {
        String string = bookmark1.getFile().getPath();
        String string2 = bookmark2.getFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
        return string.compareTo(string2);
    }

    private final int compareLines(LineBookmark bookmark1, LineBookmark bookmark2) {
        return Intrinsics.compare((int)bookmark1.getLine(), (int)bookmark2.getLine());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compare(@NotNull LineBookmark bookmark1, @NotNull LineBookmark bookmark2) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)bookmark1, (String)"bookmark1");
        Intrinsics.checkNotNullParameter((Object)bookmark2, (String)"bookmark2");
        int result2 = this.compareFiles(bookmark1, bookmark2);
        return result2 == 0 ? this.compareLines(bookmark1, bookmark2) : var3_3;
    }

    private final int next(boolean forward, int index) {
        return index < 0 ? -index - (forward ? 1 : 2) : index - (forward ? -1 : 1);
    }

    @Nullable
    public final LineBookmark next(boolean forward, @Nullable LineBookmark bookmark) {
        LineBookmark next;
        Collection collection = this.getCachedBookmarks();
        if (collection.isEmpty()) {
            boolean bl = false;
            return null;
        }
        List bookmarks = (List)collection;
        if (!(bookmark == null || (next = (LineBookmark)CollectionsKt.getOrNull((List)bookmarks, (int)this.next(forward, CollectionsKt.binarySearch$default((List)bookmarks, (Object)bookmark, (Comparator)this, (int)0, (int)0, (int)12, null)))) == null && BookmarkOccurrence.Companion.getCyclic())) {
            return next;
        }
        return forward ? (LineBookmark)CollectionsKt.first((List)bookmarks) : (LineBookmark)CollectionsKt.last((List)bookmarks);
    }
}

