/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.macro;

import com.intellij.ide.macro.Macro;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCoreUtil;
import com.intellij.openapi.editor.LogicalPosition;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class EditorMacro
extends Macro {
    private final String myName;

    public EditorMacro(@NotNull String name) {
        if (name == null) {
            EditorMacro.$$$reportNull$$$0(0);
        }
        this.myName = name;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            EditorMacro.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public final String expand(@NotNull DataContext dataContext) {
        Editor editor;
        if (dataContext == null) {
            EditorMacro.$$$reportNull$$$0(2);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) != null) {
            return this.expand(editor);
        }
        return null;
    }

    protected static String getColumnNumber(Editor editor, LogicalPosition pos) {
        if (EditorCoreUtil.inVirtualSpace(editor, pos)) {
            return String.valueOf(pos.column + 1);
        }
        int offset = editor.logicalPositionToOffset(pos);
        return EditorMacro.getColumnNumber(editor, offset);
    }

    @NotNull
    protected static String getColumnNumber(Editor editor, int offset) {
        int lineNumber = EditorMacro.getLineNumber(editor, offset);
        int lineStart = editor.getDocument().getLineStartOffset(lineNumber);
        String string = String.valueOf(offset - lineStart + 1);
        if (string == null) {
            EditorMacro.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected static int getLineNumber(Editor editor, int offset) {
        return editor.getDocument().getLineNumber(offset);
    }

    @Nullable
    protected abstract String expand(Editor var1);

    @TestOnly
    @ApiStatus.Internal
    @Nullable
    public String expandTestAccessor(Editor editor) {
        return this.expand(editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/macro/EditorMacro";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/macro/EditorMacro";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "expand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

