/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.logical.impl;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.logical.impl.LogicalStructureViewModel;
import com.intellij.ide.structureView.logical.model.LogicalStructureAssembledModel;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/structureView/logical/impl/LogicalStructureViewService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getLogicalStructureBuilder", "Lcom/intellij/ide/structureView/StructureViewBuilder;", "psiFile", "Lcom/intellij/psi/PsiFile;", "Companion", "intellij.platform.structureView.impl"})
public final class LogicalStructureViewService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public LogicalStructureViewService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final StructureViewBuilder getLogicalStructureBuilder(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!psiFile.isValid()) {
            return null;
        }
        LogicalStructureAssembledModel<PsiFile> assembledModel = LogicalStructureAssembledModel.Companion.getInstance(this.project, psiFile);
        try {
            if (!assembledModel.hasChildren()) {
                return null;
            }
        }
        catch (Throwable e) {
            if (e instanceof ProcessCanceledException) {
                throw e;
            }
            return null;
        }
        return new TreeBasedStructureViewBuilder(psiFile, assembledModel){
            final /* synthetic */ PsiFile $psiFile;
            final /* synthetic */ LogicalStructureAssembledModel<PsiFile> $assembledModel;
            {
                this.$psiFile = $psiFile;
                this.$assembledModel = $assembledModel;
            }

            public StructureViewModel createStructureViewModel(Editor editor) {
                return new LogicalStructureViewModel(this.$psiFile, editor, this.$assembledModel);
            }

            public boolean isRootNodeShown() {
                return false;
            }
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ide/structureView/logical/impl/LogicalStructureViewService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ide/structureView/logical/impl/LogicalStructureViewService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.structureView.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LogicalStructureViewService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(LogicalStructureViewService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (LogicalStructureViewService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

