/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.PsiNavigateUtil;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/inspector/UiInspectorImpl;", "", "<init>", "()V", "openClassByFqn", "", "project", "Lcom/intellij/openapi/project/Project;", "jvmFqn", "", "requestFocus", "", "findClassByFqn", "Lcom/intellij/psi/PsiElement;", "findAnonymousClass", "containingClass", "intellij.platform.ide.ui.inspector"})
@SourceDebugExtension(value={"SMAP\nUiInspectorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiInspectorImpl.kt\ncom/intellij/internal/inspector/UiInspectorImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,81:1\n742#2,9:82\n37#3,2:91\n*S KotlinDebug\n*F\n+ 1 UiInspectorImpl.kt\ncom/intellij/internal/inspector/UiInspectorImpl\n*L\n48#1:82,9\n48#1:91,2\n*E\n"})
public final class UiInspectorImpl {
    @NotNull
    public static final UiInspectorImpl INSTANCE = new UiInspectorImpl();

    private UiInspectorImpl() {
    }

    @JvmStatic
    public static final void openClassByFqn(@Nullable Project project, @NotNull String jvmFqn, boolean requestFocus) {
        Intrinsics.checkNotNullParameter((Object)jvmFqn, (String)"jvmFqn");
        PsiElement psiElement = UiInspectorImpl.findClassByFqn(project, jvmFqn);
        if (psiElement == null) {
            return;
        }
        PsiElement classElement = psiElement;
        PsiElement element = classElement.getNavigationElement();
        if (element instanceof Navigatable) {
            ((Navigatable)element).navigate(requestFocus);
        } else {
            PsiNavigateUtil.navigate((PsiElement)classElement, (boolean)requestFocus);
        }
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final PsiElement findClassByFqn(@Nullable Project project, @NotNull String jvmFqn) {
        Intrinsics.checkNotNullParameter((Object)jvmFqn, (String)"jvmFqn");
        if (project == null) {
            return null;
        }
        try {
            Object result2;
            Class<?> facade;
            IdeaPluginDescriptor plugin;
            String javaPsiFacadeFqn = "com.intellij.psi.JavaPsiFacade";
            PluginId pluginId = PluginManager.getPluginByClassNameAsNoAccessToClass((String)javaPsiFacadeFqn);
            Class<Object> clazz = pluginId != null ? ((plugin = PluginManager.getInstance().findEnabledPlugin(pluginId)) != null ? Class.forName(javaPsiFacadeFqn, false, plugin.getPluginClassLoader()) : null) : (facade = Class.forName(javaPsiFacadeFqn));
            if (facade == null) {
                return null;
            }
            Class[] classArray = new Class[]{Project.class};
            Method getInstance = facade.getDeclaredMethod("getInstance", classArray);
            Class[] classArray2 = new Class[]{String.class, GlobalSearchScope.class};
            Method findClass = facade.getDeclaredMethod("findClass", classArray2);
            String ourFqn = StringsKt.replace$default((String)jvmFqn, (char)'$', (char)'.', (boolean)false, (int)4, null);
            Object[] objectArray = new Object[]{project};
            Object object = findClass.invoke(getInstance.invoke(null, objectArray), objectArray = new Object[]{ourFqn, GlobalSearchScope.allScope((Project)project)});
            if (object == null) {
                void $this$toTypedArray$iv;
                List list2;
                Collection $this$dropLastWhile$iv;
                UiInspectorImpl $this$findClassByFqn_u24lambda_u240 = INSTANCE;
                boolean bl = false;
                Object object2 = jvmFqn;
                Regex regex = new Regex("\\$\\d+");
                int n = 0;
                object2 = regex.split((CharSequence)object2, n);
                boolean $i$f$dropLastWhile = false;
                if (!$this$dropLastWhile$iv.isEmpty()) {
                    ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                    while (iterator$iv.hasPrevious()) {
                        String it = (String)iterator$iv.previous();
                        boolean bl2 = false;
                        if (((CharSequence)it).length() == 0) continue;
                        list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                        break;
                    }
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                $this$dropLastWhile$iv = list2;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                String[] parts = thisCollection$iv.toArray(new String[0]);
                String containingClassJvmFqn = parts[0];
                String containingClassOurFqn = StringsKt.replace$default((String)containingClassJvmFqn, (char)'$', (char)'.', (boolean)false, (int)4, null);
                Object[] objectArray2 = new Object[]{project};
                Object object3 = getInstance.invoke(null, objectArray2);
                objectArray2 = new Object[]{containingClassOurFqn, GlobalSearchScope.allScope((Project)project)};
                Object containingClass = findClass.invoke(object3, objectArray2);
                if (containingClass instanceof PsiElement) {
                    object = $this$findClassByFqn_u24lambda_u240.findAnonymousClass((PsiElement)containingClass, jvmFqn);
                    if (object == null) {
                        object = (PsiElement)containingClass;
                    }
                } else {
                    object = null;
                }
            }
            return (result2 = object) instanceof PsiElement ? (PsiElement)result2 : null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final PsiElement findAnonymousClass(PsiElement containingClass, String jvmFqn) {
        try {
            Class<?> clazz = Class.forName("com.intellij.ide.actions.searcheverywhere.ClassSearchEverywhereContributor");
            Class[] classArray = new Class[]{String.class};
            Method method = clazz.getDeclaredMethod("pathToAnonymousClass", classArray);
            method.setAccessible(true);
            Object[] objectArray = new Object[]{jvmFqn};
            Class[] classArray2 = method.invoke(null, objectArray);
            String string = classArray2 instanceof String ? (String)classArray2 : null;
            if (string == null) {
                return null;
            }
            String path = string;
            classArray2 = new Class[]{PsiElement.class, String.class};
            Method getElement = clazz.getDeclaredMethod("getElement", classArray2);
            objectArray = new Object[]{containingClass, path};
            Object object = getElement.invoke(null, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.psi.PsiElement");
            return (PsiElement)object;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

