/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.TimerListener;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.ActionCallback;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class ActionManager {
    public static ActionManager getInstance() {
        return (ActionManager)ApplicationManager.getApplication().getService(ActionManager.class);
    }

    @NotNull
    public abstract ActionPopupMenu createActionPopupMenu(@NonNls @NotNull String var1, @NotNull ActionGroup var2);

    @NotNull
    public abstract ActionToolbar createActionToolbar(@NonNls @NotNull String var1, @NotNull ActionGroup var2, boolean var3);

    public abstract AnAction getAction(@NonNls @NotNull String var1);

    @NonNls
    @Nullable
    public abstract String getId(@NotNull AnAction var1);

    public abstract void registerAction(@NonNls @NotNull String var1, @NotNull AnAction var2);

    public abstract void registerAction(@NotNull String var1, @NotNull AnAction var2, @Nullable PluginId var3);

    public abstract void unregisterAction(@NotNull String var1);

    public abstract void replaceAction(@NotNull String var1, @NotNull AnAction var2);

    @Deprecated
    public abstract String @NotNull [] getActionIds(@NotNull String var1);

    public abstract @Unmodifiable @NotNull List<@NonNls String> getActionIdList(@NotNull String var1);

    public abstract boolean isGroup(@NotNull String var1);

    @Nullable
    public abstract AnAction getActionOrStub(@NotNull @NonNls String var1);

    public abstract void addTimerListener(@NotNull TimerListener var1);

    public abstract void removeTimerListener(@NotNull TimerListener var1);

    @NotNull
    public abstract ActionCallback tryToExecute(@NotNull AnAction var1, @Nullable InputEvent var2, @Nullable Component var3, @Nullable String var4, boolean var5);

    @Deprecated(forRemoval=true)
    public void addAnActionListener(AnActionListener listener2, Disposable parentDisposable) {
        ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(AnActionListener.TOPIC, (Object)listener2);
    }

    @Nullable
    public abstract KeyboardShortcut getKeyboardShortcut(@NonNls @NotNull String var1);

    @ApiStatus.Internal
    protected ActionManager() {
    }
}

