/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.DynamicBundle;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.KeepPopupOnPerform;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.util.BitUtil;
import com.intellij.util.SmartFMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Presentation
implements Cloneable {
    private static final Logger LOG = Logger.getInstance(Presentation.class);
    public static final Supplier<String> NULL_STRING = () -> null;
    public static final Supplier<TextWithMnemonic> NULL_TEXT_WITH_MNEMONIC = () -> null;
    @NonNls
    public static final String PROP_TEXT = "text";
    @NonNls
    public static final String PROP_TEXT_WITH_SUFFIX = "textWithSuffix";
    @NonNls
    public static final String PROP_MNEMONIC_KEY = "mnemonicKey";
    @NonNls
    public static final String PROP_MNEMONIC_INDEX = "mnemonicIndex";
    @NonNls
    public static final String PROP_DESCRIPTION = "description";
    @NonNls
    public static final String PROP_ICON = "icon";
    @NonNls
    public static final String PROP_DISABLED_ICON = "disabledIcon";
    @NonNls
    public static final String PROP_SELECTED_ICON = "selectedIcon";
    @NonNls
    public static final String PROP_HOVERED_ICON = "hoveredIcon";
    @NonNls
    public static final String PROP_VISIBLE = "visible";
    @NonNls
    public static final String PROP_ENABLED = "enabled";
    private static final int IS_ENABLED = 1;
    private static final int IS_VISIBLE = 2;
    private static final int IS_KEEP_POPUP_IF_REQUESTED = 4;
    private static final int IS_KEEP_POPUP_IF_PREFERRED = 8;
    private static final int IS_POPUP_GROUP = 16;
    private static final int IS_PERFORM_GROUP = 32;
    private static final int IS_HIDE_GROUP_IF_EMPTY = 64;
    private static final int IS_DISABLE_GROUP_IF_EMPTY = 128;
    private static final int IS_APPLICATION_SCOPE = 256;
    private static final int IS_PREFER_INJECTED_PSI = 512;
    private static final int IS_ENABLED_IN_MODAL_CONTEXT = 1024;
    private static final int IS_RW_LOCK_REQUIRED = 2048;
    private static final int IS_TEMPLATE = 4096;
    private int myFlags;
    private @NotNull Supplier<@NlsActions.ActionDescription String> descriptionSupplier;
    @NotNull
    private Supplier<TextWithMnemonic> textWithMnemonicSupplier;
    @NotNull
    private SmartFMap<String, Object> myUserMap;
    @Nullable
    private @Nullable Supplier<? extends @Nullable Icon> icon;
    private Icon disabledIcon;
    private Icon hoveredIcon;
    private Icon selectedIcon;
    @NotNull
    private FList<PropertyChangeListener> myListeners;
    @NotNull
    private static final NotNullLazyValue<Boolean> outRemoveMnemonics = NotNullLazyValue.createValue(() -> SystemInfoRt.isMac && DynamicBundle.LanguageBundleEP.EP_NAME.hasAnyExtensions());

    @NotNull
    public static Presentation newTemplatePresentation() {
        Presentation presentation = new Presentation();
        presentation.myFlags = BitUtil.set((int)presentation.myFlags, (int)4096, (boolean)true);
        Presentation presentation2 = presentation;
        if (presentation2 == null) {
            Presentation.$$$reportNull$$$0(0);
        }
        return presentation2;
    }

    public Presentation() {
        this.myFlags = 2179;
        this.descriptionSupplier = NULL_STRING;
        this.textWithMnemonicSupplier = NULL_TEXT_WITH_MNEMONIC;
        this.myUserMap = SmartFMap.emptyMap();
        this.myListeners = FList.emptyList();
    }

    public Presentation(@NotNull @NlsActions.ActionText String text2) {
        if (text2 == null) {
            Presentation.$$$reportNull$$$0(1);
        }
        this.myFlags = 2179;
        this.descriptionSupplier = NULL_STRING;
        this.textWithMnemonicSupplier = NULL_TEXT_WITH_MNEMONIC;
        this.myUserMap = SmartFMap.emptyMap();
        this.myListeners = FList.emptyList();
        TextWithMnemonic textWithMnemonic = TextWithMnemonic.fromPlainText((String)text2);
        this.textWithMnemonicSupplier = () -> textWithMnemonic;
    }

    public Presentation(@NotNull Supplier<@NlsActions.ActionText String> dynamicText) {
        if (dynamicText == null) {
            Presentation.$$$reportNull$$$0(2);
        }
        this.myFlags = 2179;
        this.descriptionSupplier = NULL_STRING;
        this.textWithMnemonicSupplier = NULL_TEXT_WITH_MNEMONIC;
        this.myUserMap = SmartFMap.emptyMap();
        this.myListeners = FList.emptyList();
        this.textWithMnemonicSupplier = () -> TextWithMnemonic.fromPlainText((String)((String)dynamicText.get()));
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener l) {
        if (l == null) {
            Presentation.$$$reportNull$$$0(3);
        }
        this.myListeners = this.myListeners.prepend((Object)l);
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener l) {
        if (l == null) {
            Presentation.$$$reportNull$$$0(4);
        }
        this.myListeners = this.myListeners.without((Object)l);
    }

    @NlsActions.ActionText
    public String getText() {
        return this.getText(false);
    }

    @NlsActions.ActionText
    public String getText(boolean withSuffix) {
        TextWithMnemonic textWithMnemonic = this.textWithMnemonicSupplier.get();
        return textWithMnemonic == null ? null : textWithMnemonic.getText(withSuffix);
    }

    @ApiStatus.Internal
    public boolean hasText() {
        return this.textWithMnemonicSupplier.get() != null;
    }

    public void setText(@NotNull @Nls(capitalization=Nls.Capitalization.Title) Supplier<String> text2, boolean mayContainMnemonic) {
        if (text2 == null) {
            Presentation.$$$reportNull$$$0(5);
        }
        this.setTextWithMnemonic(this.getTextWithMnemonic(text2, mayContainMnemonic));
    }

    public void setText(@Nullable @NlsActions.ActionText String text2, boolean mayContainMnemonic) {
        this.setTextWithMnemonic(this.getTextWithMnemonic(() -> text2, mayContainMnemonic));
    }

    @NotNull
    public Supplier<TextWithMnemonic> getTextWithMnemonic(@NotNull Supplier<@Nls(capitalization=Nls.Capitalization.Title) String> text2, boolean mayContainMnemonic) {
        if (text2 == null) {
            Presentation.$$$reportNull$$$0(6);
        }
        if (text2 == NULL_STRING) {
            Supplier<TextWithMnemonic> supplier = NULL_TEXT_WITH_MNEMONIC;
            if (supplier == null) {
                Presentation.$$$reportNull$$$0(7);
            }
            return supplier;
        }
        if (mayContainMnemonic) {
            Supplier<TextWithMnemonic> supplier = () -> {
                String s = (String)text2.get();
                if (s == null) {
                    return null;
                }
                TextWithMnemonic parsed = TextWithMnemonic.parse((String)s);
                UISettings uiSettings = UISettings.getInstanceOrNull();
                boolean mnemonicsDisabled = uiSettings != null && uiSettings.getDisableMnemonicsInControls();
                return mnemonicsDisabled ? parsed.dropMnemonic(((Boolean)outRemoveMnemonics.getValue()).booleanValue()) : parsed;
            };
            if (supplier == null) {
                Presentation.$$$reportNull$$$0(8);
            }
            return supplier;
        }
        Supplier<TextWithMnemonic> supplier = () -> {
            String s = (String)text2.get();
            return s == null ? null : TextWithMnemonic.fromPlainText((String)s);
        };
        if (supplier == null) {
            Presentation.$$$reportNull$$$0(9);
        }
        return supplier;
    }

    public void setTextWithMnemonic(@NotNull Supplier<TextWithMnemonic> textWithMnemonicSupplier) {
        if (textWithMnemonicSupplier == null) {
            Presentation.$$$reportNull$$$0(10);
        }
        if (this.myListeners.isEmpty()) {
            this.textWithMnemonicSupplier = textWithMnemonicSupplier;
            return;
        }
        String oldText = this.getText();
        String oldTextWithSuffix = this.getText(true);
        int oldMnemonic = this.getMnemonic();
        int oldIndex = this.getDisplayedMnemonicIndex();
        this.textWithMnemonicSupplier = textWithMnemonicSupplier;
        this.fireObjectPropertyChange(PROP_TEXT, oldText, this.getText());
        this.fireObjectPropertyChange(PROP_TEXT_WITH_SUFFIX, oldTextWithSuffix, this.getText(true));
        this.fireObjectPropertyChange(PROP_MNEMONIC_KEY, oldMnemonic, this.getMnemonic());
        this.fireObjectPropertyChange(PROP_MNEMONIC_INDEX, oldIndex, this.getDisplayedMnemonicIndex());
    }

    public void setText(@Nullable @NlsActions.ActionText String text2) {
        this.setText(() -> text2, true);
    }

    public void setText(@NotNull @Nls(capitalization=Nls.Capitalization.Title) Supplier<String> text2) {
        if (text2 == null) {
            Presentation.$$$reportNull$$$0(11);
        }
        this.setText(text2, true);
    }

    @ApiStatus.Internal
    public void setFallbackPresentationText(@NotNull Supplier<String> supplier) {
        if (supplier == null) {
            Presentation.$$$reportNull$$$0(12);
        }
        Supplier<TextWithMnemonic> original = this.textWithMnemonicSupplier;
        Supplier<TextWithMnemonic> fallback = this.getTextWithMnemonic(supplier, true);
        this.textWithMnemonicSupplier = () -> {
            TextWithMnemonic result2 = (TextWithMnemonic)original.get();
            return result2 == null ? (TextWithMnemonic)fallback.get() : result2;
        };
    }

    @NlsActions.ActionText
    @Nullable
    public String getTextWithMnemonic() {
        TextWithMnemonic textWithMnemonic = this.textWithMnemonicSupplier.get();
        return textWithMnemonic == null ? null : textWithMnemonic.toString();
    }

    @NotNull
    public Supplier<TextWithMnemonic> getTextWithPossibleMnemonic() {
        Supplier<TextWithMnemonic> supplier = this.textWithMnemonicSupplier;
        if (supplier == null) {
            Presentation.$$$reportNull$$$0(13);
        }
        return supplier;
    }

    public void restoreTextWithMnemonic(Presentation presentation) {
        this.setTextWithMnemonic(presentation.getTextWithPossibleMnemonic());
    }

    @NlsActions.ActionDescription
    public String getDescription() {
        return this.descriptionSupplier.get();
    }

    public void setDescription(@NotNull Supplier<@NlsActions.ActionDescription String> dynamicDescription) {
        if (dynamicDescription == null) {
            Presentation.$$$reportNull$$$0(14);
        }
        if (this.myListeners.isEmpty()) {
            this.descriptionSupplier = dynamicDescription;
            return;
        }
        Supplier<String> oldDescription = this.descriptionSupplier;
        this.descriptionSupplier = dynamicDescription;
        this.fireObjectPropertyChange(PROP_DESCRIPTION, oldDescription.get(), this.descriptionSupplier.get());
    }

    public void setDescription(@NlsActions.ActionDescription String description) {
        if (this.myListeners.isEmpty()) {
            this.descriptionSupplier = () -> description;
            return;
        }
        Supplier<String> oldDescriptionSupplier = this.descriptionSupplier;
        this.descriptionSupplier = () -> description;
        this.fireObjectPropertyChange(PROP_DESCRIPTION, oldDescriptionSupplier.get(), description);
    }

    @Nullable
    public Icon getIcon() {
        Supplier<? extends Icon> icon = this.icon;
        return icon == null ? null : icon.get();
    }

    @Nullable
    public @Nullable Supplier<? extends @Nullable Icon> getIconSupplier() {
        return this.icon;
    }

    @ApiStatus.Internal
    public void copyUnsetTemplateProperties(@NotNull Presentation other) {
        if (other == null) {
            Presentation.$$$reportNull$$$0(15);
        }
        if (this.icon == null) {
            this.icon = other.icon;
        }
        if (Strings.isEmpty((String)this.getText()) && Strings.isNotEmpty((String)other.getText())) {
            this.textWithMnemonicSupplier = other.textWithMnemonicSupplier;
        }
        if (Strings.isEmpty((String)this.descriptionSupplier.get()) && Strings.isNotEmpty((String)other.descriptionSupplier.get())) {
            this.descriptionSupplier = other.descriptionSupplier;
        }
        this.myUserMap = this.myUserMap.plusAll(other.myUserMap);
    }

    public void setIcon(@Nullable Icon icon) {
        if (this.myListeners.isEmpty()) {
            this.icon = icon == null ? null : () -> icon;
            return;
        }
        Icon oldIcon = this.icon == null ? null : this.icon.get();
        this.icon = () -> icon;
        this.fireObjectPropertyChange(PROP_ICON, oldIcon, icon);
    }

    public void setIconSupplier(@Nullable @Nullable Supplier<? extends @Nullable Icon> icon) {
        Icon newIcon;
        if (this.myListeners.isEmpty()) {
            this.icon = icon;
            return;
        }
        Icon oldIcon = this.icon == null ? null : this.icon.get();
        this.icon = icon;
        Icon icon2 = newIcon = icon == null ? null : icon.get();
        if (Objects.equals(oldIcon, newIcon)) {
            return;
        }
        this.fireObjectPropertyChange(PROP_ICON, oldIcon, newIcon);
    }

    @Nullable
    public Icon getDisabledIcon() {
        return this.disabledIcon;
    }

    public void setDisabledIcon(@Nullable Icon icon) {
        Icon oldDisabledIcon = this.disabledIcon;
        this.disabledIcon = icon;
        this.fireObjectPropertyChange(PROP_DISABLED_ICON, oldDisabledIcon, this.disabledIcon);
    }

    @Nullable
    public Icon getHoveredIcon() {
        return this.hoveredIcon;
    }

    public void setHoveredIcon(@Nullable Icon hoveredIcon) {
        Icon old = this.hoveredIcon;
        this.hoveredIcon = hoveredIcon;
        this.fireObjectPropertyChange(PROP_HOVERED_ICON, old, this.hoveredIcon);
    }

    @Nullable
    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(@Nullable Icon selectedIcon) {
        Icon old = this.selectedIcon;
        this.selectedIcon = selectedIcon;
        this.fireObjectPropertyChange(PROP_SELECTED_ICON, old, this.selectedIcon);
    }

    public int getMnemonic() {
        TextWithMnemonic textWithMnemonic = this.textWithMnemonicSupplier.get();
        return textWithMnemonic == null ? 0 : textWithMnemonic.getMnemonicCode();
    }

    public int getDisplayedMnemonicIndex() {
        TextWithMnemonic textWithMnemonic = this.textWithMnemonicSupplier.get();
        return textWithMnemonic == null ? -1 : textWithMnemonic.getMnemonicIndex();
    }

    public boolean isVisible() {
        return BitUtil.isSet((int)this.myFlags, (int)2);
    }

    public void setVisible(boolean visible) {
        this.assertNotTemplatePresentation();
        boolean oldVisible = BitUtil.isSet((int)this.myFlags, (int)2);
        this.myFlags = BitUtil.set((int)this.myFlags, (int)2, (boolean)visible);
        this.fireBooleanPropertyChange(PROP_VISIBLE, oldVisible, visible);
    }

    public boolean isPopupGroup() {
        return BitUtil.isSet((int)this.myFlags, (int)16);
    }

    public void setPopupGroup(boolean popup) {
        this.myFlags = BitUtil.set((int)this.myFlags, (int)16, (boolean)popup);
    }

    public boolean isPerformGroup() {
        return BitUtil.isSet((int)this.myFlags, (int)32);
    }

    public void setPerformGroup(boolean performing) {
        this.myFlags = BitUtil.set((int)this.myFlags, (int)32, (boolean)performing);
    }

    public boolean isHideGroupIfEmpty() {
        return BitUtil.isSet((int)this.myFlags, (int)64);
    }

    public void setHideGroupIfEmpty(boolean hide) {
        this.myFlags = BitUtil.set((int)this.myFlags, (int)64, (boolean)hide);
    }

    public boolean isDisableGroupIfEmpty() {
        return BitUtil.isSet((int)this.myFlags, (int)128);
    }

    public void setDisableGroupIfEmpty(boolean disable) {
        this.myFlags = BitUtil.set((int)this.myFlags, (int)128, (boolean)disable);
    }

    public boolean isApplicationScope() {
        return BitUtil.isSet((int)this.myFlags, (int)256);
    }

    public void setApplicationScope(boolean applicationScope) {
        this.myFlags = BitUtil.set((int)this.myFlags, (int)256, (boolean)applicationScope);
    }

    @ApiStatus.Experimental
    public boolean isRWLockRequired() {
        if (!Registry.is((String)"actions.allow.update.and.perform.without.rw.lock")) {
            return true;
        }
        return BitUtil.isSet((int)this.myFlags, (int)2048);
    }

    @ApiStatus.Experimental
    public void setRWLockRequired(boolean rwLockRequired) {
        if (!this.isTemplate()) {
            LOG.error("setRWLockRequired() should be called only for template presentations");
        }
        this.myFlags = BitUtil.set((int)this.myFlags, (int)2048, (boolean)rwLockRequired);
    }

    public void setKeepPopupOnPerform(@NotNull KeepPopupOnPerform mode) {
        if (mode == null) {
            Presentation.$$$reportNull$$$0(16);
        }
        boolean requestedBit = mode == KeepPopupOnPerform.IfRequested || mode == KeepPopupOnPerform.Always;
        boolean preferredBit = mode == KeepPopupOnPerform.IfPreferred || mode == KeepPopupOnPerform.Always;
        this.myFlags = BitUtil.set((int)this.myFlags, (int)4, (boolean)requestedBit);
        this.myFlags = BitUtil.set((int)this.myFlags, (int)8, (boolean)preferredBit);
    }

    @NotNull
    public KeepPopupOnPerform getKeepPopupOnPerform() {
        boolean requestedBit = BitUtil.isSet((int)this.myFlags, (int)4);
        boolean preferedBit = BitUtil.isSet((int)this.myFlags, (int)8);
        KeepPopupOnPerform keepPopupOnPerform = requestedBit && preferedBit ? KeepPopupOnPerform.Always : (requestedBit ? KeepPopupOnPerform.IfRequested : (preferedBit ? KeepPopupOnPerform.IfPreferred : KeepPopupOnPerform.Never));
        if (keepPopupOnPerform == null) {
            Presentation.$$$reportNull$$$0(17);
        }
        return keepPopupOnPerform;
    }

    @ApiStatus.Internal
    public boolean isPreferInjectedPsi() {
        return BitUtil.isSet((int)this.myFlags, (int)512);
    }

    @ApiStatus.Internal
    public void setPreferInjectedPsi(boolean preferInjectedPsi) {
        this.myFlags = BitUtil.set((int)this.myFlags, (int)512, (boolean)preferInjectedPsi);
    }

    @ApiStatus.Internal
    public boolean isEnabledInModalContext() {
        return BitUtil.isSet((int)this.myFlags, (int)1024);
    }

    @ApiStatus.Internal
    public void setEnabledInModalContext(boolean enabledInModalContext) {
        this.myFlags = BitUtil.set((int)this.myFlags, (int)1024, (boolean)enabledInModalContext);
    }

    public boolean isTemplate() {
        return BitUtil.isSet((int)this.myFlags, (int)4096);
    }

    public boolean isEnabled() {
        return BitUtil.isSet((int)this.myFlags, (int)1);
    }

    public void setEnabled(boolean enabled) {
        this.assertNotTemplatePresentation();
        boolean oldEnabled = BitUtil.isSet((int)this.myFlags, (int)1);
        this.myFlags = BitUtil.set((int)this.myFlags, (int)1, (boolean)enabled);
        this.fireBooleanPropertyChange(PROP_ENABLED, oldEnabled, enabled);
    }

    public void setEnabledAndVisible(boolean enabled) {
        this.setEnabled(enabled);
        this.setVisible(enabled);
    }

    private void fireBooleanPropertyChange(@NotNull String propertyName, boolean oldValue, boolean newValue) {
        if (propertyName == null) {
            Presentation.$$$reportNull$$$0(18);
        }
        if (this.myListeners.isEmpty() || oldValue == newValue) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        Presentation.doFirePropertyChange(event, this.myListeners);
    }

    private void fireObjectPropertyChange(@NotNull String propertyName, Object oldValue, Object newValue) {
        if (propertyName == null) {
            Presentation.$$$reportNull$$$0(19);
        }
        if (this.myListeners.isEmpty() || Objects.equals(oldValue, newValue)) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        Presentation.doFirePropertyChange(event, this.myListeners);
    }

    private static void doFirePropertyChange(@NotNull PropertyChangeEvent event, @NotNull FList<PropertyChangeListener> listeners) {
        if (event == null) {
            Presentation.$$$reportNull$$$0(20);
        }
        if (listeners == null) {
            Presentation.$$$reportNull$$$0(21);
        }
        Iterator iterator = (listeners.size() == 1 ? listeners : ContainerUtil.reverse(listeners)).iterator();
        while (iterator.hasNext()) {
            PropertyChangeListener listener2 = (PropertyChangeListener)iterator.next();
            if (listener2 instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy p = (PropertyChangeListenerProxy)listener2;
                if (!event.getPropertyName().equals(p.getPropertyName())) continue;
            }
            listener2.propertyChange(event);
        }
    }

    void assertNotTemplatePresentation() {
        if (BitUtil.isSet((int)this.myFlags, (int)4096)) {
            LOG.warnInProduction(new Throwable("Template presentations must not be used directly"));
        }
    }

    public Presentation clone() {
        try {
            Presentation clone = (Presentation)super.clone();
            clone.myFlags = BitUtil.set((int)clone.myFlags, (int)4096, (boolean)false);
            clone.myListeners = FList.emptyList();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void copyFrom(@NotNull Presentation presentation) {
        if (presentation == null) {
            Presentation.$$$reportNull$$$0(22);
        }
        this.copyFrom(presentation, null, false, false);
    }

    public void copyFrom(@NotNull Presentation presentation, @Nullable Component customComponent) {
        if (presentation == null) {
            Presentation.$$$reportNull$$$0(23);
        }
        this.copyFrom(presentation, customComponent, true, false);
    }

    public void copyFrom(@NotNull Presentation presentation, @Nullable Component customComponent, boolean allFlags) {
        if (presentation == null) {
            Presentation.$$$reportNull$$$0(24);
        }
        this.copyFrom(presentation, customComponent, true, allFlags);
    }

    private void copyFrom(@NotNull Presentation presentation, @Nullable Component customComponent, boolean forceNullComponent, boolean allFlags) {
        if (presentation == null) {
            Presentation.$$$reportNull$$$0(25);
        }
        if (presentation == this) {
            return;
        }
        boolean oldEnabled = this.isEnabled();
        boolean oldVisible = this.isVisible();
        if (allFlags) {
            this.myFlags = BitUtil.set((int)presentation.myFlags, (int)4096, (boolean)this.isTemplate());
        } else {
            this.myFlags = BitUtil.set((int)this.myFlags, (int)1, (boolean)BitUtil.isSet((int)presentation.myFlags, (int)1));
            this.myFlags = BitUtil.set((int)this.myFlags, (int)2, (boolean)BitUtil.isSet((int)presentation.myFlags, (int)2));
        }
        this.fireBooleanPropertyChange(PROP_ENABLED, oldEnabled, this.isEnabled());
        this.fireBooleanPropertyChange(PROP_VISIBLE, oldVisible, this.isVisible());
        this.setTextWithMnemonic(presentation.getTextWithPossibleMnemonic());
        this.setDescription(presentation.descriptionSupplier);
        this.setIconSupplier(presentation.icon);
        this.setSelectedIcon(presentation.getSelectedIcon());
        this.setDisabledIcon(presentation.getDisabledIcon());
        this.setHoveredIcon(presentation.getHoveredIcon());
        if (!this.myUserMap.equals(presentation.myUserMap)) {
            HashSet allKeys = new HashSet(presentation.myUserMap.keySet());
            allKeys.addAll(this.myUserMap.keySet());
            if (!allKeys.isEmpty()) {
                for (String key : allKeys) {
                    if (key.equals(CustomComponentAction.COMPONENT_KEY.toString()) && (customComponent != null || forceNullComponent)) {
                        this.putClientProperty(key, customComponent);
                        continue;
                    }
                    this.putClientProperty(key, presentation.getClientProperty(key));
                }
            }
        }
    }

    @Nullable
    public <T> T getClientProperty(@NotNull Key<T> key) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(26);
        }
        return (T)this.myUserMap.get((Object)key.toString());
    }

    public <T> void putClientProperty(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(27);
        }
        this.putClientProperty(key.toString(), value);
    }

    @Deprecated
    @Nullable
    public Object getClientProperty(@NonNls @NotNull String key) {
        if (key == null) {
            Presentation.$$$reportNull$$$0(28);
        }
        return this.myUserMap.get((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void putClientProperty(@NonNls @NotNull String key, @Nullable Object value) {
        Object oldValue;
        if (key == null) {
            Presentation.$$$reportNull$$$0(29);
        }
        Presentation presentation = this;
        synchronized (presentation) {
            oldValue = this.myUserMap.get((Object)key);
            if (Comparing.equal((Object)oldValue, (Object)value)) {
                return;
            }
            if (key.equals(CustomComponentAction.COMPONENT_KEY.toString()) && oldValue != null) {
                LOG.error("Trying to reset custom component in a presentation", new Throwable());
            }
            this.myUserMap = value == null ? this.myUserMap.minus((Object)key) : this.myUserMap.plus((Object)key, value);
        }
        this.fireObjectPropertyChange(key, oldValue, value);
    }

    @Deprecated(forRemoval=true)
    public void setWeight(double ignore) {
    }

    public boolean isEnabledAndVisible() {
        return this.isEnabled() && this.isVisible();
    }

    @NonNls
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getText()).append(" (").append(this.descriptionSupplier.get()).append(")");
        sb.append(", flags=[");
        int start = sb.length();
        Presentation.appendFlag(this.myFlags, 4096, sb, start, "template");
        Presentation.appendFlag(this.myFlags, 1, sb, start, PROP_ENABLED);
        Presentation.appendFlag(this.myFlags, 2, sb, start, PROP_VISIBLE);
        if (BitUtil.isSet((int)this.myFlags, (int)4) && BitUtil.isSet((int)this.myFlags, (int)8)) {
            Presentation.appendFlag(1, 1, sb, start, "keep_popup_always");
        } else {
            Presentation.appendFlag(this.myFlags, 4, sb, start, "keep_popup_if_requested");
            Presentation.appendFlag(this.myFlags, 8, sb, start, "keep_popup_if_preferred");
        }
        Presentation.appendFlag(this.myFlags, 16, sb, start, "popup_group");
        Presentation.appendFlag(this.myFlags, 32, sb, start, "perform_group");
        Presentation.appendFlag(this.myFlags, 64, sb, start, "hide_group_if_empty");
        Presentation.appendFlag(this.myFlags, 128, sb, start, "disable_group_if_empty");
        Presentation.appendFlag(this.myFlags, 256, sb, start, "application_scope");
        Presentation.appendFlag(this.myFlags, 512, sb, start, "prefer_injected_psi");
        Presentation.appendFlag(this.myFlags, 1024, sb, start, "enabled_in_modal_context");
        Presentation.appendFlag(this.myFlags, 2048, sb, start, "lock_required");
        sb.append("]");
        return sb.toString();
    }

    private static void appendFlag(int flags, int mask, @NotNull StringBuilder sb, int start, @NotNull String maskName) {
        if (sb == null) {
            Presentation.$$$reportNull$$$0(30);
        }
        if (maskName == null) {
            Presentation.$$$reportNull$$$0(31);
        }
        if (!BitUtil.isSet((int)flags, (int)mask)) {
            return;
        }
        if (sb.length() > start) {
            sb.append(", ");
        }
        sb.append(maskName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 10, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/Presentation";
                break;
            }
            case 1: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROP_TEXT;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicText";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textWithMnemonicSupplier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dynamicDescription";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maskName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newTemplatePresentation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/Presentation";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithMnemonic";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextWithPossibleMnemonic";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeepPopupOnPerform";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 5: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTextWithMnemonic";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTextWithMnemonic";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setFallbackPresentationText";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyUnsetTemplateProperties";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setKeepPopupOnPerform";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "fireBooleanPropertyChange";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fireObjectPropertyChange";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doFirePropertyChange";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getClientProperty";
                break;
            }
            case 27: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "putClientProperty";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "appendFlag";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 10, 11, 12, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31 -> new IllegalArgumentException(string);
        };
    }
}

