/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.toolbarLayout;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutUtilKt;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/actionSystem/toolbarLayout/AutoLayoutStrategy;", "Lcom/intellij/openapi/actionSystem/toolbarLayout/ToolbarLayoutStrategy;", "myForceShowFirstComponent", "", "myNoGapMode", "<init>", "(ZZ)V", "expandIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "calculateBounds", "", "Ljava/awt/Rectangle;", "toolbar", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "calcPreferredSize", "Ljava/awt/Dimension;", "calcMinimumSize", "doCalculateBounds", "size2Fit", "intellij.platform.editor.ui"})
@SourceDebugExtension(value={"SMAP\nAutoLayoutStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutoLayoutStrategy.kt\ncom/intellij/openapi/actionSystem/toolbarLayout/AutoLayoutStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,166:1\n777#2:167\n873#2,2:168\n2829#2,7:170\n1401#3,2:177\n1#4:179\n*S KotlinDebug\n*F\n+ 1 AutoLayoutStrategy.kt\ncom/intellij/openapi/actionSystem/toolbarLayout/AutoLayoutStrategy\n*L\n28#1:167\n28#1:168,2\n28#1:170,7\n40#1:177,2\n*E\n"})
public final class AutoLayoutStrategy
implements ToolbarLayoutStrategy {
    private final boolean myForceShowFirstComponent;
    private final boolean myNoGapMode;
    @NotNull
    private final Icon expandIcon;

    public AutoLayoutStrategy(boolean myForceShowFirstComponent, boolean myNoGapMode) {
        this.myForceShowFirstComponent = myForceShowFirstComponent;
        this.myNoGapMode = myNoGapMode;
        Icon icon = AllIcons.Ide.Link;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Link");
        this.expandIcon = icon;
    }

    @Override
    @NotNull
    public List<Rectangle> calculateBounds(@NotNull ActionToolbar toolbar) {
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        Dimension dimension = toolbar.getComponent().getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getSize(...)");
        return this.doCalculateBounds(dimension, toolbar);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Dimension calcPreferredSize(@NotNull ActionToolbar toolbar) {
        void $this$reduce$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        if (toolbar.getComponent().getComponentCount() == 0) {
            JBDimension jBDimension = JBUI.emptySize();
            Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"emptySize(...)");
            return (Dimension)jBDimension;
        }
        List<Rectangle> bounds = this.doCalculateBounds(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE), toolbar);
        Iterable $this$filter$iv = bounds;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Rectangle it = (Rectangle)element$iv$iv;
            boolean bl = false;
            if (!(it.x != Integer.MAX_VALUE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void rect;
            Rectangle $i$f$filterTo2 = (Rectangle)iterator$iv.next();
            Rectangle acc = (Rectangle)accumulator$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)acc.union((Rectangle)rect), (String)"union(...)");
        }
        Dimension size = ((Rectangle)accumulator$iv).getSize();
        JBInsets.addTo((Dimension)size, (Insets)toolbar.getComponent().getInsets());
        Intrinsics.checkNotNull((Object)size);
        return size;
    }

    @Override
    @NotNull
    public Dimension calcMinimumSize(@NotNull ActionToolbar toolbar) {
        Intrinsics.checkNotNullParameter((Object)toolbar, (String)"toolbar");
        int childrenCount = toolbar.getComponent().getComponentCount();
        if (childrenCount == 0) {
            JBDimension jBDimension = JBUI.emptySize();
            Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"emptySize(...)");
            return (Dimension)jBDimension;
        }
        Dimension dimension = new Dimension();
        if (this.myForceShowFirstComponent) {
            Dimension firstChildSize;
            Object object;
            block9: {
                Component[] componentArray = toolbar.getComponent().getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                Object[] $this$firstOrNull$iv = componentArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Component it = (Component)element$iv;
                    boolean bl = false;
                    if (!it.isVisible()) continue;
                    object = element$iv;
                    break block9;
                }
                object = null;
            }
            Component component = (Component)object;
            Dimension dimension2 = firstChildSize = component != null ? component.getPreferredSize() : null;
            if (dimension2 != null) {
                Dimension size = dimension2;
                boolean bl = false;
                if (toolbar.getOrientation() == 0) {
                    dimension.width += size.width;
                    dimension.height = Math.max(dimension.height, size.height);
                } else {
                    dimension.height += size.height;
                    dimension.width = Math.max(dimension.width, size.width);
                }
            }
            --childrenCount;
        }
        if (childrenCount > 0) {
            Dimension dimension3 = toolbar.getMinimumButtonSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"getMinimumButtonSize(...)");
            Dimension minimumButtonSize = dimension3;
            if (toolbar.getOrientation() == 0) {
                dimension.width += this.expandIcon.getIconWidth();
                dimension.height = Math.max(Math.max(dimension.height, this.expandIcon.getIconHeight()), minimumButtonSize.height);
            } else {
                dimension.height += this.expandIcon.getIconHeight();
                dimension.width = Math.max(Math.max(dimension.width, this.expandIcon.getIconWidth()), minimumButtonSize.width);
            }
        }
        JBInsets.addTo((Dimension)dimension, (Insets)toolbar.getComponent().getInsets());
        return dimension;
    }

    private final List<Rectangle> doCalculateBounds(Dimension size2Fit, ActionToolbar toolbar) {
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        JComponent component = jComponent;
        int componentCount = component.getComponentCount();
        Insets insets = component.getInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getInsets(...)");
        Insets insets2 = insets;
        ArrayList<Rectangle> arrayList = new ArrayList<Rectangle>(componentCount);
        int n = 0;
        while (n < componentCount) {
            int n2;
            int n3 = n2 = n++;
            ArrayList<Rectangle> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new Rectangle());
        }
        List res = arrayList;
        Dimension autoButtonSize = toolbar.isReservePlaceAutoPopupIcon() ? new Dimension(this.expandIcon.getIconWidth(), this.expandIcon.getIconHeight()) : new Dimension();
        boolean full = false;
        int widthToFit = size2Fit.width - insets2.left - insets2.right;
        int heightToFit = size2Fit.height - insets2.top - insets2.bottom;
        if (toolbar.getOrientation() == 0) {
            int eachX = 0;
            int maxHeight = heightToFit;
            for (int i = 0; i < componentCount; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)component.getComponent(i), (String)"getComponent(...)");
                boolean isLast = i == componentCount - 1;
                Rectangle eachBound = new Rectangle(ToolbarLayoutUtilKt.getChildPreferredSize(component, i));
                maxHeight = Math.max(eachBound.height, maxHeight);
                if (!full) {
                    boolean inside;
                    boolean bl = isLast ? eachX + eachBound.width <= widthToFit : (inside = eachX + eachBound.width + autoButtonSize.width <= widthToFit);
                    if (inside) {
                        boolean isSecondaryButton;
                        Component eachComp;
                        JComponent jComponent2 = eachComp instanceof JComponent ? (JComponent)eachComp : null;
                        boolean bl2 = isSecondaryButton = jComponent2 != null ? Intrinsics.areEqual((Object)jComponent2.getClientProperty("ClientProperty.SecondaryAction"), (Object)true) : false;
                        if (isSecondaryButton) {
                            if (_Assertions.ENABLED && !isLast) {
                                String string = "Assertion failed";
                                throw new AssertionError((Object)string);
                            }
                            if (size2Fit.width != Integer.MAX_VALUE && !this.myNoGapMode) {
                                eachBound.x = size2Fit.width - insets2.right - eachBound.width;
                                eachX = (int)eachBound.getMaxX() - insets2.left;
                            } else {
                                eachBound.x = insets2.left + eachX;
                            }
                        } else {
                            eachBound.x = insets2.left + eachX;
                            eachX += eachBound.width;
                        }
                        eachBound.y = insets2.top;
                    } else {
                        full = true;
                    }
                }
                if (full) {
                    eachBound.x = Integer.MAX_VALUE;
                    eachBound.y = Integer.MAX_VALUE;
                }
                ((Rectangle)res.get(i)).setBounds(eachBound);
            }
            for (Rectangle r : res) {
                if (r.height >= maxHeight) continue;
                r.y += (maxHeight - r.height) / 2;
            }
        } else {
            int eachY = 0;
            for (int i = 0; i < componentCount; ++i) {
                Rectangle eachBound = new Rectangle(ToolbarLayoutUtilKt.getChildPreferredSize(component, i));
                if (!full) {
                    boolean outside;
                    boolean bl = i < componentCount - 1 ? eachY + eachBound.height + autoButtonSize.height <= heightToFit : (outside = eachY + eachBound.height <= heightToFit);
                    if (outside) {
                        eachBound.x = insets2.left;
                        eachBound.y = insets2.top + eachY;
                        eachY += eachBound.height;
                    } else {
                        full = true;
                    }
                }
                if (full) {
                    eachBound.x = Integer.MAX_VALUE;
                    eachBound.y = Integer.MAX_VALUE;
                }
                ((Rectangle)res.get(i)).setBounds(eachBound);
            }
        }
        return res;
    }
}

