/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.BundleBase;
import com.intellij.DynamicBundle;
import com.intellij.application.options.EditorFontsConstants;
import com.intellij.configurationStore.SerializableScheme;
import com.intellij.ide.ui.ColorBlindness;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.DelegatingFontPreferences;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontCache;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.colors.ModifiableFontPreferences;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.colors.ex.DefaultColorSchemesManager;
import com.intellij.openapi.editor.colors.impl.AppConsoleFontOptions;
import com.intellij.openapi.editor.colors.impl.AppEditorFontOptions;
import com.intellij.openapi.editor.colors.impl.ColorKeyColor;
import com.intellij.openapi.editor.colors.impl.DefaultColorsScheme;
import com.intellij.openapi.editor.colors.impl.EditorColorsSchemeImpl;
import com.intellij.openapi.editor.colors.impl.EditorFontCacheImpl;
import com.intellij.openapi.editor.colors.impl.EmptyColorScheme;
import com.intellij.openapi.editor.colors.impl.FontPreferencesImpl;
import com.intellij.openapi.editor.colors.impl.TextAttributesReader;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeState;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.JBColor;
import com.intellij.util.JdomKt;
import com.intellij.util.PlatformUtils;
import com.intellij.util.SystemProperties;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class AbstractColorsScheme
extends EditorFontCacheImpl
implements EditorColorsScheme,
SerializableScheme {
    private static final Logger LOG = Logger.getInstance(AbstractColorsScheme.class);
    public static final TextAttributes INHERITED_ATTRS_MARKER = new TextAttributes();
    public static final Color INHERITED_COLOR_MARKER = JBColor.marker((String)"INHERITED_COLOR_MARKER");
    public static final Color NULL_COLOR_MARKER = JBColor.marker((String)"NULL_COLOR_MARKER");
    public static final int CURR_VERSION = 142;
    @ApiStatus.Internal
    public static final String ENABLE_RUNTIME_SCHEME_COLOR_WRAPPER_OPTION = "editor.color.scheme.mark.colors";
    public static final String NAME_BUNDLE_PROPERTY = "lcNameBundle";
    public static final String NAME_KEY_PROPERTY = "lcNameKey";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    public static final String META_INFO_PLUGIN_ID = "pluginId";
    @NonNls
    private static final String EDITOR_FONT = "font";
    @NonNls
    private static final String CONSOLE_FONT = "console-font";
    @NonNls
    private static final String EDITOR_FONT_NAME = "EDITOR_FONT_NAME";
    @NonNls
    private static final String CONSOLE_FONT_NAME = "CONSOLE_FONT_NAME";
    @NonNls
    private static final String SCHEME_ELEMENT = "scheme";
    @NonNls
    private static final String VERSION_ATTR = "version";
    @NonNls
    private static final String BASE_ATTRIBUTES_ATTR = "baseAttributes";
    @NonNls
    private static final String DEFAULT_SCHEME_ATTR = "default_scheme";
    @NonNls
    private static final String PARENT_SCHEME_ATTR = "parent_scheme";
    @NonNls
    private static final String OPTION_ELEMENT = "option";
    @NonNls
    private static final String COLORS_ELEMENT = "colors";
    @NonNls
    private static final String ATTRIBUTES_ELEMENT = "attributes";
    @NonNls
    private static final String VALUE_ELEMENT = "value";
    @NonNls
    private static final String BACKGROUND_COLOR_NAME = "BACKGROUND";
    @NonNls
    private static final String LINE_SPACING = "LINE_SPACING";
    @NonNls
    private static final String CONSOLE_LINE_SPACING = "CONSOLE_LINE_SPACING";
    @NonNls
    private static final String FONT_SCALE = "FONT_SCALE";
    @NonNls
    private static final String EDITOR_FONT_SIZE = "EDITOR_FONT_SIZE";
    @NonNls
    private static final String CONSOLE_FONT_SIZE = "CONSOLE_FONT_SIZE";
    @NonNls
    private static final String EDITOR_LIGATURES = "EDITOR_LIGATURES";
    @NonNls
    private static final String CONSOLE_LIGATURES = "CONSOLE_LIGATURES";
    @NonNls
    private static final String META_INFO_ELEMENT = "metaInfo";
    @NonNls
    private static final String PROPERTY_ELEMENT = "property";
    @NonNls
    private static final String PROPERTY_NAME_ATTR = "name";
    @NonNls
    private static final String META_INFO_CREATION_TIME = "created";
    @NonNls
    private static final String META_INFO_MODIFIED_TIME = "modified";
    @NonNls
    private static final String META_INFO_IDE = "ide";
    @NonNls
    private static final String META_INFO_IDE_VERSION = "ideVersion";
    @NonNls
    public static final String META_INFO_ORIGINAL = "originalScheme";
    @NonNls
    private static final String META_INFO_PARTIAL = "partialSave";
    private final boolean myMarkColorIds = SystemProperties.getBooleanProperty((String)"editor.color.scheme.mark.colors", (boolean)false);
    private final TextAttributesReader myValueReader = new TextAttributesReader();
    private final Properties metaInfo = new Properties();
    protected EditorColorsScheme parentScheme;
    Map<ColorKey, Color> colorMap = new HashMap<ColorKey, Color>();
    Map<@NonNls String, TextAttributes> attributesMap = new HashMap<String, TextAttributes>();
    @NotNull
    private FontPreferences fontPreferences = new DelegatingFontPreferences(() -> AppEditorFontOptions.getInstance().getFontPreferences());
    @NotNull
    private FontPreferences consoleFontPreferences = new DelegatingFontPreferences(() -> this.fontPreferences);
    private String schemeName;
    private boolean canBeDeleted = true;
    private int version = 142;
    private Color deprecatedBackgroundColor = null;
    @VisibleForTesting
    @NotNull
    public static Function<String, EditorColorsScheme> getSchemeById = it -> EditorColorsManager.getInstance().getScheme((String)it);

    protected AbstractColorsScheme(EditorColorsScheme parentScheme) {
        this.parentScheme = parentScheme;
    }

    public AbstractColorsScheme() {
    }

    public void setDefaultMetaInfo(@Nullable AbstractColorsScheme parentScheme) {
        this.metaInfo.setProperty(META_INFO_IDE, PlatformUtils.getPlatformPrefix());
        this.metaInfo.setProperty(META_INFO_IDE_VERSION, ApplicationInfo.getInstance().getStrictVersion());
        if (parentScheme != null && parentScheme != EmptyColorScheme.getEmptyScheme() && !parentScheme.getName().startsWith("_@user_")) {
            this.metaInfo.setProperty(META_INFO_ORIGINAL, parentScheme.getName());
            String pluginId = parentScheme.getMetaProperties().getProperty(META_INFO_PLUGIN_ID);
            if (pluginId != null) {
                this.metaInfo.setProperty(META_INFO_PLUGIN_ID, pluginId);
            }
        }
    }

    @Override
    @NotNull
    public Color getDefaultBackground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getBackgroundColor();
        Color color = c != null ? c : Color.white;
        if (color == null) {
            AbstractColorsScheme.$$$reportNull$$$0(0);
        }
        return color;
    }

    @Override
    @NotNull
    public Color getDefaultForeground() {
        Color c = this.getAttributes(HighlighterColors.TEXT).getForegroundColor();
        Color color = c != null ? c : Color.black;
        if (color == null) {
            AbstractColorsScheme.$$$reportNull$$$0(1);
        }
        return color;
    }

    @NotNull
    public String getName() {
        String string = this.schemeName;
        if (string == null) {
            AbstractColorsScheme.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    public void setName(@NotNull String name) {
        if (name == null) {
            AbstractColorsScheme.$$$reportNull$$$0(3);
        }
        this.schemeName = name;
    }

    @NotNull
    public String getDisplayName() {
        AbstractColorsScheme original;
        if (!this.isReadOnly() && (original = this.getOriginal()) != null && original.isReadOnly()) {
            String string = original.getDisplayName();
            if (string == null) {
                AbstractColorsScheme.$$$reportNull$$$0(4);
            }
            return string;
        }
        String localizedName = this.getLocalizedName();
        if (localizedName == null) {
            String string = Scheme.getBaseName((String)this.getName());
            if (string == null) {
                AbstractColorsScheme.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = localizedName;
        if (string == null) {
            AbstractColorsScheme.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    @Nls
    protected String getLocalizedName() {
        String bundlePath = this.getMetaProperties().getProperty(NAME_BUNDLE_PROPERTY);
        String bundleKey = this.getMetaProperties().getProperty(NAME_KEY_PROPERTY);
        if (bundlePath != null && bundleKey != null) {
            ResourceBundle bundle = DynamicBundle.getResourceBundle((ClassLoader)this.getClass().getClassLoader(), (String)bundlePath);
            return BundleBase.messageOrDefault((ResourceBundle)bundle, (String)bundleKey, null, (Object[])new Object[0]);
        }
        return null;
    }

    @Override
    public abstract Object clone();

    public void copyTo(@NotNull AbstractColorsScheme newScheme) {
        if (newScheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(7);
        }
        boolean noName = newScheme.schemeName == null;
        boolean consoleDelegating = this.consoleFontPreferences instanceof DelegatingFontPreferences;
        boolean editorDelegating = this.fontPreferences instanceof DelegatingFontPreferences;
        if (consoleDelegating) {
            newScheme.setUseEditorFontPreferencesInConsole();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("setConsoleFontPreferences: " + this.consoleFontPreferences.getFontFamily() + ":" + this.consoleFontPreferences.getSize(this.consoleFontPreferences.getFontFamily()));
            }
            newScheme.setConsoleFontPreferences(this.consoleFontPreferences);
        }
        if (editorDelegating) {
            newScheme.setUseAppFontPreferencesInEditor();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("setFontPreferences: " + this.fontPreferences.getFontFamily() + ":" + this.fontPreferences.getSize(this.fontPreferences.getFontFamily()));
            }
            newScheme.setFontPreferences(this.fontPreferences);
        }
        if (LOG.isDebugEnabled()) {
            String delegateInfo = ". Delegate info: Console: " + consoleDelegating + " Editor: " + editorDelegating;
            if (noName) {
                LOG.debug("Copying scheme " + this.debugSchemeName() + " to empty newScheme" + delegateInfo);
            } else {
                LOG.debug("Copying scheme " + this.debugSchemeName() + " to " + newScheme.debugSchemeName() + delegateInfo);
            }
        }
        newScheme.attributesMap = new HashMap<String, TextAttributes>(this.attributesMap);
        newScheme.colorMap = new HashMap<ColorKey, Color>(this.colorMap);
        newScheme.version = this.version;
    }

    @NotNull
    public Set<ColorKey> getColorKeys() {
        Set<ColorKey> set = this.colorMap.keySet();
        if (set == null) {
            AbstractColorsScheme.$$$reportNull$$$0(8);
        }
        return set;
    }

    public @NotNull Map<@NonNls String, TextAttributes> getDirectlyDefinedAttributes() {
        return new HashMap<String, TextAttributes>(this.attributesMap);
    }

    @NotNull
    public Map<ColorKey, Color> getDirectlyDefinedColors() {
        return new HashMap<ColorKey, Color>(this.colorMap);
    }

    @Override
    public void setUseAppFontPreferencesInEditor() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setUseAppFontPreferencesInEditor in " + this.debugSchemeName());
        }
        this.fontPreferences = new DelegatingFontPreferences(() -> AppEditorFontOptions.getInstance().getFontPreferences());
        this.initFonts();
    }

    @Override
    public boolean isUseAppFontPreferencesInEditor() {
        return this.fontPreferences instanceof DelegatingFontPreferences;
    }

    @Override
    public boolean isUseLigatures() {
        return this.getFontPreferences().useLigatures();
    }

    @Override
    public void setUseLigatures(boolean useLigatures) {
        this.ensureEditableFontPreferences().setUseLigatures(useLigatures);
    }

    @Override
    @NotNull
    public Font getFont(EditorFontType key) {
        Font font = this.fontPreferences instanceof DelegatingFontPreferences ? EditorFontCache.getInstance().getFont(key) : super.getFont(key);
        if (font == null) {
            AbstractColorsScheme.$$$reportNull$$$0(9);
        }
        return font;
    }

    @Override
    @NotNull
    public FontPreferences getFontPreferences() {
        FontPreferences fontPreferences = this.fontPreferences;
        if (fontPreferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(10);
        }
        return fontPreferences;
    }

    @Override
    public void setFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(11);
        }
        preferences.copyTo(this.ensureEditableFontPreferences());
        this.initFonts();
    }

    @Override
    @NlsSafe
    public String getEditorFontName() {
        return this.fontPreferences.getFontFamily();
    }

    @Override
    public void setEditorFontName(String fontName) {
        ModifiableFontPreferences currPreferences = this.ensureEditableFontPreferences();
        boolean useLigatures = currPreferences.useLigatures();
        float editorFontSize = this.getEditorFontSize2D();
        if (LOG.isDebugEnabled()) {
            String message = "setEditorFontName=%s for %s. Current name/size: %s:%.2f".formatted(fontName, this.debugSchemeName(), currPreferences.getFontFamily(), Float.valueOf(editorFontSize));
            Throwable stack = new Throwable(message);
            LOG.debug(message, stack);
        }
        currPreferences.clear();
        currPreferences.register(fontName, editorFontSize);
        currPreferences.setUseLigatures(useLigatures);
        this.initFonts();
    }

    @Override
    public int getEditorFontSize() {
        return this.fontPreferences.getSize(this.fontPreferences.getFontFamily());
    }

    @Override
    public void setEditorFontSize(int fontSize) {
        this.setEditorFontSize((float)fontSize);
    }

    @Override
    public void setEditorFontSize(float fontSize) {
        float fixedFontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        if (LOG.isDebugEnabled()) {
            String message = "setEditorFontSize for %s. %.2f (original: %.2f)".formatted(this.debugSchemeName(), Float.valueOf(fixedFontSize), Float.valueOf(fontSize));
            Throwable stack = new Throwable(message);
            LOG.debug(message, stack);
        }
        this.ensureEditableFontPreferences().register(this.fontPreferences.getFontFamily(), fixedFontSize);
        this.initFonts();
        this.setSaveNeeded(true);
    }

    @Override
    public float getEditorFontSize2D() {
        return this.fontPreferences.getSize2D(this.fontPreferences.getFontFamily());
    }

    @Override
    public float getLineSpacing() {
        return this.fontPreferences.getLineSpacing();
    }

    @Override
    public void setLineSpacing(float lineSpacing) {
        this.ensureEditableFontPreferences().setLineSpacing(lineSpacing);
    }

    protected void initFonts() {
        this.reset();
    }

    @Override
    protected EditorColorsScheme getFontCacheScheme() {
        return this;
    }

    @NonNls
    public String toString() {
        return this.getName();
    }

    @Override
    public void readExternal(@NotNull Element parentNode) {
        UISettings settings;
        if (parentNode == null) {
            AbstractColorsScheme.$$$reportNull$$$0(12);
        }
        ColorBlindness blindness = (settings = UISettings.getInstanceOrNull()) == null ? null : settings.getColorBlindness();
        this.myValueReader.setAttribute(blindness == null ? null : blindness.name());
        if (SCHEME_ELEMENT.equals(parentNode.getName())) {
            this.readScheme(parentNode);
        } else {
            List children = parentNode.getChildren(SCHEME_ELEMENT);
            if (children.isEmpty()) {
                throw new InvalidDataException("Scheme is not valid");
            }
            for (Element element : children) {
                this.readScheme(element);
            }
        }
        this.initFonts();
        this.version = 142;
    }

    private void readScheme(@NotNull Element node) {
        boolean isDefault;
        if (node == null) {
            AbstractColorsScheme.$$$reportNull$$$0(13);
        }
        this.deprecatedBackgroundColor = null;
        if (!SCHEME_ELEMENT.equals(node.getName())) {
            return;
        }
        this.setName(node.getAttributeValue("name"));
        int readVersion = Integer.parseInt(node.getAttributeValue(VERSION_ATTR, "0"));
        if (readVersion > 142) {
            throw new IllegalStateException("Unsupported color scheme version: " + readVersion);
        }
        this.version = readVersion;
        String isDefaultScheme = node.getAttributeValue(DEFAULT_SCHEME_ATTR);
        boolean bl = isDefault = isDefaultScheme != null && Boolean.parseBoolean(isDefaultScheme);
        if (!isDefault) {
            this.parentScheme = AbstractColorsScheme.getDefaultScheme(node.getAttributeValue(PARENT_SCHEME_ATTR, EmptyColorScheme.getSchemeName()));
        }
        this.metaInfo.clear();
        Ref fontScale = new Ref();
        boolean clearEditorFonts = true;
        boolean clearConsoleFonts = true;
        for (Element childNode : node.getChildren()) {
            String childName;
            switch (childName = childNode.getName()) {
                case "option": {
                    this.readSettings(childNode, isDefault, (Ref<Float>)fontScale);
                    break;
                }
                case "font": {
                    this.readFontSettings(this.ensureEditableFontPreferences(), childNode, isDefault, (Float)fontScale.get(), clearEditorFonts);
                    clearEditorFonts = false;
                    break;
                }
                case "console-font": {
                    this.readFontSettings(this.ensureEditableConsoleFontPreferences(), childNode, isDefault, (Float)fontScale.get(), clearConsoleFonts);
                    clearConsoleFonts = false;
                    break;
                }
                case "colors": {
                    this.readColors(childNode);
                    break;
                }
                case "attributes": {
                    this.readAttributes(childNode);
                    break;
                }
                case "metaInfo": {
                    this.readMetaInfo(childNode);
                }
            }
        }
        if (this.deprecatedBackgroundColor != null) {
            TextAttributes textAttributes = this.attributesMap.get(HighlighterColors.TEXT.getExternalName());
            if (textAttributes == null) {
                textAttributes = new TextAttributes(Color.black, this.deprecatedBackgroundColor, null, EffectType.BOXED, 0);
                this.attributesMap.put(HighlighterColors.TEXT.getExternalName(), textAttributes);
            } else {
                textAttributes.setBackgroundColor(this.deprecatedBackgroundColor);
            }
        }
        if (this.consoleFontPreferences.getEffectiveFontFamilies().isEmpty()) {
            this.fontPreferences.copyTo(this.consoleFontPreferences);
        }
        this.initFonts();
    }

    private void readMetaInfo(@NotNull Element metaInfoElement) {
        if (metaInfoElement == null) {
            AbstractColorsScheme.$$$reportNull$$$0(14);
        }
        this.metaInfo.clear();
        for (Element e : metaInfoElement.getChildren()) {
            String propertyName;
            if (!PROPERTY_ELEMENT.equals(e.getName()) || (propertyName = e.getAttributeValue("name")) == null) continue;
            this.metaInfo.setProperty(propertyName, e.getText());
        }
    }

    public void readAttributes(@NotNull Element childNode) {
        if (childNode == null) {
            AbstractColorsScheme.$$$reportNull$$$0(15);
        }
        for (Element e : childNode.getChildren(OPTION_ELEMENT)) {
            String keyName = e.getAttributeValue("name");
            Element valueElement = e.getChild(VALUE_ELEMENT);
            Object attr = valueElement != null ? this.myValueReader.readAttributes(valueElement, this.myMarkColorIds ? keyName : null) : (e.getAttributeValue(BASE_ATTRIBUTES_ATTR) != null ? INHERITED_ATTRS_MARKER : null);
            if (attr == null) continue;
            this.attributesMap.put(keyName, (TextAttributes)attr);
        }
    }

    public void readColors(@NotNull Element childNode) {
        if (childNode == null) {
            AbstractColorsScheme.$$$reportNull$$$0(16);
        }
        for (Element colorElement : childNode.getChildren(OPTION_ELEMENT)) {
            String keyName = colorElement.getAttributeValue("name");
            Object valueColor = this.myValueReader.read(Color.class, colorElement);
            if (valueColor != null && keyName != null && this.myMarkColorIds) {
                valueColor = new ColorKeyColor((Color)valueColor, keyName);
            }
            if (valueColor == null && colorElement.getAttributeValue(BASE_ATTRIBUTES_ATTR) != null) {
                valueColor = INHERITED_COLOR_MARKER;
            }
            if (BACKGROUND_COLOR_NAME.equals(keyName)) {
                this.deprecatedBackgroundColor = valueColor;
            }
            ColorKey name = ColorKey.find((String)keyName);
            this.colorMap.put(name, valueColor == null ? NULL_COLOR_MARKER : valueColor);
        }
    }

    private void readSettings(@NotNull Element childNode, boolean isDefault, @NotNull Ref<Float> fontScale) {
        if (childNode == null) {
            AbstractColorsScheme.$$$reportNull$$$0(17);
        }
        if (fontScale == null) {
            AbstractColorsScheme.$$$reportNull$$$0(18);
        }
        switch (childNode.getAttributeValue("name")) {
            case "FONT_SCALE": {
                fontScale.set((Object)this.myValueReader.read(Float.class, childNode));
                break;
            }
            case "LINE_SPACING": {
                Float value = this.myValueReader.read(Float.class, childNode);
                if (value == null) break;
                this.setLineSpacing(value.floatValue());
                break;
            }
            case "EDITOR_FONT_SIZE": {
                float value = this.readFontSize(childNode, isDefault, (Float)fontScale.get());
                if (!(value > 0.0f)) break;
                this.setEditorFontSize(value);
                break;
            }
            case "EDITOR_FONT_NAME": {
                String value = this.myValueReader.read(String.class, childNode);
                if (value == null) break;
                this.setEditorFontName(value);
                break;
            }
            case "CONSOLE_LINE_SPACING": {
                Float value = this.myValueReader.read(Float.class, childNode);
                if (value == null) break;
                this.setConsoleLineSpacing(value.floatValue());
                break;
            }
            case "CONSOLE_FONT_SIZE": {
                float value = this.readFontSize(childNode, isDefault, (Float)fontScale.get());
                if (!(value > 0.0f)) break;
                this.setConsoleFontSize(value);
                break;
            }
            case "CONSOLE_FONT_NAME": {
                String value = this.myValueReader.read(String.class, childNode);
                if (value == null) break;
                this.setConsoleFontName(value);
                break;
            }
            case "EDITOR_LIGATURES": {
                Boolean value = this.myValueReader.read(Boolean.class, childNode);
                if (value == null) break;
                this.ensureEditableFontPreferences().setUseLigatures(value);
                break;
            }
            case "CONSOLE_LIGATURES": {
                Boolean value = this.myValueReader.read(Boolean.class, childNode);
                if (value == null) break;
                this.ensureEditableConsoleFontPreferences().setUseLigatures(value);
            }
        }
    }

    private float readFontSize(Element element, boolean isDefault, Float fontScale) {
        if (isDefault) {
            return UISettings.getDefFontSize();
        }
        Integer intSize = this.myValueReader.read(Integer.class, element);
        if (intSize == null) {
            return -1.0f;
        }
        return UISettings.restoreFontSize(intSize.floatValue(), fontScale);
    }

    private void readFontSettings(@NotNull ModifiableFontPreferences preferences, @NotNull Element element, boolean isDefaultScheme, @Nullable Float fontScale, boolean clearFonts) {
        if (preferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(19);
        }
        if (element == null) {
            AbstractColorsScheme.$$$reportNull$$$0(20);
        }
        if (clearFonts) {
            preferences.clearFonts();
        }
        List children = element.getChildren(OPTION_ELEMENT);
        String fontFamily = null;
        float size = -1.0f;
        for (Element e : children) {
            if (EDITOR_FONT_NAME.equals(e.getAttributeValue("name"))) {
                fontFamily = this.myValueReader.read(String.class, e);
                continue;
            }
            if (!EDITOR_FONT_SIZE.equals(e.getAttributeValue("name"))) continue;
            size = this.readFontSize(e, isDefaultScheme, fontScale);
        }
        if (fontFamily != null && size > 1.0f) {
            preferences.register(fontFamily, size);
        } else if (fontFamily != null) {
            preferences.addFontFamily(fontFamily);
        }
    }

    public void writeExternal(Element parentNode) {
        boolean useOldFontFormat;
        parentNode.setAttribute("name", this.getName());
        parentNode.setAttribute(VERSION_ATTR, Integer.toString(this.version));
        if (!(this.fontPreferences instanceof DelegatingFontPreferences) || !(this.consoleFontPreferences instanceof DelegatingFontPreferences)) {
            JdomKt.addOptionTag((Element)parentNode, (String)FONT_SCALE, (String)String.valueOf(UISettings.getDefFontScale()));
        }
        if (this.parentScheme != null && this.parentScheme != EmptyColorScheme.getEmptyScheme()) {
            parentNode.setAttribute(PARENT_SCHEME_ATTR, this.parentScheme.getName());
        }
        if (!"true".equals(this.metaInfo.getProperty(META_INFO_PARTIAL)) && !this.isReadOnly() && this.getBaseScheme() != this.parentScheme) {
            this.metaInfo.setProperty(META_INFO_PARTIAL, "true");
        }
        if (!this.metaInfo.isEmpty()) {
            parentNode.addContent(this.metaInfoToElement());
        }
        boolean bl = useOldFontFormat = this.fontPreferences.getEffectiveFontFamilies().size() <= 1;
        if (!(this.fontPreferences instanceof DelegatingFontPreferences)) {
            JdomKt.addOptionTag((Element)parentNode, (String)LINE_SPACING, (String)String.valueOf(this.getLineSpacing()));
            if (useOldFontFormat) {
                JdomKt.addOptionTag((Element)parentNode, (String)EDITOR_FONT_SIZE, (String)String.valueOf(this.getEditorFontSize()));
                JdomKt.addOptionTag((Element)parentNode, (String)EDITOR_FONT_NAME, (String)this.fontPreferences.getFontFamily());
            } else {
                AbstractColorsScheme.writeFontPreferences(EDITOR_FONT, parentNode, this.fontPreferences);
            }
            AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.fontPreferences, EDITOR_LIGATURES);
        }
        if (!(this.consoleFontPreferences instanceof DelegatingFontPreferences)) {
            if (this.consoleFontPreferences.getEffectiveFontFamilies().size() <= 1) {
                JdomKt.addOptionTag((Element)parentNode, (String)CONSOLE_FONT_NAME, (String)this.getConsoleFontName());
                if (this.getConsoleFontSize() != this.getEditorFontSize()) {
                    JdomKt.addOptionTag((Element)parentNode, (String)CONSOLE_FONT_SIZE, (String)Integer.toString(this.getConsoleFontSize()));
                }
            } else {
                AbstractColorsScheme.writeFontPreferences(CONSOLE_FONT, parentNode, this.consoleFontPreferences);
            }
            AbstractColorsScheme.writeLigaturesPreferences(parentNode, this.consoleFontPreferences, CONSOLE_LIGATURES);
            if (this.fontPreferences instanceof DelegatingFontPreferences || this.getConsoleLineSpacing() != this.getLineSpacing()) {
                JdomKt.addOptionTag((Element)parentNode, (String)CONSOLE_LINE_SPACING, (String)Float.toString(this.getConsoleLineSpacing()));
            }
        }
        Element colorElements = new Element(COLORS_ELEMENT);
        Element attrElements = new Element(ATTRIBUTES_ELEMENT);
        this.writeColors(colorElements);
        this.writeAttributes(attrElements);
        if (!colorElements.getChildren().isEmpty()) {
            parentNode.addContent(colorElements);
        }
        if (!attrElements.getChildren().isEmpty()) {
            parentNode.addContent(attrElements);
        }
        this.setSaveNeeded(false);
    }

    private void writeAttributes(@NotNull Element attrElements) {
        if (attrElements == null) {
            AbstractColorsScheme.$$$reportNull$$$0(21);
        }
        ArrayList<Map.Entry<String, TextAttributes>> list2 = new ArrayList<Map.Entry<String, TextAttributes>>(this.attributesMap.entrySet());
        list2.sort(Map.Entry.comparingByKey());
        for (Map.Entry entry : list2) {
            String keyName = (String)entry.getKey();
            TextAttributes attributes = (TextAttributes)entry.getValue();
            this.writeAttribute(attrElements, TextAttributesKey.find((String)keyName), attributes);
        }
    }

    private void writeAttribute(@NotNull Element attrElements, @NotNull TextAttributesKey key, @NotNull TextAttributes attributes) {
        if (attrElements == null) {
            AbstractColorsScheme.$$$reportNull$$$0(22);
        }
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(23);
        }
        if (attributes == null) {
            AbstractColorsScheme.$$$reportNull$$$0(24);
        }
        EditorColorsScheme baseScheme = this.getBaseScheme();
        if (attributes == INHERITED_ATTRS_MARKER) {
            boolean parentOverwritingInheritance;
            TextAttributesKey baseKey = key.getFallbackAttributeKey();
            TextAttributes parentAttributes = baseScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)baseScheme).getDirectlyDefinedAttributes(key) : null;
            boolean bl = parentOverwritingInheritance = parentAttributes != null && parentAttributes != INHERITED_ATTRS_MARKER;
            if (parentOverwritingInheritance) {
                attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).setAttribute(BASE_ATTRIBUTES_ATTR, baseKey != null ? baseKey.getExternalName() : ""));
            }
            return;
        }
        if (baseScheme != null) {
            TextAttributes parentAttributes;
            TextAttributes textAttributes = parentAttributes = baseScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)baseScheme).getDirectlyDefinedAttributes(key) : baseScheme.getAttributes(key);
            if (attributes.equals((Object)parentAttributes)) {
                return;
            }
        }
        Element valueElement = new Element(VALUE_ELEMENT);
        attributes.writeExternal(valueElement);
        attrElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).addContent(valueElement));
    }

    public void optimizeAttributeMap() {
        EditorColorsScheme parentScheme = this.parentScheme;
        if (parentScheme == null) {
            return;
        }
        this.attributesMap.entrySet().removeIf(entry -> {
            String keyName = (String)entry.getKey();
            TextAttributes attrs = (TextAttributes)entry.getValue();
            TextAttributesKey key = TextAttributesKey.find((String)keyName);
            if (attrs == INHERITED_ATTRS_MARKER) {
                return !AbstractColorsScheme.hasExplicitlyDefinedAttributes(parentScheme, key);
            }
            TextAttributes parent = parentScheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)parentScheme).getAttributes(key, false) : parentScheme.getAttributes(key);
            return Comparing.equal((Object)parent, (Object)attrs);
        });
        this.colorMap.keySet().removeAll(this.colorMap.keySet().stream().filter(key -> {
            Color color = this.colorMap.get(key);
            if (color == INHERITED_COLOR_MARKER) {
                return !AbstractColorsScheme.hasExplicitlyDefinedColors(parentScheme, key);
            }
            Color parent = parentScheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)parentScheme).getColor((ColorKey)key, false) : parentScheme.getColor((ColorKey)key);
            return Comparing.equal((Object)parent, (Object)(color == NULL_COLOR_MARKER ? null : color));
        }).collect(Collectors.toSet()));
    }

    @NotNull
    private Element metaInfoToElement() {
        Element metaInfoElement = new Element(META_INFO_ELEMENT);
        ArrayList<String> sortedPropertyNames = new ArrayList<String>(this.metaInfo.stringPropertyNames());
        sortedPropertyNames.sort(null);
        for (String propertyName : sortedPropertyNames) {
            String value = this.metaInfo.getProperty(propertyName);
            Element propertyInfo = new Element(PROPERTY_ELEMENT);
            propertyInfo.setAttribute("name", propertyName);
            propertyInfo.setText(value);
            metaInfoElement.addContent(propertyInfo);
        }
        Element element = metaInfoElement;
        if (element == null) {
            AbstractColorsScheme.$$$reportNull$$$0(25);
        }
        return element;
    }

    private void writeColors(@NotNull Element colorElements) {
        if (colorElements == null) {
            AbstractColorsScheme.$$$reportNull$$$0(26);
        }
        ArrayList<ColorKey> list2 = new ArrayList<ColorKey>(this.colorMap.keySet());
        list2.sort(null);
        for (ColorKey key : list2) {
            this.writeColor(colorElements, key);
        }
    }

    private void writeColor(@NotNull Element colorElements, @NotNull ColorKey key) {
        if (colorElements == null) {
            AbstractColorsScheme.$$$reportNull$$$0(27);
        }
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(28);
        }
        EditorColorsScheme baseScheme = this.getBaseScheme();
        Color color = this.colorMap.get(key);
        if (color == INHERITED_COLOR_MARKER) {
            boolean parentOverwritingInheritance;
            ColorKey fallbackKey = key.getFallbackColorKey();
            Color parentFallback = baseScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)baseScheme).getDirectlyDefinedColor(key) : null;
            boolean bl = parentOverwritingInheritance = parentFallback != null && parentFallback != INHERITED_COLOR_MARKER;
            if (fallbackKey != null && parentOverwritingInheritance) {
                colorElements.addContent(new Element(OPTION_ELEMENT).setAttribute("name", key.getExternalName()).setAttribute(BASE_ATTRIBUTES_ATTR, fallbackKey.getExternalName()));
            }
            return;
        }
        if (baseScheme != null) {
            Color parent;
            Color color2 = parent = baseScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)baseScheme).getDirectlyDefinedColor(key) : baseScheme.getColor(key);
            if (parent != null && AbstractColorsScheme.colorsEqual(color, parent)) {
                return;
            }
        }
        Object rgb = "";
        if (color != NULL_COLOR_MARKER) {
            rgb = String.format("%06X", 0xFFFFFF & color.getRGB());
            int alpha = 0xFF & color.getAlpha();
            if (alpha != 255) {
                rgb = (String)rgb + String.format("%02X", alpha);
            }
        }
        JdomKt.addOptionTag((Element)colorElements, (String)key.getExternalName(), (String)rgb);
    }

    @Nullable
    final EditorColorsScheme getBaseScheme() {
        AbstractColorsScheme original;
        if (this.schemeName.startsWith("_@user_") && (original = this.getOriginal()) != null) {
            return original;
        }
        return this.parentScheme;
    }

    private ModifiableFontPreferences ensureEditableFontPreferences() {
        if (!(this.fontPreferences instanceof ModifiableFontPreferences)) {
            FontPreferencesImpl editableFontPreferences = new FontPreferencesImpl();
            this.fontPreferences.copyTo(editableFontPreferences);
            if (LOG.isDebugEnabled()) {
                String message = "ensureEditableFontPreferences in %s. %s, size: %d".formatted(this.debugSchemeName(), editableFontPreferences, ((FontPreferences)editableFontPreferences).getSize(((FontPreferences)editableFontPreferences).getFontFamily()));
                Throwable stack = new Throwable(message);
                LOG.debug(message, stack);
            }
            this.fontPreferences = editableFontPreferences;
            ((FontPreferencesImpl)this.fontPreferences).addChangeListener(source -> this.initFonts());
        }
        return (ModifiableFontPreferences)this.fontPreferences;
    }

    @Override
    @NotNull
    public FontPreferences getConsoleFontPreferences() {
        AppConsoleFontOptions consoleFontOptions = AppConsoleFontOptions.getInstance();
        FontPreferences fontPreferences = consoleFontOptions.isUseEditorFont() ? this.consoleFontPreferences : consoleFontOptions.getFontPreferences();
        if (fontPreferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(29);
        }
        return fontPreferences;
    }

    @Override
    public void setConsoleFontPreferences(@NotNull FontPreferences preferences) {
        if (preferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(30);
        }
        preferences.copyTo(this.ensureEditableConsoleFontPreferences());
        this.initFonts();
    }

    @Override
    public void setUseEditorFontPreferencesInConsole() {
        this.consoleFontPreferences = new DelegatingFontPreferences(() -> this.fontPreferences);
        this.initFonts();
    }

    @Override
    public boolean isUseEditorFontPreferencesInConsole() {
        return this.consoleFontPreferences instanceof DelegatingFontPreferences;
    }

    @Override
    @NotNull
    @NlsSafe
    public String getConsoleFontName() {
        String string = this.getConsoleFontPreferences().getFontFamily();
        if (string == null) {
            AbstractColorsScheme.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Override
    public void setConsoleFontName(String fontName) {
        ModifiableFontPreferences consolePreferences = this.ensureEditableConsoleFontPreferences();
        float consoleFontSize = this.getConsoleFontSize2D();
        consolePreferences.clear();
        consolePreferences.register(fontName, consoleFontSize);
    }

    private ModifiableFontPreferences ensureEditableConsoleFontPreferences() {
        if (!(this.consoleFontPreferences instanceof ModifiableFontPreferences)) {
            FontPreferencesImpl editableFontPreferences = new FontPreferencesImpl();
            this.consoleFontPreferences.copyTo(editableFontPreferences);
            this.consoleFontPreferences = editableFontPreferences;
        }
        return (ModifiableFontPreferences)this.consoleFontPreferences;
    }

    @Override
    public int getConsoleFontSize() {
        return (int)((double)this.getConsoleFontSize2D() + 0.5);
    }

    @Override
    public void setConsoleFontSize(int fontSize) {
        this.setConsoleFontSize((float)fontSize);
    }

    @Override
    public void setConsoleFontSize(float fontSize) {
        ModifiableFontPreferences consoleFontPreferences = this.ensureEditableConsoleFontPreferences();
        fontSize = EditorFontsConstants.checkAndFixEditorFontSize(fontSize);
        consoleFontPreferences.register(this.getConsoleFontName(), fontSize);
        this.initFonts();
    }

    @Override
    public float getConsoleFontSize2D() {
        String font = this.getConsoleFontName();
        UISettings uiSettings = UISettings.getInstanceOrNull();
        if ((uiSettings == null || !uiSettings.getPresentationMode()) && this.getConsoleFontPreferences().hasSize(font)) {
            return this.getConsoleFontPreferences().getSize2D(font);
        }
        return this.getEditorFontSize2D();
    }

    @Override
    public float getConsoleLineSpacing() {
        return this.getConsoleFontPreferences().getLineSpacing();
    }

    @Override
    public void setConsoleLineSpacing(float lineSpacing) {
        this.ensureEditableConsoleFontPreferences().setLineSpacing(lineSpacing);
    }

    @Nullable
    protected TextAttributes getFallbackAttributes(@NotNull TextAttributesKey fallbackKey) {
        if (fallbackKey == null) {
            AbstractColorsScheme.$$$reportNull$$$0(32);
        }
        TextAttributesKey cur = fallbackKey;
        while (true) {
            TextAttributes attrs = this.getDirectlyDefinedAttributes(cur);
            TextAttributesKey next = cur.getFallbackAttributeKey();
            if (attrs != null && (attrs != INHERITED_ATTRS_MARKER || next == null)) {
                return attrs;
            }
            if (next == null) {
                return null;
            }
            cur = next;
        }
    }

    @Nullable
    protected Color getFallbackColor(@NotNull ColorKey fallbackKey) {
        if (fallbackKey == null) {
            AbstractColorsScheme.$$$reportNull$$$0(33);
        }
        ColorKey cur = fallbackKey;
        Color color;
        while ((color = this.getDirectlyDefinedColor(cur)) != NULL_COLOR_MARKER) {
            ColorKey next = cur.getFallbackColorKey();
            if (color != null && (color != INHERITED_COLOR_MARKER || next == null)) {
                return color;
            }
            if (next == null) {
                return null;
            }
            cur = next;
        }
        return null;
    }

    @Nullable
    public TextAttributes getDirectlyDefinedAttributes(@NotNull TextAttributesKey key) {
        TextAttributes attributes;
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(34);
        }
        if ((attributes = this.attributesMap.get(key.getExternalName())) != null) {
            return attributes;
        }
        return this.parentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.parentScheme).getDirectlyDefinedAttributes(key) : null;
    }

    @Nullable
    public Color getDirectlyDefinedColor(@NotNull ColorKey key) {
        Color color;
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(35);
        }
        if ((color = this.colorMap.get(key)) != null) {
            return color;
        }
        return this.parentScheme instanceof AbstractColorsScheme ? ((AbstractColorsScheme)this.parentScheme).getDirectlyDefinedColor(key) : null;
    }

    @NotNull
    public abstract SchemeState getSchemeState();

    public void setSaveNeeded(boolean value) {
    }

    @NotNull
    public Properties getMetaProperties() {
        Properties properties = this.metaInfo;
        if (properties == null) {
            AbstractColorsScheme.$$$reportNull$$$0(36);
        }
        return properties;
    }

    public boolean canBeDeleted() {
        return this.canBeDeleted;
    }

    public void setCanBeDeleted(boolean canBeDeleted) {
        this.canBeDeleted = canBeDeleted;
    }

    public abstract boolean isVisible();

    @Nullable
    public AbstractColorsScheme getOriginal() {
        EditorColorsScheme originalScheme;
        String originalSchemeName = this.getMetaProperties().getProperty(META_INFO_ORIGINAL);
        if (originalSchemeName != null && (originalScheme = getSchemeById.apply(originalSchemeName)) != this && originalScheme instanceof AbstractColorsScheme) {
            return (AbstractColorsScheme)originalScheme;
        }
        return null;
    }

    public EditorColorsScheme getParentScheme() {
        return this.parentScheme;
    }

    @NotNull
    public Element writeScheme() {
        Element root = new Element(SCHEME_ELEMENT);
        this.writeExternal(root);
        Element element = root;
        if (element == null) {
            AbstractColorsScheme.$$$reportNull$$$0(37);
        }
        return element;
    }

    public boolean settingsEqual(Object other) {
        return this.settingsEqual(other, null);
    }

    public boolean settingsEqual(Object other, @Nullable Predicate<? super ColorKey> colorKeyFilter) {
        return this.settingsEqual(other, colorKeyFilter, false);
    }

    public boolean settingsEqual(Object other, @Nullable Predicate<? super ColorKey> colorKeyFilter, boolean ignoreMetaInfo) {
        return this.settingsEqual(other, colorKeyFilter, false, true);
    }

    public boolean settingsEqual(Object other, @Nullable Predicate<? super ColorKey> colorKeyFilter, boolean ignoreMetaInfo, boolean useDefaults) {
        if (!(other instanceof AbstractColorsScheme)) {
            return false;
        }
        AbstractColorsScheme otherScheme = (AbstractColorsScheme)other;
        if (AbstractColorsScheme.getBaseDefaultScheme(this) != AbstractColorsScheme.getBaseDefaultScheme(otherScheme)) {
            return false;
        }
        for (String propertyName : this.metaInfo.stringPropertyNames()) {
            if (ignoreMetaInfo || propertyName.equals(META_INFO_CREATION_TIME) || propertyName.equals(META_INFO_MODIFIED_TIME) || propertyName.equals(META_INFO_IDE) || propertyName.equals(META_INFO_IDE_VERSION) || propertyName.equals(META_INFO_ORIGINAL) || Objects.equals(this.metaInfo.getProperty(propertyName), otherScheme.metaInfo.getProperty(propertyName))) continue;
            return false;
        }
        return AbstractColorsScheme.areDelegatingOrEqual(this.fontPreferences, otherScheme.getFontPreferences()) && AbstractColorsScheme.areDelegatingOrEqual(this.consoleFontPreferences, otherScheme.getConsoleFontPreferences()) && this.attributesEqual(otherScheme, useDefaults) && this.colorsEqual(otherScheme, colorKeyFilter);
    }

    protected boolean attributesEqual(AbstractColorsScheme otherScheme, boolean useDefaults) {
        return this.attributesMap.equals(otherScheme.attributesMap);
    }

    protected boolean colorsEqual(AbstractColorsScheme otherScheme, @Nullable Predicate<? super ColorKey> colorKeyFilter) {
        if (this.colorMap.size() != otherScheme.colorMap.size()) {
            return false;
        }
        for (Map.Entry<ColorKey, Color> entry : this.colorMap.entrySet()) {
            ColorKey key;
            Color c2;
            Color c1 = entry.getValue();
            if (AbstractColorsScheme.colorsEqual(c1, c2 = otherScheme.colorMap.get(key = entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    public void setParent(@NotNull EditorColorsScheme newParent) {
        if (newParent == null) {
            AbstractColorsScheme.$$$reportNull$$$0(38);
        }
        assert (newParent.isReadOnly()) : "New parent scheme must be read-only";
        this.parentScheme = newParent;
    }

    @ApiStatus.Internal
    public void resolveParent(@NotNull Function<? super String, ? extends EditorColorsScheme> nameResolver) {
        if (nameResolver == null) {
            AbstractColorsScheme.$$$reportNull$$$0(39);
        }
        if (this.parentScheme instanceof TemporaryParent) {
            String parentName = ((TemporaryParent)this.parentScheme).getParentName();
            EditorColorsScheme newParent = nameResolver.apply(parentName);
            if (newParent == null || !newParent.isReadOnly()) {
                throw new InvalidDataException(parentName);
            }
            this.parentScheme = newParent;
        } else {
            EditorColorsScheme original;
            String originalSchemeName = this.getMetaProperties().getProperty(META_INFO_ORIGINAL);
            String isPartial = this.getMetaProperties().getProperty(META_INFO_PARTIAL);
            if (originalSchemeName != null && isPartial != null && Boolean.parseBoolean(isPartial) && (original = nameResolver.apply(originalSchemeName)) == null) {
                throw new InvalidDataException(originalSchemeName);
            }
        }
    }

    @ApiStatus.Internal
    public void copyMissingAttributes(@NotNull AbstractColorsScheme sourceScheme) {
        if (sourceScheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(40);
        }
        sourceScheme.colorMap.forEach((key, color) -> this.colorMap.putIfAbsent((ColorKey)key, (Color)color));
        sourceScheme.attributesMap.forEach((key, attributes) -> this.attributesMap.putIfAbsent((String)key, (TextAttributes)attributes));
    }

    private String debugSchemeName() {
        try {
            if (this.schemeName != null) {
                return this.schemeName;
            }
            if (this.parentScheme == null) {
                return null;
            }
            return this.parentScheme.getName();
        }
        catch (Throwable e) {
            LOG.warn("An exception occurred while trying to get scheme name", e);
            return "null(e)";
        }
    }

    @NotNull
    private static EditorColorsScheme getDefaultScheme(@NotNull String name) {
        DefaultColorSchemesManager manager;
        EditorColorsScheme defaultScheme;
        if (name == null) {
            AbstractColorsScheme.$$$reportNull$$$0(41);
        }
        if ((defaultScheme = (manager = DefaultColorSchemesManager.getInstance()).getScheme(name)) == null) {
            defaultScheme = new TemporaryParent(name);
        }
        EditorColorsScheme editorColorsScheme = defaultScheme;
        if (editorColorsScheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(42);
        }
        return editorColorsScheme;
    }

    private static void writeLigaturesPreferences(Element parentNode, FontPreferences preferences, String optionName) {
        if (preferences.useLigatures()) {
            JdomKt.addOptionTag((Element)parentNode, (String)optionName, (String)String.valueOf(true));
        }
    }

    private static void writeFontPreferences(@NotNull String key, @NotNull Element parent, @NotNull FontPreferences preferences) {
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(43);
        }
        if (parent == null) {
            AbstractColorsScheme.$$$reportNull$$$0(44);
        }
        if (preferences == null) {
            AbstractColorsScheme.$$$reportNull$$$0(45);
        }
        for (String fontFamily : preferences.getRealFontFamilies()) {
            Element element = new Element(key);
            JdomKt.addOptionTag((Element)element, (String)EDITOR_FONT_NAME, (String)fontFamily);
            JdomKt.addOptionTag((Element)element, (String)EDITOR_FONT_SIZE, (String)String.valueOf(preferences.getSize(fontFamily)));
            parent.addContent(element);
        }
    }

    private static boolean hasExplicitlyDefinedAttributes(@NotNull EditorColorsScheme scheme, @NotNull TextAttributesKey key) {
        if (scheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(46);
        }
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(47);
        }
        TextAttributes directAttrs = scheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)scheme).getDirectlyDefinedAttributes(key) : null;
        return directAttrs != null && directAttrs != INHERITED_ATTRS_MARKER;
    }

    private static boolean hasExplicitlyDefinedColors(@NotNull EditorColorsScheme scheme, @NotNull ColorKey key) {
        if (scheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(48);
        }
        if (key == null) {
            AbstractColorsScheme.$$$reportNull$$$0(49);
        }
        Color directColor = scheme instanceof DefaultColorsScheme ? ((DefaultColorsScheme)scheme).getDirectlyDefinedColor(key) : null;
        return directColor != null && directColor != INHERITED_COLOR_MARKER;
    }

    protected static boolean colorsEqual(@Nullable Color c1, @Nullable Color c2) {
        if (c1 == NULL_COLOR_MARKER) {
            return c1 == c2;
        }
        return Comparing.equal((Object)c1, (Object)(c2 == NULL_COLOR_MARKER ? null : c2));
    }

    public static boolean isVisible(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(50);
        }
        return !(scheme instanceof AbstractColorsScheme) || ((AbstractColorsScheme)scheme).isVisible();
    }

    protected static boolean areDelegatingOrEqual(@NotNull FontPreferences preferences1, @NotNull FontPreferences preferences2) {
        if (preferences1 == null) {
            AbstractColorsScheme.$$$reportNull$$$0(51);
        }
        if (preferences2 == null) {
            AbstractColorsScheme.$$$reportNull$$$0(52);
        }
        boolean isDelegating1 = preferences1 instanceof DelegatingFontPreferences;
        boolean isDelegating2 = preferences2 instanceof DelegatingFontPreferences;
        return isDelegating1 || isDelegating2 ? isDelegating1 && isDelegating2 : preferences1.equals(preferences2);
    }

    @Nullable
    private static EditorColorsScheme getBaseDefaultScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            AbstractColorsScheme.$$$reportNull$$$0(53);
        }
        if (!(scheme instanceof AbstractColorsScheme)) {
            return null;
        }
        if (scheme instanceof DefaultColorsScheme) {
            return scheme;
        }
        EditorColorsScheme parent = ((AbstractColorsScheme)scheme).parentScheme;
        return parent != null ? AbstractColorsScheme.getBaseDefaultScheme(parent) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 7, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 27, 28, 30, 32, 33, 34, 35, 38, 39, 40, 41, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme";
                break;
            }
            case 3: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newScheme";
                break;
            }
            case 11: 
            case 19: 
            case 30: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaInfoElement";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childNode";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontScale";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrElements";
                break;
            }
            case 23: 
            case 28: 
            case 34: 
            case 35: 
            case 43: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTES_ELEMENT;
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorElements";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fallbackKey";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameResolver";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceScheme";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 46: 
            case 48: 
            case 50: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = SCHEME_ELEMENT;
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences1";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferences2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultBackground";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultForeground";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorKeys";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFont";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFontPreferences";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "metaInfoToElement";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleFontPreferences";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsoleFontName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetaProperties";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "writeScheme";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultScheme";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setFontPreferences";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readScheme";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readMetaInfo";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readAttributes";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "readColors";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readFontSettings";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributes";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "writeColors";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "writeColor";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setConsoleFontPreferences";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackAttributes";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getFallbackColor";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getDirectlyDefinedAttributes";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getDirectlyDefinedColor";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolveParent";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "copyMissingAttributes";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultScheme";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "writeFontPreferences";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitlyDefinedAttributes";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitlyDefinedColors";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isVisible";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "areDelegatingOrEqual";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getBaseDefaultScheme";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 7, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 26, 27, 28, 30, 32, 33, 34, 35, 38, 39, 40, 41, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53 -> new IllegalArgumentException(string);
        };
    }

    private static class TemporaryParent
    extends EditorColorsSchemeImpl {
        private final String myParentName;

        TemporaryParent(@NotNull String parentName) {
            if (parentName == null) {
                TemporaryParent.$$$reportNull$$$0(0);
            }
            super(EmptyColorScheme.getEmptyScheme());
            this.myParentName = parentName;
        }

        @NonNls
        public String getParentName() {
            return this.myParentName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentName", "com/intellij/openapi/editor/colors/impl/AbstractColorsScheme$TemporaryParent", "<init>"));
        }
    }
}

