/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.PersistentRangeHighlighterImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterImpl;
import com.intellij.openapi.editor.impl.RangeHighlighterTree;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.BitUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkupModelImpl
extends UserDataHolderBase
implements MarkupModelEx {
    private static final Logger LOG = Logger.getInstance(MarkupModelImpl.class);
    private final DocumentEx myDocument;
    private volatile RangeHighlighter[] myCachedHighlighters;
    private final List<MarkupModelListener> myListeners;
    private final RangeHighlighterTree myHighlighterTree;
    private final RangeHighlighterTree myHighlighterTreeForLines;

    @ApiStatus.Internal
    protected MarkupModelImpl(@NotNull DocumentEx document) {
        if (document == null) {
            MarkupModelImpl.$$$reportNull$$$0(0);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDocument = document;
        this.myHighlighterTree = new RangeHighlighterTree(this);
        this.myHighlighterTreeForLines = new RangeHighlighterTree(this);
    }

    @Override
    public void dispose() {
        this.myHighlighterTree.dispose();
        this.myHighlighterTreeForLines.dispose();
    }

    public String toString() {
        return "MarkupModel for " + String.valueOf(this.myDocument);
    }

    @Override
    @NotNull
    public RangeHighlighter addLineHighlighter(int line, int layer, @Nullable TextAttributes textAttributes) {
        return this.addLineHighlighter(null, textAttributes, line, layer);
    }

    @Override
    @NotNull
    public RangeHighlighter addLineHighlighter(@Nullable TextAttributesKey textAttributesKey, int lineNumber, int layer) {
        return this.addLineHighlighter(textAttributesKey, null, lineNumber, layer);
    }

    @NotNull
    private RangeHighlighter addLineHighlighter(@Nullable TextAttributesKey textAttributesKey, @Nullable TextAttributes textAttributes, int lineNumber, int layer) {
        Document document = this.getDocument();
        if (!DocumentUtil.isValidLine((int)lineNumber, (Document)document)) {
            throw new IndexOutOfBoundsException("lineNumber:" + lineNumber + ". Must be in [0, " + (document.getLineCount() - 1) + "]");
        }
        int offset = DocumentUtil.getFirstNonSpaceCharOffset((Document)document, (int)lineNumber);
        HighlighterTargetArea area = HighlighterTargetArea.LINES_IN_RANGE;
        Consumer changeAction = textAttributes == null ? null : ex -> ex.setTextAttributes(textAttributes);
        RangeHighlighterEx rangeHighlighterEx = this.addRangeHighlighterAndChangeAttributes(textAttributesKey, offset, offset, layer, area, false, (Consumer<? super RangeHighlighterEx>)changeAction);
        if (rangeHighlighterEx == null) {
            MarkupModelImpl.$$$reportNull$$$0(1);
        }
        return rangeHighlighterEx;
    }

    @Override
    @Nullable
    public RangeHighlighterEx addPersistentLineHighlighter(@Nullable TextAttributesKey textAttributesKey, int lineNumber, int layer) {
        return this.addPersistentLineHighlighter(textAttributesKey, null, lineNumber, layer);
    }

    @Override
    @Nullable
    public RangeHighlighterEx addPersistentLineHighlighter(int lineNumber, int layer, @Nullable TextAttributes textAttributes) {
        return this.addPersistentLineHighlighter(null, textAttributes, lineNumber, layer);
    }

    @Nullable
    private RangeHighlighterEx addPersistentLineHighlighter(@Nullable TextAttributesKey textAttributesKey, @Nullable TextAttributes textAttributes, int lineNumber, int layer) {
        Document document = this.getDocument();
        if (!DocumentUtil.isValidLine((int)lineNumber, (Document)document)) {
            return null;
        }
        int offset = DocumentUtil.getFirstNonSpaceCharOffset((Document)document, (int)lineNumber);
        Consumer changeAction = textAttributes == null ? null : ex -> ex.setTextAttributes(textAttributes);
        PersistentRangeHighlighterImpl highlighter = PersistentRangeHighlighterImpl.create(this, offset, layer, HighlighterTargetArea.LINES_IN_RANGE, textAttributesKey, false);
        this.addRangeHighlighter(highlighter, (Consumer<? super RangeHighlighterEx>)changeAction);
        return highlighter;
    }

    @Override
    @NotNull
    public @NotNull RangeHighlighter @NotNull [] getAllHighlighters() {
        RangeHighlighter[] cachedHighlighters = this.myCachedHighlighters;
        if (cachedHighlighters == null) {
            cachedHighlighters = this.computeAllHighlighters();
            this.myCachedHighlighters = cachedHighlighters;
        }
        if (cachedHighlighters == null) {
            MarkupModelImpl.$$$reportNull$$$0(2);
        }
        return cachedHighlighters;
    }

    @NotNull
    private @NotNull RangeHighlighter @NotNull [] computeAllHighlighters() {
        int size = this.myHighlighterTree.size() + this.myHighlighterTreeForLines.size();
        if (size == 0) {
            if (RangeHighlighter.EMPTY_ARRAY == null) {
                MarkupModelImpl.$$$reportNull$$$0(3);
            }
            return RangeHighlighter.EMPTY_ARRAY;
        }
        ArrayList list2 = new ArrayList(size);
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor(list2);
        this.myHighlighterTree.processAll((Processor)collectProcessor);
        this.myHighlighterTreeForLines.processAll((Processor)collectProcessor);
        RangeHighlighter[] rangeHighlighterArray = list2.toArray(RangeHighlighter.EMPTY_ARRAY);
        if (rangeHighlighterArray == null) {
            MarkupModelImpl.$$$reportNull$$$0(4);
        }
        return rangeHighlighterArray;
    }

    @Override
    @NotNull
    public RangeHighlighterEx addRangeHighlighterAndChangeAttributes(@Nullable TextAttributesKey textAttributesKey, int startOffset, int endOffset, int layer, @NotNull HighlighterTargetArea targetArea, boolean isPersistent, @Nullable Consumer<? super RangeHighlighterEx> changeAttributesAction) {
        if (targetArea == null) {
            MarkupModelImpl.$$$reportNull$$$0(5);
        }
        RangeHighlighterImpl highlighter = isPersistent ? PersistentRangeHighlighterImpl.create(this, startOffset, layer, targetArea, textAttributesKey, true) : new RangeHighlighterImpl(this, startOffset, endOffset, layer, targetArea, textAttributesKey, false, false);
        this.addRangeHighlighter(highlighter, changeAttributesAction);
        RangeHighlighterImpl rangeHighlighterImpl = highlighter;
        if (rangeHighlighterImpl == null) {
            MarkupModelImpl.$$$reportNull$$$0(6);
        }
        return rangeHighlighterImpl;
    }

    private void addRangeHighlighter(@NotNull RangeHighlighterImpl highlighter, @Nullable Consumer<? super RangeHighlighterEx> changeAttributesAction) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(7);
        }
        this.myCachedHighlighters = null;
        if (changeAttributesAction != null) {
            highlighter.changeAttributesNoEvents(changeAttributesAction);
        }
        this.fireAfterAdded(highlighter);
    }

    @Override
    public void changeAttributesInBatch(@NotNull RangeHighlighterEx highlighter, @NotNull Consumer<? super RangeHighlighterEx> changeAttributesAction) {
        byte changeStatus;
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(8);
        }
        if (changeAttributesAction == null) {
            MarkupModelImpl.$$$reportNull$$$0(9);
        }
        if (BitUtil.isSet((byte)(changeStatus = ((RangeHighlighterImpl)highlighter).changeAttributesNoEvents(changeAttributesAction)), (byte)16)) {
            this.fireAttributesChanged(highlighter, BitUtil.isSet((byte)changeStatus, (byte)32), BitUtil.isSet((byte)changeStatus, (byte)64), BitUtil.isSet((byte)changeStatus, (byte)-128));
        }
    }

    public void addRangeHighlighter(@NotNull RangeHighlighterEx marker, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (marker == null) {
            MarkupModelImpl.$$$reportNull$$$0(10);
        }
        this.treeFor(marker).addInterval(marker, start, end, greedyToLeft, greedyToRight, false, layer);
    }

    @NotNull
    RangeHighlighterTree treeFor(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(11);
        }
        RangeHighlighterTree rangeHighlighterTree = highlighter.getTargetArea() == HighlighterTargetArea.EXACT_RANGE ? this.myHighlighterTree : this.myHighlighterTreeForLines;
        if (rangeHighlighterTree == null) {
            MarkupModelImpl.$$$reportNull$$$0(12);
        }
        return rangeHighlighterTree;
    }

    @Override
    @NotNull
    public RangeHighlighter addRangeHighlighter(@Nullable TextAttributesKey textAttributesKey, int startOffset, int endOffset, int layer, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            MarkupModelImpl.$$$reportNull$$$0(13);
        }
        RangeHighlighterEx rangeHighlighterEx = this.addRangeHighlighterAndChangeAttributes(textAttributesKey, startOffset, endOffset, layer, targetArea, false, null);
        if (rangeHighlighterEx == null) {
            MarkupModelImpl.$$$reportNull$$$0(14);
        }
        return rangeHighlighterEx;
    }

    @Override
    @NotNull
    public RangeHighlighter addRangeHighlighter(int startOffset, int endOffset, int layer, @Nullable TextAttributes textAttributes, @NotNull HighlighterTargetArea targetArea) {
        if (targetArea == null) {
            MarkupModelImpl.$$$reportNull$$$0(15);
        }
        Consumer changeAction = textAttributes == null ? null : ex -> ex.setTextAttributes(textAttributes);
        RangeHighlighterEx rangeHighlighterEx = this.addRangeHighlighterAndChangeAttributes(null, startOffset, endOffset, layer, targetArea, false, (Consumer<? super RangeHighlighterEx>)changeAction);
        if (rangeHighlighterEx == null) {
            MarkupModelImpl.$$$reportNull$$$0(16);
        }
        return rangeHighlighterEx;
    }

    @Override
    public void removeHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(17);
        }
        this.myCachedHighlighters = null;
        this.treeFor(highlighter).removeInterval((RangeHighlighterEx)highlighter);
    }

    @Override
    public void removeAllHighlighters() {
        for (RangeHighlighter highlighter : this.getAllHighlighters()) {
            highlighter.dispose();
        }
        this.myCachedHighlighters = null;
        this.myHighlighterTree.clear();
        this.myHighlighterTreeForLines.clear();
    }

    @Override
    @NotNull
    public Document getDocument() {
        DocumentEx documentEx = this.myDocument;
        if (documentEx == null) {
            MarkupModelImpl.$$$reportNull$$$0(18);
        }
        return documentEx;
    }

    @Override
    public void addMarkupModelListener(@NotNull Disposable parentDisposable, @NotNull MarkupModelListener listener2) {
        if (parentDisposable == null) {
            MarkupModelImpl.$$$reportNull$$$0(19);
        }
        if (listener2 == null) {
            MarkupModelImpl.$$$reportNull$$$0(20);
        }
        List<MarkupModelListener> listeners = this.myListeners;
        listeners.add(listener2);
        boolean isRegistered = Disposer.tryRegister((Disposable)parentDisposable, () -> {
            boolean success = listeners.remove(listener2);
            LOG.assertTrue(success);
        });
        if (!isRegistered) {
            listeners.remove(listener2);
        }
    }

    @Override
    public void setRangeHighlighterAttributes(@NotNull RangeHighlighter highlighter, @NotNull TextAttributes textAttributes) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(21);
        }
        if (textAttributes == null) {
            MarkupModelImpl.$$$reportNull$$$0(22);
        }
        ((RangeHighlighterEx)highlighter).setTextAttributes(textAttributes);
    }

    @Override
    @Deprecated
    public void fireAttributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleOrColorChanged) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(23);
        }
        this.fireAttributesChanged(highlighter, renderersChanged, fontStyleOrColorChanged, fontStyleOrColorChanged);
    }

    void fireAttributesChanged(@NotNull RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(24);
        }
        if (highlighter.isValid()) {
            for (MarkupModelListener listener2 : this.myListeners) {
                listener2.attributesChanged(highlighter, renderersChanged, fontStyleChanged, foregroundColorChanged);
            }
        }
        MarkupModelImpl.restoreDeliciousInvariants(highlighter);
    }

    private static void restoreDeliciousInvariants(@NotNull RangeHighlighter highlighter) {
        RangeMarkerTree.RMNode node;
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(25);
        }
        if ((node = ((RangeMarkerImpl)highlighter).myNode) != null) {
            node.attributesChanged();
        }
    }

    private void fireAfterAdded(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(26);
        }
        for (MarkupModelListener listener2 : this.myListeners) {
            listener2.afterAdded(highlighter);
        }
        MarkupModelImpl.restoreDeliciousInvariants(highlighter);
    }

    void fireBeforeRemoved(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(27);
        }
        this.myCachedHighlighters = null;
        for (MarkupModelListener listener2 : this.myListeners) {
            listener2.beforeRemoved(highlighter);
        }
    }

    void fireAfterRemoved(@NotNull RangeHighlighterEx highlighter) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(28);
        }
        for (MarkupModelListener listener2 : this.myListeners) {
            listener2.afterRemoved(highlighter);
        }
    }

    @Override
    public boolean containsHighlighter(@NotNull RangeHighlighter highlighter) {
        if (highlighter == null) {
            MarkupModelImpl.$$$reportNull$$$0(29);
        }
        Processor equalId = h -> h.getId() != ((RangeHighlighterEx)highlighter).getId();
        return highlighter.isValid() && !this.treeFor(highlighter).processOverlappingWith(highlighter.getStartOffset(), highlighter.getEndOffset(), equalId);
    }

    @Override
    public boolean processRangeHighlightersOverlappingWith(int start, int end, @NotNull Processor<? super RangeHighlighterEx> processor) {
        if (processor == null) {
            MarkupModelImpl.$$$reportNull$$$0(30);
        }
        try (MarkupIterator<RangeHighlighterEx> iterator = this.overlappingIterator(start, end);){
            boolean bl = ContainerUtil.process(iterator, processor);
            return bl;
        }
    }

    @Override
    public boolean processRangeHighlightersOutside(int start, int end, @NotNull Processor<? super RangeHighlighterEx> processor) {
        if (processor == null) {
            MarkupModelImpl.$$$reportNull$$$0(31);
        }
        return this.myHighlighterTree.processOverlappingWithOutside(start, end, processor) && this.myHighlighterTreeForLines.processOverlappingWithOutside(start, end, processor);
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset) {
        return this.overlappingIterator(startOffset, endOffset, (byte)0);
    }

    @NotNull
    private MarkupIterator<RangeHighlighterEx> overlappingIterator(int startOffset, int endOffset, byte tastePreference) {
        startOffset = TextRangeScalarUtil.coerce((int)startOffset, (int)0, (int)this.getDocument().getTextLength());
        endOffset = TextRangeScalarUtil.coerce((int)endOffset, (int)startOffset, (int)this.getDocument().getTextLength());
        MarkupIterator markupIterator = IntervalTreeImpl.mergingOverlappingIterator((IntervalTreeImpl)this.myHighlighterTree, (TextRange)new ProperTextRange(startOffset, endOffset), (IntervalTreeImpl)this.myHighlighterTreeForLines, (TextRange)MarkupModelImpl.roundToLineBoundaries(this.getDocument(), startOffset, endOffset), (byte)tastePreference, RangeHighlighterEx.BY_AFFECTED_START_OFFSET);
        if (markupIterator == null) {
            MarkupModelImpl.$$$reportNull$$$0(32);
        }
        return markupIterator;
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingErrorStripeIterator(int startOffset, int endOffset) {
        return this.overlappingIterator(startOffset, endOffset, RangeHighlighterTree.ERROR_STRIPE_FLAG);
    }

    @Override
    @NotNull
    public MarkupIterator<RangeHighlighterEx> overlappingGutterIterator(int startOffset, int endOffset) {
        return this.overlappingIterator(startOffset, endOffset, RangeHighlighterTree.RENDER_IN_GUTTER_FLAG);
    }

    @NotNull
    public static TextRange roundToLineBoundaries(@NotNull Document document, int startOffset, int endOffset) {
        int lineStartOffset;
        if (document == null) {
            MarkupModelImpl.$$$reportNull$$$0(33);
        }
        int textLength = document.getTextLength();
        int n = startOffset <= 0 ? 0 : (lineStartOffset = startOffset > textLength ? textLength : document.getLineStartOffset(document.getLineNumber(startOffset)));
        int lineEndOffset = endOffset <= 0 ? 0 : (endOffset >= textLength ? textLength : document.getLineEndOffset(document.getLineNumber(endOffset)));
        return new ProperTextRange(lineStartOffset, lineEndOffset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 12, 14, 16, 18, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/MarkupModelImpl";
                break;
            }
            case 5: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetArea";
                break;
            }
            case 7: 
            case 8: 
            case 11: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeAttributesAction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "marker";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/MarkupModelImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "addLineHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllHighlighters";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAllHighlighters";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "addRangeHighlighterAndChangeAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "treeFor";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addRangeHighlighter";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "overlappingIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 32: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlighterAndChangeAttributes";
                break;
            }
            case 7: 
            case 10: 
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addRangeHighlighter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "changeAttributesInBatch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "treeFor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "removeHighlighter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addMarkupModelListener";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setRangeHighlighterAttributes";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "fireAttributesChanged";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "restoreDeliciousInvariants";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterAdded";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fireBeforeRemoved";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fireAfterRemoved";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "containsHighlighter";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processRangeHighlightersOverlappingWith";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processRangeHighlightersOutside";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "roundToLineBoundaries";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 12, 14, 16, 18, 32 -> new IllegalStateException(string);
        };
    }
}

