/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.runtime.product.impl;

import com.intellij.platform.runtime.product.IncludedRuntimeModule;
import com.intellij.platform.runtime.product.ProductMode;
import com.intellij.platform.runtime.product.RuntimeModuleGroup;
import com.intellij.platform.runtime.product.RuntimeModuleLoadingRule;
import com.intellij.platform.runtime.product.impl.IncludedRuntimeModuleImpl;
import com.intellij.platform.runtime.product.impl.ProductModeMatcher;
import com.intellij.platform.runtime.product.serialization.RawIncludedRuntimeModule;
import com.intellij.platform.runtime.repository.RuntimeModuleDescriptor;
import com.intellij.platform.runtime.repository.RuntimeModuleId;
import com.intellij.platform.runtime.repository.RuntimeModuleRepository;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class MainRuntimeModuleGroup
implements RuntimeModuleGroup {
    @NotNull
    private final List<RawIncludedRuntimeModule> myRawRootModules;
    private final ProductMode myProductMode;
    private final RuntimeModuleRepository myRepository;
    private volatile List<IncludedRuntimeModule> myIncludedModules;
    private volatile Map<@NotNull RuntimeModuleId, @NotNull List<@NotNull RuntimeModuleId>> myNotIncludedModules;

    public MainRuntimeModuleGroup(@NotNull List<RawIncludedRuntimeModule> rawRootModules, @NotNull ProductMode currentMode, @NotNull RuntimeModuleRepository repository) {
        if (rawRootModules == null) {
            MainRuntimeModuleGroup.$$$reportNull$$$0(0);
        }
        if (currentMode == null) {
            MainRuntimeModuleGroup.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            MainRuntimeModuleGroup.$$$reportNull$$$0(2);
        }
        this.myRawRootModules = rawRootModules;
        this.myProductMode = currentMode;
        this.myRepository = repository;
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull RuntimeModuleId, @NotNull List<@NotNull RuntimeModuleId>> getNotLoadedModuleIds() {
        if (this.myNotIncludedModules == null) {
            this.updateIncludedAndNotIncludedModules();
        }
        Map<RuntimeModuleId, List<RuntimeModuleId>> map = this.myNotIncludedModules;
        if (map == null) {
            MainRuntimeModuleGroup.$$$reportNull$$$0(3);
        }
        return map;
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull RuntimeModuleId> getOptionalModuleIds() {
        Set<RuntimeModuleId> set = this.myRawRootModules.stream().filter(it -> it.getLoadingRule().equals((Object)RuntimeModuleLoadingRule.OPTIONAL)).map(RawIncludedRuntimeModule::getModuleId).collect(Collectors.toSet());
        if (set == null) {
            MainRuntimeModuleGroup.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull IncludedRuntimeModule> getIncludedModules() {
        if (this.myIncludedModules == null) {
            this.updateIncludedAndNotIncludedModules();
        }
        List<IncludedRuntimeModule> list2 = this.myIncludedModules;
        if (list2 == null) {
            MainRuntimeModuleGroup.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private void updateIncludedAndNotIncludedModules() {
        ArrayList<IncludedRuntimeModule> rootIncludedModules = new ArrayList<IncludedRuntimeModule>();
        HashMap<@NotNull RuntimeModuleId, @NotNull List<@NotNull RuntimeModuleId>> rootNotIncludedModules = new HashMap<RuntimeModuleId, List<RuntimeModuleId>>();
        HashSet<RuntimeModuleDescriptor> rootModules = new HashSet<RuntimeModuleDescriptor>();
        ProductModeMatcher matcher = new ProductModeMatcher(this.myProductMode);
        for (RawIncludedRuntimeModule rawRootModule : this.myRawRootModules) {
            IncludedRuntimeModule included = rawRootModule.resolve(this.myRepository);
            if (included != null && matcher.matches(included.getModuleDescriptor())) {
                rootIncludedModules.add(included);
                rootModules.add(included.getModuleDescriptor());
                continue;
            }
            rootNotIncludedModules.put(rawRootModule.getModuleId(), List.of());
        }
        ArrayList<IncludedRuntimeModule> result2 = new ArrayList<IncludedRuntimeModule>(rootIncludedModules);
        HashSet<RuntimeModuleDescriptor> visited = new HashSet<RuntimeModuleDescriptor>();
        for (IncludedRuntimeModule rootModule : rootIncludedModules) {
            MainRuntimeModuleGroup.collectDependencies(rootModule.getModuleDescriptor(), rootModules, visited, result2);
        }
        this.myIncludedModules = result2;
        this.myNotIncludedModules = rootNotIncludedModules;
    }

    private static void collectDependencies(RuntimeModuleDescriptor descriptor, Set<RuntimeModuleDescriptor> rootModules, Set<RuntimeModuleDescriptor> visited, List<IncludedRuntimeModule> result2) {
        for (RuntimeModuleDescriptor dependency : descriptor.getDependencies()) {
            if (!visited.add(dependency)) continue;
            if (!rootModules.contains(dependency)) {
                result2.add(new IncludedRuntimeModuleImpl(dependency, RuntimeModuleLoadingRule.ON_DEMAND));
            }
            MainRuntimeModuleGroup.collectDependencies(dependency, rootModules, visited, result2);
        }
    }

    public String toString() {
        return "MainRuntimeModuleGroup{rootModules=" + String.valueOf(this.myRawRootModules) + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawRootModules";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentMode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/runtime/product/impl/MainRuntimeModuleGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/runtime/product/impl/MainRuntimeModuleGroup";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotLoadedModuleIds";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalModuleIds";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncludedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

